/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.stdlib.http.transport.contractimpl.listener.http2;

import io.ballerina.stdlib.http.transport.contract.ServerConnectorFuture;
import io.ballerina.stdlib.http.transport.contractimpl.common.Util;
import io.ballerina.stdlib.http.transport.contractimpl.listener.http2.Http2ServerChannel;
import io.ballerina.stdlib.http.transport.contractimpl.listener.http2.InboundMessageHolder;
import io.ballerina.stdlib.http.transport.contractimpl.sender.http2.Http2DataEventListener;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http2.Http2Error;
import io.netty.handler.codec.http2.Http2Exception;
import io.netty.handler.codec.http2.Http2Headers;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Http2ServerTimeoutHandler
implements Http2DataEventListener {
    private static final Logger LOG = LoggerFactory.getLogger(Http2ServerTimeoutHandler.class);
    private static final long MIN_TIMEOUT_NANOS = TimeUnit.MILLISECONDS.toNanos(1L);
    private long idleTimeNanos;
    private Http2ServerChannel http2ServerChannel;
    private Map<Integer, ScheduledFuture<?>> timerTasks;
    private ServerConnectorFuture serverConnectorFuture;

    Http2ServerTimeoutHandler(long idleTimeMills, Http2ServerChannel serverChannel, ServerConnectorFuture serverConnectorFuture) {
        this.idleTimeNanos = Math.max(TimeUnit.MILLISECONDS.toNanos(idleTimeMills), MIN_TIMEOUT_NANOS);
        this.http2ServerChannel = serverChannel;
        this.serverConnectorFuture = serverConnectorFuture;
        this.timerTasks = new ConcurrentHashMap();
    }

    @Override
    public boolean onStreamInit(ChannelHandlerContext ctx, int streamId) {
        InboundMessageHolder inboundMsgHolder = this.http2ServerChannel.getInboundMessage(streamId);
        if (inboundMsgHolder != null) {
            inboundMsgHolder.setLastReadWriteTime(Util.ticksInNanos());
            this.timerTasks.put(streamId, Util.schedule(ctx, new IdleTimeoutTask(ctx, streamId), this.idleTimeNanos));
        }
        return true;
    }

    @Override
    public boolean onHeadersRead(ChannelHandlerContext ctx, int streamId, Http2Headers headers, boolean endOfStream) {
        this.updateLastReadTime(streamId);
        return true;
    }

    @Override
    public boolean onDataRead(ChannelHandlerContext ctx, int streamId, ByteBuf data, boolean endOfStream) {
        this.updateLastReadTime(streamId);
        return true;
    }

    @Override
    public boolean onPushPromiseRead(ChannelHandlerContext ctx, int streamId, Http2Headers headers, boolean endOfStream) {
        return true;
    }

    @Override
    public boolean onHeadersWrite(ChannelHandlerContext ctx, int streamId, Http2Headers headers, boolean endOfStream) {
        this.updateLastWriteTime(streamId, endOfStream);
        return true;
    }

    @Override
    public boolean onDataWrite(ChannelHandlerContext ctx, int streamId, ByteBuf data, boolean endOfStream) {
        this.updateLastWriteTime(streamId, endOfStream);
        return true;
    }

    @Override
    public void onStreamReset(int streamId) {
        this.onStreamClose(streamId);
    }

    @Override
    public void onStreamClose(int streamId) {
        ScheduledFuture<?> timerTask = this.timerTasks.get(streamId);
        if (timerTask != null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Server timer is removed for the stream : {}", (Object)streamId);
            }
            timerTask.cancel(false);
            this.timerTasks.remove(streamId);
        }
    }

    @Override
    public void destroy() {
        this.timerTasks.forEach((streamId, task) -> task.cancel(false));
        this.timerTasks.clear();
    }

    private void updateLastReadTime(int streamId) {
        InboundMessageHolder inboundMessage = this.http2ServerChannel.getInboundMessage(streamId);
        if (inboundMessage != null) {
            inboundMessage.setLastReadWriteTime(Util.ticksInNanos());
        }
    }

    private void updateLastWriteTime(int streamId, boolean endOfStream) {
        InboundMessageHolder inboundMessage = this.http2ServerChannel.getInboundMessage(streamId);
        if (inboundMessage != null) {
            inboundMessage.setLastReadWriteTime(Util.ticksInNanos());
        }
        if (endOfStream) {
            this.onStreamClose(streamId);
        }
    }

    private class IdleTimeoutTask
    implements Runnable {
        private ChannelHandlerContext ctx;
        private int streamId;

        IdleTimeoutTask(ChannelHandlerContext ctx, int streamId) {
            this.ctx = ctx;
            this.streamId = streamId;
        }

        @Override
        public void run() {
            InboundMessageHolder msgHolder = Http2ServerTimeoutHandler.this.http2ServerChannel.getInboundMessage(this.streamId);
            if (msgHolder != null) {
                this.runTimeOutLogic(msgHolder);
            }
        }

        private void runTimeOutLogic(InboundMessageHolder msgHolder) {
            long nextDelay = this.getNextDelay(msgHolder);
            if (nextDelay <= 0L) {
                this.handleTimeout(msgHolder);
                this.closeStream(msgHolder, this.streamId, this.ctx);
            } else {
                Http2ServerTimeoutHandler.this.timerTasks.put(this.streamId, Util.schedule(this.ctx, this, nextDelay));
            }
        }

        private long getNextDelay(InboundMessageHolder msgHolder) {
            return Http2ServerTimeoutHandler.this.idleTimeNanos - (Util.ticksInNanos() - msgHolder.getLastReadWriteTime());
        }

        private void handleTimeout(InboundMessageHolder msgHolder) {
            if (msgHolder.getInboundMsg() != null) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Timeout Occurred during {} state", (Object)msgHolder.getInboundMsg().getHttp2MessageStateContext().getListenerState().toString());
                }
                msgHolder.getInboundMsg().getHttp2MessageStateContext().getListenerState().handleStreamTimeout(Http2ServerTimeoutHandler.this.serverConnectorFuture, this.ctx, msgHolder.getHttp2OutboundRespListener(), this.streamId);
            }
        }

        private void closeStream(InboundMessageHolder msgHolder, int streamId, ChannelHandlerContext ctx) {
            try {
                msgHolder.getHttp2OutboundRespListener().resetStream(ctx, streamId, Http2Error.INTERNAL_ERROR);
                Http2ServerTimeoutHandler.this.http2ServerChannel.getStreamIdRequestMap().remove(streamId);
            }
            catch (Http2Exception e) {
                LOG.error("Error sending RST_STREAM: ", e.getCause());
            }
        }
    }
}

