/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.stdlib.http.transport.contractimpl.listener.states.http2;

import io.ballerina.stdlib.http.transport.contract.ServerConnectorFuture;
import io.ballerina.stdlib.http.transport.contract.exceptions.ClientClosedConnectionException;
import io.ballerina.stdlib.http.transport.contract.exceptions.EndpointTimeOutException;
import io.ballerina.stdlib.http.transport.contract.exceptions.ServerConnectorException;
import io.ballerina.stdlib.http.transport.contractimpl.Http2OutboundRespListener;
import io.ballerina.stdlib.http.transport.contractimpl.common.states.Http2MessageStateContext;
import io.ballerina.stdlib.http.transport.contractimpl.common.states.Http2StateUtil;
import io.ballerina.stdlib.http.transport.contractimpl.listener.http2.Http2SourceHandler;
import io.ballerina.stdlib.http.transport.contractimpl.listener.states.http2.ListenerState;
import io.ballerina.stdlib.http.transport.contractimpl.listener.states.http2.SendingEntityBody;
import io.ballerina.stdlib.http.transport.message.Http2DataFrame;
import io.ballerina.stdlib.http.transport.message.Http2HeadersFrame;
import io.ballerina.stdlib.http.transport.message.Http2PushPromise;
import io.ballerina.stdlib.http.transport.message.HttpCarbonMessage;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.HttpContent;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http2.Http2Exception;
import io.netty.util.CharsetUtil;
import java.io.IOException;
import java.nio.charset.Charset;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EntityBodyReceived
implements ListenerState {
    private static final Logger LOG = LoggerFactory.getLogger(EntityBodyReceived.class);
    private final Http2MessageStateContext http2MessageStateContext;

    public EntityBodyReceived(Http2MessageStateContext http2MessageStateContext) {
        this.http2MessageStateContext = http2MessageStateContext;
    }

    @Override
    public void readInboundRequestHeaders(ChannelHandlerContext ctx, Http2HeadersFrame headersFrame) {
        LOG.warn("readInboundRequestHeaders is not a dependant action of this state");
    }

    @Override
    public void readInboundRequestBody(Http2SourceHandler http2SourceHandler, Http2DataFrame dataFrame) {
        LOG.warn("readInboundRequestBody is not a dependant action of this state");
    }

    @Override
    public void writeOutboundResponseHeaders(Http2OutboundRespListener http2OutboundRespListener, HttpCarbonMessage outboundResponseMsg, HttpContent httpContent, int streamId) {
        LOG.warn("writeOutboundResponseHeaders is not a dependant action of this state");
    }

    @Override
    public void writeOutboundResponseBody(Http2OutboundRespListener http2OutboundRespListener, HttpCarbonMessage outboundResponseMsg, HttpContent httpContent, int streamId) throws Http2Exception {
        if (this.http2MessageStateContext.isHeadersSent()) {
            this.http2MessageStateContext.setListenerState(new SendingEntityBody(http2OutboundRespListener, this.http2MessageStateContext));
            this.http2MessageStateContext.getListenerState().writeOutboundResponseBody(http2OutboundRespListener, outboundResponseMsg, httpContent, streamId);
        } else {
            Http2StateUtil.beginResponseWrite(this.http2MessageStateContext, http2OutboundRespListener, outboundResponseMsg, httpContent, streamId);
        }
    }

    @Override
    public void writeOutboundPromise(Http2OutboundRespListener http2OutboundRespListener, Http2PushPromise pushPromise) throws Http2Exception {
        Http2StateUtil.writeHttp2Promise(pushPromise, http2OutboundRespListener.getChannelHandlerContext(), http2OutboundRespListener.getConnection(), http2OutboundRespListener.getEncoder(), http2OutboundRespListener.getInboundRequestMsg(), http2OutboundRespListener.getInboundRequestMsg().getHttpOutboundRespStatusFuture(), http2OutboundRespListener.getOriginalStreamId());
    }

    @Override
    public void handleStreamTimeout(ServerConnectorFuture serverConnectorFuture, ChannelHandlerContext ctx, Http2OutboundRespListener http2OutboundRespListener, int streamId) {
        try {
            serverConnectorFuture.notifyErrorListener(new EndpointTimeOutException("Idle timeout triggered before initiating outbound response", HttpResponseStatus.GATEWAY_TIMEOUT.code()));
        }
        catch (ServerConnectorException e) {
            LOG.error("Idle timeout triggered before initiating outbound response:" + e.getMessage());
        }
        Http2StateUtil.sendRequestTimeoutResponse(ctx, http2OutboundRespListener, streamId, HttpResponseStatus.INTERNAL_SERVER_ERROR, Unpooled.copiedBuffer((CharSequence)"Stream timed out", (Charset)CharsetUtil.UTF_8), false, false);
    }

    @Override
    public void handleAbruptChannelClosure(ServerConnectorFuture serverConnectorFuture, ChannelHandlerContext ctx, Http2OutboundRespListener http2OutboundRespListener, int streamId) {
        try {
            serverConnectorFuture.notifyErrorListener(new ClientClosedConnectionException("Remote client closed the connection before initiating outbound response"));
        }
        catch (ServerConnectorException e) {
            LOG.error("Error while notifying error state to server-connector listener", (Throwable)e);
        }
        http2OutboundRespListener.getOutboundResponseMsg().setIoException(new IOException("Remote client closed the connection before initiating outbound response"));
    }

    @Override
    public void handleClientGoAway(ServerConnectorFuture serverConnectorFuture, ChannelHandlerContext channelHandlerContext, Http2OutboundRespListener http2OutboundRespListener, Integer streamId) {
        try {
            serverConnectorFuture.notifyErrorListener(new ClientClosedConnectionException("Remote client sent GOAWAY before initiating outbound response"));
        }
        catch (ServerConnectorException e) {
            LOG.error("Error while notifying error state to server-connector listener", (Throwable)e);
        }
        http2OutboundRespListener.getOutboundResponseMsg().setIoException(new IOException("Remote client sent GOAWAY before initiating outbound response"));
    }
}

