/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.stdlib.http.transport.contractimpl.sender;

import io.ballerina.stdlib.http.transport.contractimpl.common.certificatevalidation.RevocationVerificationManager;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.ssl.ReferenceCountedOpenSslEngine;
import io.netty.handler.ssl.ocsp.OcspClientHandler;
import java.math.BigInteger;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import javax.net.ssl.SSLSession;
import org.bouncycastle.cert.ocsp.BasicOCSPResp;
import org.bouncycastle.cert.ocsp.CertificateStatus;
import org.bouncycastle.cert.ocsp.OCSPResp;
import org.bouncycastle.cert.ocsp.SingleResp;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OCSPStaplingHandler
extends OcspClientHandler {
    private static final Logger LOG = LoggerFactory.getLogger(OCSPStaplingHandler.class);

    public OCSPStaplingHandler(ReferenceCountedOpenSslEngine engine) {
        super(engine);
    }

    protected boolean verify(ChannelHandlerContext ctx, ReferenceCountedOpenSslEngine engine) throws Exception {
        byte[] staple = engine.getOcspResponse();
        if (staple == null) {
            RevocationVerificationManager revocationVerifier = new RevocationVerificationManager(50, 15);
            return revocationVerifier.verifyRevocationStatus(engine.getSession().getPeerCertificates());
        }
        OCSPResp response = new OCSPResp(staple);
        if (response.getStatus() != 0) {
            return false;
        }
        SSLSession session = engine.getSession();
        Certificate[] chain = session.getPeerCertificates();
        BigInteger certSerial = ((X509Certificate)chain[0]).getSerialNumber();
        BasicOCSPResp basicResponse = (BasicOCSPResp)response.getResponseObject();
        SingleResp singleResp = basicResponse.getResponses()[0];
        CertificateStatus status = singleResp.getCertStatus();
        BigInteger ocspSerial = singleResp.getCertID().getSerialNumber();
        if (LOG.isDebugEnabled()) {
            String message = "OCSP status of " + String.valueOf(ctx.channel().remoteAddress()) + "\n  Status: " + String.valueOf(status == CertificateStatus.GOOD ? "Good" : status) + "\n  This Update: " + String.valueOf(singleResp.getThisUpdate()) + "\n  Next Update: " + String.valueOf(singleResp.getNextUpdate()) + "\n  Cert Serial: " + String.valueOf(certSerial) + "\n  OCSP Serial: " + String.valueOf(ocspSerial);
            LOG.debug(message);
        }
        return status == CertificateStatus.GOOD && certSerial.equals(ocspSerial);
    }
}

