/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.stdlib.http.transport.contractimpl.sender;

import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.handler.codec.TooLongFrameException;
import io.netty.handler.codec.http.HttpResponse;

public class StatusLineAndHeaderLengthValidator
extends ChannelInboundHandlerAdapter {
    public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
        if (msg instanceof HttpResponse) {
            if (!ctx.channel().isActive()) {
                return;
            }
            Throwable cause = ((HttpResponse)msg).decoderResult().cause();
            if (cause instanceof TooLongFrameException) {
                String message = cause.getMessage();
                if (message.contains("HTTP header is larger than")) {
                    throw new RuntimeException("Response max header size exceeds: " + cause.getMessage());
                }
                if (message.contains("An HTTP line is larger than")) {
                    throw new RuntimeException("Response max status line length exceeds: " + cause.getMessage());
                }
                super.channelRead(ctx, msg);
            } else {
                super.channelRead(ctx, msg);
            }
        } else {
            super.channelRead(ctx, msg);
        }
    }
}

