/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.stdlib.http.transport.contractimpl.sender.http2;

import io.ballerina.stdlib.http.transport.contractimpl.common.HttpRoute;
import io.ballerina.stdlib.http.transport.contractimpl.common.states.Http2MessageStateContext;
import io.ballerina.stdlib.http.transport.contractimpl.sender.channel.TargetChannel;
import io.ballerina.stdlib.http.transport.contractimpl.sender.http2.Http2ConnectionManager;
import io.ballerina.stdlib.http.transport.contractimpl.sender.http2.Http2DataEventListener;
import io.ballerina.stdlib.http.transport.contractimpl.sender.http2.OutboundMsgHolder;
import io.netty.buffer.ByteBuf;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.handler.codec.http2.Http2Connection;
import io.netty.handler.codec.http2.Http2EventAdapter;
import io.netty.handler.codec.http2.Http2Stream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Http2ClientChannel {
    private static final Logger LOG = LoggerFactory.getLogger(Http2ClientChannel.class);
    private ConcurrentHashMap<Integer, OutboundMsgHolder> inFlightMessages;
    private ConcurrentHashMap<Integer, OutboundMsgHolder> promisedMessages;
    private Channel channel;
    private Http2Connection connection;
    private ChannelFuture channelFuture;
    private HttpRoute httpRoute;
    private Http2ConnectionManager http2ConnectionManager;
    private AtomicBoolean isExhausted = new AtomicBoolean(false);
    private AtomicInteger activeStreams = new AtomicInteger(1);
    private int socketIdleTimeout = 300000;
    private Map<String, Http2DataEventListener> dataEventListeners;
    private StreamCloseListener streamCloseListener;
    private long timeSinceMarkedAsStale = 0L;
    private AtomicLong timeSinceMarkedAsIdle = new AtomicLong(0L);
    private AtomicBoolean isStale = new AtomicBoolean(false);
    private TargetChannel targetChannel;

    public Http2ClientChannel(Http2ConnectionManager http2ConnectionManager, Http2Connection connection, HttpRoute httpRoute, Channel channel, TargetChannel targetChannel) {
        this.http2ConnectionManager = http2ConnectionManager;
        this.channel = channel;
        this.connection = connection;
        this.httpRoute = httpRoute;
        this.streamCloseListener = new StreamCloseListener(this);
        this.connection.addListener((Http2Connection.Listener)this.streamCloseListener);
        this.dataEventListeners = new HashMap<String, Http2DataEventListener>();
        this.inFlightMessages = new ConcurrentHashMap();
        this.promisedMessages = new ConcurrentHashMap();
        this.targetChannel = targetChannel;
    }

    public Channel getChannel() {
        return this.channel;
    }

    public void setChannel(Channel channel) {
        this.channel = channel;
    }

    public Http2Connection getConnection() {
        return this.connection;
    }

    public ChannelFuture getChannelFuture() {
        return this.channelFuture;
    }

    public void setChannelFuture(ChannelFuture channelFuture) {
        this.channelFuture = channelFuture;
    }

    public void putInFlightMessage(int streamId, OutboundMsgHolder inFlightMessage) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("In flight message added to channel: {} with stream id: {}  ", (Object)this, (Object)streamId);
        }
        this.inFlightMessages.put(streamId, inFlightMessage);
    }

    public OutboundMsgHolder getInFlightMessage(int streamId) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Getting in flight message for stream id: {} from channel: {}", (Object)streamId, (Object)this);
        }
        return this.inFlightMessages.get(streamId);
    }

    public void removeInFlightMessage(int streamId) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("In flight message for stream id: {} removed from channel: {}", (Object)streamId, (Object)this);
        }
        this.inFlightMessages.remove(streamId);
    }

    public void putPromisedMessage(int streamId, OutboundMsgHolder promisedMessage) {
        this.promisedMessages.put(streamId, promisedMessage);
    }

    OutboundMsgHolder getPromisedMessage(int streamId) {
        return this.promisedMessages.get(streamId);
    }

    public void removePromisedMessage(int streamId) {
        this.promisedMessages.remove(streamId);
    }

    int incrementActiveStreamCount() {
        return this.activeStreams.incrementAndGet();
    }

    void markAsExhausted() {
        this.isExhausted.set(true);
    }

    public void addDataEventListener(String name, Http2DataEventListener dataEventListener) {
        this.dataEventListeners.put(name, dataEventListener);
    }

    public List<Http2DataEventListener> getDataEventListeners() {
        return new ArrayList<Http2DataEventListener>(this.dataEventListeners.values());
    }

    public int getSocketIdleTimeout() {
        return this.socketIdleTimeout;
    }

    public void setSocketIdleTimeout(int socketIdleTimeout) {
        this.socketIdleTimeout = socketIdleTimeout;
    }

    void destroy() {
        this.inFlightMessages.forEach((streamId, outboundMsgHolder) -> {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Remove back pressure listener from stream {} ", streamId);
            }
            outboundMsgHolder.getBackPressureObservable().removeListener();
        });
        this.handleConnectionClose();
        this.connection.removeListener((Http2Connection.Listener)this.streamCloseListener);
        this.inFlightMessages.clear();
        this.promisedMessages.clear();
        this.removeFromConnectionPool();
    }

    private void handleConnectionClose() {
        if (!this.inFlightMessages.isEmpty()) {
            this.inFlightMessages.values().forEach(outBoundMsgHolder -> {
                Http2MessageStateContext messageStateContext = outBoundMsgHolder.getRequest().getHttp2MessageStateContext();
                if (messageStateContext != null) {
                    messageStateContext.getSenderState().handleConnectionClose((OutboundMsgHolder)outBoundMsgHolder);
                }
            });
        }
    }

    ConcurrentHashMap<Integer, OutboundMsgHolder> getInFlightMessages() {
        return this.inFlightMessages;
    }

    void removeFromConnectionPool() {
        this.http2ConnectionManager.removeClientChannel(this.httpRoute, this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void markAsStale() {
        Http2ConnectionManager http2ConnectionManager = this.http2ConnectionManager;
        synchronized (http2ConnectionManager) {
            this.isStale.set(true);
            this.http2ConnectionManager.markClientChannelAsStale(this.httpRoute, this);
        }
    }

    void removeClosedChannelFromStalePool() {
        this.http2ConnectionManager.removeClosedChannelFromStalePool(this);
    }

    boolean hasInFlightMessages() {
        return !this.inFlightMessages.isEmpty();
    }

    void setTimeSinceMarkedAsStale(long timeSinceMarkedAsStale) {
        this.timeSinceMarkedAsStale = timeSinceMarkedAsStale;
    }

    long getTimeSinceMarkedAsStale() {
        return this.timeSinceMarkedAsStale;
    }

    void setTimeSinceMarkedAsIdle(long timeSinceMarkedAsIdle) {
        this.timeSinceMarkedAsIdle.set(timeSinceMarkedAsIdle);
    }

    long getTimeSinceMarkedAsIdle() {
        return this.timeSinceMarkedAsIdle.get();
    }

    HttpRoute getHttpRoute() {
        return this.httpRoute;
    }

    public void invalidate() {
        if (this.targetChannel != null) {
            this.targetChannel.invalidate();
        } else {
            LOG.warn("Target channel is not set for the Http2ClientChannel: {}", (Object)this);
        }
    }

    private class StreamCloseListener
    extends Http2EventAdapter {
        private Http2ClientChannel http2ClientChannel;

        StreamCloseListener(Http2ClientChannel http2ClientChannel2) {
            this.http2ClientChannel = http2ClientChannel2;
        }

        public void onStreamClosed(Http2Stream stream) {
            this.http2ClientChannel.removeInFlightMessage(stream.id());
            Http2ClientChannel.this.http2ConnectionManager.markClientChannelAsIdle(this.http2ClientChannel);
            Http2ClientChannel.this.activeStreams.decrementAndGet();
            this.http2ClientChannel.getDataEventListeners().forEach(dataEventListener -> dataEventListener.onStreamClose(stream.id()));
            if (!Http2ClientChannel.this.isStale.get() && Http2ClientChannel.this.isExhausted.getAndSet(false)) {
                Http2ClientChannel.this.http2ConnectionManager.returnClientChannel(Http2ClientChannel.this.httpRoute, this.http2ClientChannel);
            }
        }

        public void onGoAwayReceived(int lastStreamId, long errorCode, ByteBuf debugData) {
            if (Http2ClientChannel.this.isStale.get()) {
                return;
            }
            Http2ClientChannel.this.markAsStale();
            this.http2ClientChannel.inFlightMessages.forEach((streamId, outboundMsgHolder) -> {
                if (streamId > lastStreamId) {
                    this.http2ClientChannel.removeInFlightMessage((int)streamId);
                    Http2ClientChannel.this.activeStreams.decrementAndGet();
                    this.http2ClientChannel.getDataEventListeners().forEach(dataEventListener -> dataEventListener.onStreamClose((int)streamId));
                    Http2MessageStateContext messageStateContext = outboundMsgHolder.getRequest().getHttp2MessageStateContext();
                    if (messageStateContext != null) {
                        messageStateContext.getSenderState().handleServerGoAway((OutboundMsgHolder)outboundMsgHolder);
                    }
                }
            });
        }
    }
}

