/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.stdlib.http.transport.contractimpl.sender.http2;

import io.ballerina.stdlib.http.transport.contract.exceptions.EndpointTimeOutException;
import io.ballerina.stdlib.http.transport.contractimpl.common.Util;
import io.ballerina.stdlib.http.transport.contractimpl.sender.http2.Http2ClientChannel;
import io.ballerina.stdlib.http.transport.contractimpl.sender.http2.Http2DataEventListener;
import io.ballerina.stdlib.http.transport.contractimpl.sender.http2.Http2TargetHandler;
import io.ballerina.stdlib.http.transport.contractimpl.sender.http2.OutboundMsgHolder;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.DecoderException;
import io.netty.handler.codec.DecoderResult;
import io.netty.handler.codec.http.DefaultLastHttpContent;
import io.netty.handler.codec.http.HttpContent;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http2.Http2Error;
import io.netty.handler.codec.http2.Http2Exception;
import io.netty.handler.codec.http2.Http2Headers;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Http2ClientTimeoutHandler
implements Http2DataEventListener {
    private static final Logger LOG = LoggerFactory.getLogger(Http2ClientTimeoutHandler.class);
    private static final long MIN_TIMEOUT_NANOS = TimeUnit.MILLISECONDS.toNanos(1L);
    private long idleTimeNanos;
    private Http2ClientChannel http2ClientChannel;
    private Map<Integer, ScheduledFuture<?>> timerTasks;

    public Http2ClientTimeoutHandler(long idleTimeMills, Http2ClientChannel http2ClientChannel) {
        this.idleTimeNanos = Math.max(TimeUnit.MILLISECONDS.toNanos(idleTimeMills), MIN_TIMEOUT_NANOS);
        this.http2ClientChannel = http2ClientChannel;
        this.timerTasks = new ConcurrentHashMap();
    }

    @Override
    public boolean onStreamInit(ChannelHandlerContext ctx, int streamId) {
        OutboundMsgHolder outboundMsgHolder = this.http2ClientChannel.getInFlightMessage(streamId);
        if (outboundMsgHolder == null) {
            outboundMsgHolder = this.http2ClientChannel.getPromisedMessage(streamId);
        }
        this.setTimerTask(ctx, streamId, outboundMsgHolder);
        return true;
    }

    private void setTimerTask(ChannelHandlerContext ctx, int streamId, OutboundMsgHolder outboundMsgHolder) {
        if (outboundMsgHolder != null) {
            outboundMsgHolder.setLastReadWriteTime(Util.ticksInNanos());
            this.timerTasks.put(streamId, Util.schedule(ctx, new IdleTimeoutTask(ctx, streamId, false), this.idleTimeNanos));
        }
    }

    public void createTimerTask(ChannelHandlerContext ctx, int streamId, long timeOut, boolean expectContinue) {
        this.idleTimeNanos = timeOut;
        this.timerTasks.put(streamId, Util.schedule(ctx, new IdleTimeoutTask(ctx, streamId, expectContinue), TimeUnit.MILLISECONDS.toNanos(timeOut)));
    }

    @Override
    public boolean onHeadersRead(ChannelHandlerContext ctx, int streamId, Http2Headers headers, boolean endOfStream) {
        this.updateLastReadTime(streamId, endOfStream);
        return true;
    }

    @Override
    public boolean onDataRead(ChannelHandlerContext ctx, int streamId, ByteBuf data, boolean endOfStream) {
        this.updateLastReadTime(streamId, endOfStream);
        return true;
    }

    @Override
    public boolean onPushPromiseRead(ChannelHandlerContext ctx, int streamId, Http2Headers headers, boolean endOfStream) {
        this.updateLastReadTime(streamId, endOfStream);
        return true;
    }

    @Override
    public boolean onHeadersWrite(ChannelHandlerContext ctx, int streamId, Http2Headers headers, boolean endOfStream) {
        this.updateLastWriteTime(streamId);
        return true;
    }

    @Override
    public boolean onDataWrite(ChannelHandlerContext ctx, int streamId, ByteBuf data, boolean endOfStream) {
        this.updateLastWriteTime(streamId);
        return true;
    }

    @Override
    public void onStreamReset(int streamId) {
        this.onStreamClose(streamId);
    }

    @Override
    public void onStreamClose(int streamId) {
        ScheduledFuture<?> timerTask = this.timerTasks.get(streamId);
        if (timerTask != null) {
            timerTask.cancel(false);
            this.timerTasks.remove(streamId);
        }
    }

    @Override
    public void destroy() {
        this.timerTasks.forEach((streamId, task) -> task.cancel(false));
        this.timerTasks.clear();
    }

    private void updateLastReadTime(int streamId, boolean endOfStream) {
        OutboundMsgHolder outboundMsgHolder = this.http2ClientChannel.getInFlightMessage(streamId);
        if (outboundMsgHolder == null) {
            outboundMsgHolder = this.http2ClientChannel.getPromisedMessage(streamId);
        }
        if (outboundMsgHolder != null) {
            outboundMsgHolder.setLastReadWriteTime(Util.ticksInNanos());
        }
        if (endOfStream) {
            this.onStreamClose(streamId);
        }
    }

    private void updateLastWriteTime(int streamId) {
        OutboundMsgHolder msgHolder = this.http2ClientChannel.getInFlightMessage(streamId);
        if (msgHolder != null) {
            msgHolder.setLastReadWriteTime(Util.ticksInNanos());
        } else {
            LOG.debug("OutboundMsgHolder may have already been removed for streamId: {}", (Object)streamId);
        }
    }

    public Map<Integer, ScheduledFuture<?>> getTimerTasks() {
        return this.timerTasks;
    }

    public class IdleTimeoutTask
    implements Runnable {
        private ChannelHandlerContext ctx;
        private int streamId;
        private boolean expectContinue;

        IdleTimeoutTask(ChannelHandlerContext ctx, int streamId, boolean expectContinue) {
            this.ctx = ctx;
            this.streamId = streamId;
            this.expectContinue = expectContinue;
        }

        @Override
        public void run() {
            OutboundMsgHolder msgHolder = Http2ClientTimeoutHandler.this.http2ClientChannel.getInFlightMessage(this.streamId);
            OutboundMsgHolder promiseHolder = Http2ClientTimeoutHandler.this.http2ClientChannel.getPromisedMessage(this.streamId);
            if (msgHolder != null) {
                this.runTimeOutLogic(msgHolder, true);
            } else if (promiseHolder != null) {
                this.runTimeOutLogic(promiseHolder, false);
            }
        }

        private void runTimeOutLogic(OutboundMsgHolder msgHolder, boolean primary) {
            long nextDelay = this.getNextDelay(msgHolder);
            if (nextDelay <= 0L) {
                if (!this.expectContinue) {
                    this.closeStream(this.streamId, this.ctx);
                }
                if (primary) {
                    this.handlePrimaryResponseTimeout(msgHolder);
                } else {
                    this.handlePushResponseTimeout(msgHolder);
                }
            } else {
                Http2ClientTimeoutHandler.this.timerTasks.put(this.streamId, Util.schedule(this.ctx, this, nextDelay));
            }
        }

        private void handlePrimaryResponseTimeout(OutboundMsgHolder msgHolder) {
            if (msgHolder.getResponse() != null) {
                this.handleIncompleteResponse(msgHolder, true);
            } else {
                this.notifyTimeoutError(msgHolder, true);
            }
            if (!this.expectContinue) {
                Http2ClientTimeoutHandler.this.http2ClientChannel.removeInFlightMessage(this.streamId);
            }
        }

        private void handlePushResponseTimeout(OutboundMsgHolder promiseHolder) {
            if (promiseHolder.getPushResponse(this.streamId) != null) {
                this.handleIncompleteResponse(promiseHolder, false);
            } else {
                this.notifyTimeoutError(promiseHolder, false);
            }
            Http2ClientTimeoutHandler.this.http2ClientChannel.removePromisedMessage(this.streamId);
        }

        private void handleIncompleteResponse(OutboundMsgHolder msgHolder, boolean primary) {
            DefaultLastHttpContent lastHttpContent = new DefaultLastHttpContent();
            lastHttpContent.setDecoderResult(DecoderResult.failure((Throwable)new DecoderException(this.getErrorMessage(primary))));
            msgHolder.getResponse().addHttpContent((HttpContent)lastHttpContent);
            LOG.warn(this.getErrorMessage(primary));
        }

        private String getErrorMessage(boolean primary) {
            return primary ? "Idle timeout triggered while reading inbound response entity body" : "Idle timeout triggered while reading push response entity body";
        }

        private void closeStream(int streamId, ChannelHandlerContext ctx) {
            Http2TargetHandler clientOutboundHandler = (Http2TargetHandler)ctx.pipeline().get("http2TargetHandler");
            clientOutboundHandler.resetStream(ctx, streamId, Http2Error.STREAM_CLOSED);
        }

        private void notifyTimeoutError(OutboundMsgHolder msgHolder, boolean primary) {
            if (primary) {
                try {
                    msgHolder.getRequest().getHttp2MessageStateContext().getSenderState().handleStreamTimeout(msgHolder, false, this.ctx, this.streamId);
                }
                catch (Http2Exception e) {
                    msgHolder.getResponseFuture().notifyHttpListener(new EndpointTimeOutException("Remote host closed the connection while writing outbound request entity body", HttpResponseStatus.GATEWAY_TIMEOUT.code()));
                }
            } else {
                msgHolder.getResponseFuture().notifyPushResponse(this.streamId, new EndpointTimeOutException("Idle timeout triggered before initiating push response", HttpResponseStatus.GATEWAY_TIMEOUT.code()));
            }
        }

        private long getNextDelay(OutboundMsgHolder msgHolder) {
            return Http2ClientTimeoutHandler.this.idleTimeNanos - (Util.ticksInNanos() - msgHolder.getLastReadWriteTime());
        }
    }
}

