/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.stdlib.http.uri.parser;

import io.ballerina.stdlib.http.uri.URITemplateException;
import io.ballerina.stdlib.http.uri.parser.DataElement;
import io.ballerina.stdlib.http.uri.parser.DataElementFactory;
import io.ballerina.stdlib.http.uri.parser.Literal;
import io.ballerina.stdlib.http.uri.parser.Node;
import io.ballerina.stdlib.http.uri.parser.SimpleStringExpression;
import java.io.UnsupportedEncodingException;

public class URITemplateParser<DataType, InboundMgsType> {
    private static final char[] operators = new char[]{'+', '.', '/', ';', '?', '&', '#'};
    private Node<DataType, InboundMgsType> syntaxTree;
    private Node<DataType, InboundMgsType> currentNode;
    private final DataElementFactory<? extends DataElement<DataType, InboundMgsType>> elementCreator;

    public URITemplateParser(Node<DataType, InboundMgsType> rootNode, DataElementFactory<? extends DataElement<DataType, InboundMgsType>> elementCreator) {
        this.syntaxTree = rootNode;
        this.elementCreator = elementCreator;
    }

    public Node<DataType, InboundMgsType> parse(String template, DataType resource) throws URITemplateException, UnsupportedEncodingException {
        if (!"/".equals(template) && template.endsWith("/")) {
            template = template.substring(0, template.length() - 1);
        }
        if ("/".equals(template)) {
            this.syntaxTree.getDataElement().setData(resource);
            return this.syntaxTree;
        }
        int expressionIndex = 0;
        String[] segments = template.split("/");
        for (int currentElement = 0; currentElement < segments.length; ++currentElement) {
            String segment = segments[currentElement];
            boolean expression = false;
            int startIndex = 0;
            int maxIndex = segment.length() - 1;
            block6: for (int pointerIndex = 0; pointerIndex < segment.length(); ++pointerIndex) {
                char ch = segment.charAt(pointerIndex);
                switch (ch) {
                    case '{': {
                        if (expression) {
                            throw new URITemplateException("Already in expression");
                        }
                        if (pointerIndex + 1 >= maxIndex) {
                            throw new URITemplateException("Illegal open brace character");
                        }
                        expression = true;
                        if (pointerIndex > startIndex) {
                            this.addNode(new Literal<DataType, InboundMgsType>(this.createElement(), segment.substring(startIndex, pointerIndex)));
                            startIndex = pointerIndex + 1;
                            continue block6;
                        }
                        ++startIndex;
                        continue block6;
                    }
                    case '}': {
                        if (!expression) {
                            throw new URITemplateException("Illegal closing brace detected");
                        }
                        if (pointerIndex <= startIndex) {
                            throw new URITemplateException("Illegal empty expression");
                        }
                        expression = false;
                        String token = segment.substring(startIndex, pointerIndex);
                        this.createExpressionNode(token, segment, maxIndex, pointerIndex, expressionIndex++);
                        startIndex = pointerIndex + 1;
                        continue block6;
                    }
                    case '*': {
                        if (pointerIndex == 0 && currentElement != segments.length - 1) {
                            throw new URITemplateException("/* is only allowed at the end of the Path");
                        }
                    }
                    default: {
                        if (pointerIndex != maxIndex) continue block6;
                        String tokenVal = segment.substring(startIndex);
                        if (expression) {
                            this.createExpressionNode(tokenVal, segment, maxIndex, pointerIndex, expressionIndex++);
                            continue block6;
                        }
                        this.addNode(new Literal<DataType, InboundMgsType>(this.createElement(), tokenVal));
                    }
                }
            }
        }
        this.currentNode.getDataElement().setData(resource);
        return this.syntaxTree;
    }

    private void addNode(Node<DataType, InboundMgsType> node) throws URITemplateException {
        if (this.currentNode == null) {
            this.currentNode = this.syntaxTree;
        }
        this.currentNode = this.currentNode.addChild(node);
    }

    private void createExpressionNode(String expression, String segment, int maxIndex, int pointerIndex, int expressionIndex) throws URITemplateException {
        if (maxIndex != pointerIndex) {
            throw new URITemplateException("Template expression: " + segment + " is not implemented");
        }
        SimpleStringExpression<DataType, InboundMgsType> node = new SimpleStringExpression<DataType, InboundMgsType>(this.createElement(), expression, expressionIndex);
        if (expression.length() < 1) {
            throw new URITemplateException("Invalid template expression: {" + expression + "}");
        }
        this.addNode(node);
    }

    private DataElement<DataType, InboundMgsType> createElement() {
        return this.elementCreator.createDataElement();
    }
}

