/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.stdlib.udp;

import io.ballerina.runtime.api.Module;
import io.ballerina.runtime.api.Runtime;
import io.ballerina.runtime.api.concurrent.StrandMetadata;
import io.ballerina.runtime.api.creators.ErrorCreator;
import io.ballerina.runtime.api.creators.ValueCreator;
import io.ballerina.runtime.api.types.MethodType;
import io.ballerina.runtime.api.types.ObjectType;
import io.ballerina.runtime.api.types.Parameter;
import io.ballerina.runtime.api.types.Type;
import io.ballerina.runtime.api.utils.StringUtils;
import io.ballerina.runtime.api.utils.TypeUtils;
import io.ballerina.runtime.api.values.BArray;
import io.ballerina.runtime.api.values.BError;
import io.ballerina.runtime.api.values.BMap;
import io.ballerina.runtime.api.values.BObject;
import io.ballerina.stdlib.udp.UdpListener;
import io.ballerina.stdlib.udp.UdpService;
import io.ballerina.stdlib.udp.Utils;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import io.netty.channel.socket.DatagramPacket;
import java.net.InetSocketAddress;
import java.util.Arrays;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Dispatcher {
    private static final Logger log = LoggerFactory.getLogger(Dispatcher.class);

    private Dispatcher() {
    }

    private static void invokeOnBytes(UdpService udpService, DatagramPacket datagramPacket, Channel channel, Type[] parameterTypes) {
        try {
            Object[] params = Dispatcher.getOnBytesSignature(datagramPacket, channel, parameterTypes);
            Dispatcher.invokeAsyncCall(udpService, datagramPacket, channel, "onBytes", params);
        }
        catch (BError e) {
            Dispatcher.invokeOnError(udpService, e.getMessage());
        }
    }

    private static void invokeOnDatagram(UdpService udpService, DatagramPacket datagramPacket, Channel channel, Type[] parameterTypes) {
        try {
            Object[] params = Dispatcher.getOnDatagramSignature(datagramPacket, channel, parameterTypes);
            Dispatcher.invokeAsyncCall(udpService, datagramPacket, channel, "onDatagram", params);
        }
        catch (BError e) {
            Dispatcher.invokeOnError(udpService, e.getMessage());
        }
    }

    public static void invokeOnError(UdpService udpService, String message) {
        try {
            ObjectType objectType = (ObjectType)TypeUtils.getReferredType((Type)TypeUtils.getType((Object)udpService.getService()));
            MethodType methodType = Arrays.stream(objectType.getMethods()).filter(m -> m.getName().equals("onError")).findFirst().orElse(null);
            if (methodType != null) {
                Object[] params = Dispatcher.getOnErrorSignature(message);
                Dispatcher.invokeAsyncCall(udpService, null, null, "onError", params);
            }
        }
        catch (Throwable t) {
            log.error("Error while executing onError function", t);
        }
    }

    private static void invokeAsyncCall(UdpService udpService, DatagramPacket datagramPacket, Channel channel, String methodName, Object[] params) {
        Thread.startVirtualThread(() -> {
            BObject service = udpService.getService();
            Runtime runtime = udpService.getRuntime();
            ObjectType objectType = (ObjectType)TypeUtils.getReferredType((Type)TypeUtils.getType((Object)service));
            StrandMetadata metadata = new StrandMetadata(objectType.isIsolated() && objectType.isIsolated(methodName), null);
            try {
                Object result = runtime.callMethod(service, methodName, metadata, params);
                Dispatcher.handleResult(udpService, datagramPacket, channel, result);
            }
            catch (BError error) {
                Dispatcher.handleError(error);
            }
            catch (Throwable throwable) {
                Dispatcher.handleError(ErrorCreator.createError((Throwable)throwable));
            }
        });
    }

    private static Object[] getOnBytesSignature(DatagramPacket datagramPacket, Channel channel, Type[] parameterTypes) {
        byte[] byteContent = new byte[((ByteBuf)datagramPacket.content()).readableBytes()];
        ((ByteBuf)datagramPacket.content()).readBytes(byteContent);
        Object[] bValues = new Object[parameterTypes.length];
        int index = 0;
        block4: for (Type param : parameterTypes) {
            int paramTag = param.getTag();
            switch (paramTag) {
                case 34: {
                    bValues[index++] = ValueCreator.createReadonlyArrayValue((byte[])byteContent);
                    continue block4;
                }
                case 47: {
                    bValues[index++] = Dispatcher.createClient(datagramPacket, channel);
                    continue block4;
                }
            }
        }
        return bValues;
    }

    private static Object[] getOnDatagramSignature(DatagramPacket datagramPacket, Channel channel, Type[] parameterTypes) {
        Object[] bValues = new Object[parameterTypes.length];
        int index = 0;
        block4: for (Type param : parameterTypes) {
            int paramTag = param.getTag();
            switch (paramTag) {
                case 34: {
                    bValues[index++] = Utils.createReadOnlyDatagramWithSenderAddress(datagramPacket);
                    continue block4;
                }
                case 47: {
                    bValues[index++] = Dispatcher.createClient(datagramPacket, channel);
                    continue block4;
                }
            }
        }
        return bValues;
    }

    private static Object[] getOnErrorSignature(String message) {
        return new Object[]{Utils.createUdpError(message)};
    }

    private static BObject createClient(DatagramPacket datagramPacket, Channel channel) {
        BObject caller = ValueCreator.createObjectValue((Module)Utils.getUdpPackage(), (String)"Caller", (Object[])new Object[0]);
        caller.set(StringUtils.fromString((String)"remotePort"), (Object)((InetSocketAddress)datagramPacket.sender()).getPort());
        caller.set(StringUtils.fromString((String)"remoteHost"), (Object)StringUtils.fromString((String)((InetSocketAddress)datagramPacket.sender()).getHostName()));
        caller.addNativeData("Channel", (Object)channel);
        return caller;
    }

    public static void invokeRead(UdpService udpService, DatagramPacket datagramPacket, Channel channel) {
        ObjectType objectType = (ObjectType)TypeUtils.getReferredType((Type)TypeUtils.getType((Object)udpService.getService()));
        block8: for (MethodType method : objectType.getMethods()) {
            switch (method.getName()) {
                case "onBytes": {
                    Dispatcher.invokeOnBytes(udpService, datagramPacket, channel, Dispatcher.getParameterTypes(method.getType().getParameters()));
                    continue block8;
                }
                case "onDatagram": {
                    Dispatcher.invokeOnDatagram(udpService, datagramPacket, channel, Dispatcher.getParameterTypes(method.getType().getParameters()));
                    continue block8;
                }
            }
        }
    }

    private static Type[] getParameterTypes(Parameter[] parameters) {
        Type[] parameterTypes = new Type[parameters.length];
        for (int i = 0; i < parameters.length; ++i) {
            parameterTypes[i] = parameters[i].type;
        }
        return parameterTypes;
    }

    private static void handleResult(UdpService udpService, DatagramPacket datagramP, Channel channel, Object object) {
        if (object instanceof BArray) {
            byte[] byteContent = ((BArray)object).getBytes();
            UdpListener.send(udpService, new DatagramPacket(Unpooled.wrappedBuffer((byte[])byteContent), (InetSocketAddress)datagramP.sender()), channel);
        } else if (object instanceof BMap) {
            BMap datagram = (BMap)object;
            String host = datagram.getStringValue(StringUtils.fromString((String)"remoteHost")).getValue();
            int port = datagram.getIntValue(StringUtils.fromString((String)"remotePort")).intValue();
            BArray data = datagram.getArrayValue(StringUtils.fromString((String)"data"));
            byte[] byteContent = data.getBytes();
            DatagramPacket datagramPacket = new DatagramPacket(Unpooled.wrappedBuffer((byte[])byteContent), new InetSocketAddress(host, port));
            UdpListener.send(udpService, datagramPacket, channel);
        } else if (object instanceof BError) {
            ((BError)((Object)object)).printStackTrace();
        }
        log.debug("Method successfully dispatched.");
    }

    public static void handleError(BError bError) {
        bError.printStackTrace();
    }
}

