/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.stdlib.udp;

import io.ballerina.stdlib.udp.UdpClientHandler;
import io.ballerina.stdlib.udp.UdpConnectClientHandler;
import io.ballerina.stdlib.udp.Utils;
import io.netty.bootstrap.Bootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.socket.DatagramPacket;
import io.netty.channel.socket.nio.NioDatagramChannel;
import io.netty.handler.timeout.IdleStateHandler;
import io.netty.util.concurrent.EventExecutor;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.GenericFutureListener;
import io.netty.util.concurrent.ImmediateEventExecutor;
import io.netty.util.concurrent.Promise;
import io.netty.util.concurrent.PromiseCombiner;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.LinkedList;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;

public class UdpClient {
    private Channel channel;
    private final Bootstrap clientBootstrap = new Bootstrap();

    public UdpClient(InetSocketAddress localAddress, InetSocketAddress remoteAddress, EventLoopGroup group, CompletableFuture<Object> balFuture) {
        ((Bootstrap)((Bootstrap)this.clientBootstrap.group(group)).channel(NioDatagramChannel.class)).handler((ChannelHandler)new ChannelInitializer<Channel>(this){

            protected void initChannel(Channel ch) throws Exception {
                ch.pipeline().addLast("clientHandler", (ChannelHandler)new UdpClientHandler());
            }
        });
        if (remoteAddress != null) {
            this.connect(remoteAddress, localAddress, balFuture);
        }
    }

    public UdpClient(InetSocketAddress localAddress, EventLoopGroup group, CompletableFuture<Object> balFuture) {
        ((Bootstrap)((Bootstrap)((Bootstrap)this.clientBootstrap.group(group)).channel(NioDatagramChannel.class)).handler((ChannelHandler)new ChannelInitializer<Channel>(this){

            protected void initChannel(Channel ch) throws Exception {
                ch.pipeline().addLast("clientHandler", (ChannelHandler)new UdpClientHandler());
            }
        })).bind((SocketAddress)localAddress).addListener((GenericFutureListener)((ChannelFutureListener)future -> {
            if (future.isSuccess()) {
                this.channel = future.channel();
                this.channel.config().setAutoRead(false);
                balFuture.complete(null);
            } else {
                balFuture.complete(Utils.createUdpError("Error initializing UDP Client"));
            }
        }));
    }

    private void connect(SocketAddress remoteAddress, SocketAddress localAddress, CompletableFuture<Object> balFuture) {
        this.clientBootstrap.connect(remoteAddress, localAddress).addListener((GenericFutureListener)((ChannelFutureListener)future -> {
            if (future.isSuccess()) {
                this.channel = future.channel();
                this.channel.pipeline().replace("clientHandler", "connectClientHandler", (ChannelHandler)new UdpConnectClientHandler());
                this.channel.config().setAutoRead(false);
                balFuture.complete(null);
            } else {
                balFuture.complete(Utils.createUdpError("Can't connect to remote host: " + future.cause().getMessage()));
            }
        }));
    }

    public void sendData(DatagramPacket datagram, CompletableFuture<Object> balFuture) {
        LinkedList<DatagramPacket> fragments = Utils.fragmentDatagram(datagram);
        PromiseCombiner promiseCombiner = this.getPromiseCombiner(fragments);
        promiseCombiner.finish((Promise)this.channel.newPromise().addListener((GenericFutureListener)((ChannelFutureListener)future -> {
            if (future.isSuccess()) {
                balFuture.complete(null);
            } else {
                balFuture.complete(Utils.createUdpError("Failed to send data: " + future.cause().getMessage()));
            }
        })));
    }

    private PromiseCombiner getPromiseCombiner(LinkedList<DatagramPacket> fragments) {
        PromiseCombiner promiseCombiner = new PromiseCombiner((EventExecutor)ImmediateEventExecutor.INSTANCE);
        while (!fragments.isEmpty()) {
            if (!this.channel.isWritable()) continue;
            promiseCombiner.add((Future)this.channel.writeAndFlush((Object)fragments.poll()));
        }
        return promiseCombiner;
    }

    public void receiveData(double readTimeoutInSec, CompletableFuture<Object> balFuture) {
        long readTimeoutInNano = (long)(readTimeoutInSec * 1.0E9);
        this.channel.pipeline().addFirst("readTimeoutHandler", (ChannelHandler)new IdleStateHandler(readTimeoutInNano, 0L, 0L, TimeUnit.NANOSECONDS));
        if (this.channel.pipeline().get("clientHandler") != null) {
            UdpClientHandler handler = (UdpClientHandler)this.channel.pipeline().get("clientHandler");
            handler.setBalFuture(balFuture);
        } else {
            UdpConnectClientHandler handler = (UdpConnectClientHandler)this.channel.pipeline().get("connectClientHandler");
            handler.setBalFuture(balFuture);
        }
        this.channel.read();
    }

    public void close(CompletableFuture<Object> balFuture) {
        this.channel.close().addListener((GenericFutureListener)((ChannelFutureListener)future -> {
            if (future.isSuccess()) {
                balFuture.complete(null);
            } else {
                balFuture.complete(Utils.createUdpError("Unable to close the  UDP client. " + future.cause().getMessage()));
            }
        }));
    }
}

