/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.stdlib.udp;

import io.ballerina.stdlib.udp.Utils;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.channel.socket.DatagramPacket;
import io.netty.handler.timeout.IdleStateEvent;
import java.net.PortUnreachableException;
import java.util.concurrent.CompletableFuture;

public class UdpClientHandler
extends SimpleChannelInboundHandler<DatagramPacket> {
    protected CompletableFuture<Object> balFuture;

    protected void channelRead0(ChannelHandlerContext ctx, DatagramPacket datagramPacket) throws Exception {
        ctx.channel().pipeline().remove("readTimeoutHandler");
        this.balFuture.complete(Utils.createReadonlyDatagramWithRecipientAddress(datagramPacket));
    }

    public void userEventTriggered(ChannelHandlerContext ctx, Object evt) throws Exception {
        if (evt instanceof IdleStateEvent) {
            ctx.channel().pipeline().remove("readTimeoutHandler");
            this.balFuture.complete(Utils.createUdpError("Read timed out"));
        }
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        ctx.channel().pipeline().remove("readTimeoutHandler");
        Object errorMsg = cause.getMessage();
        if (cause instanceof PortUnreachableException) {
            errorMsg = "Port unreachable (" + String.valueOf(ctx.channel().remoteAddress()) + ")";
        }
        this.balFuture.complete(Utils.createUdpError((String)errorMsg));
    }

    public void setBalFuture(CompletableFuture<Object> balFuture) {
        this.balFuture = balFuture;
    }
}

