/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.stdlib.udp.nativelistener;

import io.ballerina.runtime.api.Environment;
import io.ballerina.runtime.api.utils.StringUtils;
import io.ballerina.runtime.api.values.BMap;
import io.ballerina.runtime.api.values.BObject;
import io.ballerina.runtime.api.values.BString;
import io.ballerina.stdlib.udp.UdpFactory;
import io.ballerina.stdlib.udp.UdpListener;
import io.ballerina.stdlib.udp.UdpService;
import io.ballerina.stdlib.udp.Utils;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.util.concurrent.CompletableFuture;

public final class Listener {
    private Listener() {
    }

    public static Object init(BObject listener, int localPort, BMap<BString, Object> config) {
        listener.addNativeData("ListenerConfiguration", config);
        listener.addNativeData("localPort", (Object)localPort);
        return null;
    }

    public static Object register(Environment env, BObject listener, BObject service) {
        listener.addNativeData("service", (Object)new UdpService(env.getRuntime(), service));
        return null;
    }

    public static Object start(Environment env, BObject listener) {
        return env.yieldAndRun(() -> {
            InetSocketAddress localAddress;
            CompletableFuture<Object> balFuture = new CompletableFuture<Object>();
            BMap config = (BMap)listener.getNativeData("ListenerConfiguration");
            BString localHost = config.getStringValue(StringUtils.fromString((String)"localHost"));
            int localPort = (Integer)listener.getNativeData("localPort");
            if (localHost == null) {
                localAddress = new InetSocketAddress(localPort);
            } else {
                String hostname = localHost.getValue();
                localAddress = new InetSocketAddress(hostname, localPort);
            }
            BString remoteHost = config.getStringValue(StringUtils.fromString((String)"remoteHost"));
            Long remotePort = config.getIntValue(StringUtils.fromString((String)"remotePort"));
            try {
                UdpService udpService = (UdpService)listener.getNativeData("service");
                InetSocketAddress remoteAddress = Listener.getRemoteAddress(remoteHost, remotePort);
                UdpListener udpListener = UdpFactory.getInstance().createUdpListener(localAddress, remoteAddress, balFuture, udpService);
                listener.addNativeData("listener", (Object)udpListener);
            }
            catch (Exception e) {
                balFuture.complete(Utils.createUdpError(e.getMessage()));
            }
            return Utils.getResult(balFuture);
        });
    }

    public static Object detach(BObject listener) {
        UdpService service = (UdpService)listener.getNativeData("service");
        if (service == null) {
            return Utils.createUdpError("service is not attached to the listener");
        }
        listener.addNativeData("service", null);
        return null;
    }

    public static Object gracefulStop(Environment env, BObject listener) {
        return env.yieldAndRun(() -> {
            CompletableFuture<Object> balFuture = new CompletableFuture<Object>();
            try {
                UdpListener udpListener = (UdpListener)listener.getNativeData("listener");
                if (udpListener != null) {
                    udpListener.close(balFuture);
                } else {
                    balFuture.complete(Utils.createUdpError("Unable to initialize the udp listener."));
                }
            }
            catch (InterruptedException e) {
                balFuture.complete(Utils.createUdpError("Failed to gracefully shutdown the Listener."));
            }
            return Utils.getResult(balFuture);
        });
    }

    private static InetSocketAddress getRemoteAddress(BString remoteHost, Long remotePort) throws Exception {
        if (remoteHost != null && remotePort == null || remoteHost == null && remotePort != null) {
            throw new Exception("Required both remoteHost and remotePort to connect to remote address.");
        }
        if (remoteHost != null && remotePort != null) {
            return new InetSocketAddress(InetAddress.getByName(remoteHost.getValue()).getHostAddress(), (int)remotePort.longValue());
        }
        return null;
    }
}

