/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.datamapper;

import io.ballerina.compiler.api.SemanticModel;
import io.ballerina.compiler.api.symbols.RecordFieldSymbol;
import io.ballerina.compiler.api.symbols.RecordTypeSymbol;
import io.ballerina.compiler.api.symbols.Symbol;
import io.ballerina.compiler.api.symbols.TypeDescKind;
import io.ballerina.compiler.api.symbols.TypeReferenceTypeSymbol;
import io.ballerina.compiler.api.symbols.TypeSymbol;
import io.ballerina.compiler.api.symbols.VariableSymbol;
import io.ballerina.compiler.syntax.tree.BasicLiteralNode;
import io.ballerina.compiler.syntax.tree.ExpressionNode;
import io.ballerina.compiler.syntax.tree.IdentifierToken;
import io.ballerina.compiler.syntax.tree.MappingConstructorExpressionNode;
import io.ballerina.compiler.syntax.tree.MappingFieldNode;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NodeVisitor;
import io.ballerina.compiler.syntax.tree.QualifiedNameReferenceNode;
import io.ballerina.compiler.syntax.tree.SeparatedNodeList;
import io.ballerina.compiler.syntax.tree.SimpleNameReferenceNode;
import io.ballerina.compiler.syntax.tree.SpecificFieldNode;
import io.ballerina.compiler.syntax.tree.SpreadFieldNode;
import io.ballerina.compiler.syntax.tree.SyntaxKind;
import io.ballerina.compiler.syntax.tree.TypeDescriptorNode;
import io.ballerina.compiler.syntax.tree.VariableDeclarationNode;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;

public class DataMapperNodeVisitor
extends NodeVisitor {
    public final HashMap<String, String> restFields = new HashMap();
    public final HashMap<String, Map<String, RecordFieldSymbol>> spreadFields = new HashMap();
    public final ArrayList<String> specificFieldList;
    private final String rhsSymbolName;
    private SemanticModel model;

    public DataMapperNodeVisitor(String rhsSymbolName) {
        this.rhsSymbolName = rhsSymbolName;
        this.specificFieldList = new ArrayList();
    }

    public void setModel(SemanticModel model) {
        this.model = model;
    }

    public void visit(VariableDeclarationNode variableDeclarationNode) {
        if (variableDeclarationNode.initializer().isEmpty()) {
            return;
        }
        if (((ExpressionNode)variableDeclarationNode.initializer().get()).kind() != SyntaxKind.MAPPING_CONSTRUCTOR) {
            return;
        }
        String rightSymbolName = "";
        TypeDescriptorNode typeDescriptorNode = variableDeclarationNode.typedBindingPattern().typeDescriptor();
        if (typeDescriptorNode.kind() == SyntaxKind.SIMPLE_NAME_REFERENCE) {
            rightSymbolName = ((SimpleNameReferenceNode)typeDescriptorNode).name().text();
        } else if (typeDescriptorNode.kind() == SyntaxKind.QUALIFIED_NAME_REFERENCE) {
            rightSymbolName = ((QualifiedNameReferenceNode)typeDescriptorNode).identifier().text();
        }
        if (rightSymbolName.isEmpty()) {
            return;
        }
        if (this.rhsSymbolName.equals(rightSymbolName)) {
            MappingConstructorExpressionNode mappingConstructorExpressionNode = (MappingConstructorExpressionNode)variableDeclarationNode.initializer().get();
            SeparatedNodeList fields = mappingConstructorExpressionNode.fields();
            for (MappingFieldNode field : fields) {
                SpreadFieldNode field1;
                Optional symbol;
                if (field.kind() == SyntaxKind.SPECIFIC_FIELD) {
                    String fieldName;
                    SpecificFieldNode specificFieldNode = (SpecificFieldNode)field;
                    if (specificFieldNode.fieldName().kind() == SyntaxKind.STRING_LITERAL) {
                        fieldName = ((BasicLiteralNode)specificFieldNode.fieldName()).literalToken().text();
                        fieldName = fieldName.replace("\"", "");
                        Optional symbol2 = this.model.symbol((Node)variableDeclarationNode);
                        if (!symbol2.isPresent()) continue;
                        TypeSymbol typeSymbol = ((VariableSymbol)symbol2.get()).typeDescriptor();
                        typeSymbol = ((TypeReferenceTypeSymbol)typeSymbol).typeDescriptor();
                        String restFieldType = ((TypeSymbol)((RecordTypeSymbol)typeSymbol).restTypeDescriptor().get()).typeKind().getName();
                        this.restFields.put(fieldName, restFieldType);
                        continue;
                    }
                    if (specificFieldNode.fieldName().kind() != SyntaxKind.IDENTIFIER_TOKEN) continue;
                    fieldName = ((IdentifierToken)specificFieldNode.fieldName()).text();
                    this.specificFieldList.add(fieldName);
                    continue;
                }
                if (field.kind() != SyntaxKind.SPREAD_FIELD || !(symbol = this.model.symbol((Node)(field1 = (SpreadFieldNode)field).valueExpr())).isPresent()) continue;
                TypeSymbol typeSymbol = ((VariableSymbol)symbol.get()).typeDescriptor();
                if ((typeSymbol = ((TypeReferenceTypeSymbol)typeSymbol).typeDescriptor()).typeKind() != TypeDescKind.RECORD) continue;
                Map fieldSymbolMap = ((RecordTypeSymbol)typeSymbol).fieldDescriptors();
                if (!((Symbol)symbol.get()).getName().isPresent()) continue;
                this.spreadFields.put((String)((Symbol)symbol.get()).getName().get(), fieldSymbolMap);
            }
        }
    }
}

