/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.openapi.cmd;

import io.ballerina.compiler.syntax.tree.SyntaxTree;
import io.ballerina.compiler.syntax.tree.TypeDefinitionNode;
import io.ballerina.openapi.cmd.CmdConstants;
import io.ballerina.openapi.cmd.CmdUtils;
import io.ballerina.openapi.core.generators.client.BallerinaClientGenerator;
import io.ballerina.openapi.core.generators.client.BallerinaClientGeneratorWithStatusCodeBinding;
import io.ballerina.openapi.core.generators.client.BallerinaTestGenerator;
import io.ballerina.openapi.core.generators.client.diagnostic.ClientDiagnostic;
import io.ballerina.openapi.core.generators.client.exception.ClientException;
import io.ballerina.openapi.core.generators.client.mock.AdvanceMockClientGenerator;
import io.ballerina.openapi.core.generators.client.mock.BallerinaMockClientGenerator;
import io.ballerina.openapi.core.generators.client.model.OASClientConfig;
import io.ballerina.openapi.core.generators.common.GeneratorUtils;
import io.ballerina.openapi.core.generators.common.SingleFileGenerator;
import io.ballerina.openapi.core.generators.common.TypeHandler;
import io.ballerina.openapi.core.generators.common.exception.BallerinaOpenApiException;
import io.ballerina.openapi.core.generators.common.model.Filter;
import io.ballerina.openapi.core.generators.common.model.GenSrcFile;
import io.ballerina.openapi.core.generators.service.ServiceGenerationHandler;
import io.ballerina.openapi.core.generators.service.model.OASServiceMetadata;
import io.ballerina.openapi.core.generators.type.exception.OASTypeGenException;
import io.ballerina.tools.diagnostics.Diagnostic;
import io.swagger.v3.oas.models.OpenAPI;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.ballerinalang.formatter.core.Formatter;
import org.ballerinalang.formatter.core.FormatterException;

public class BallerinaCodeGenerator {
    private String srcPackage;
    private String licenseHeader = "";
    private boolean includeTestFiles;
    private List<Diagnostic> diagnostics = new ArrayList<Diagnostic>();
    private static final PrintStream outStream = System.out;

    public void generateClientAndService(String definitionPath, String serviceName, String outPath, Filter filter, ClientServiceGeneratorOptions options) throws IOException, FormatterException, BallerinaOpenApiException, OASTypeGenException, ClientException {
        Path srcPath = Paths.get(outPath, new String[0]);
        Path implPath = BallerinaCodeGenerator.getImplPath(this.srcPackage, srcPath);
        ArrayList<GenSrcFile> sourceFiles = new ArrayList<GenSrcFile>();
        Path openAPIPath = Path.of(definitionPath, new String[0]);
        OpenAPI openAPIDef = GeneratorUtils.getOpenAPIFromOpenAPIV3Parser((Path)openAPIPath);
        this.checkOpenAPIVersion(openAPIDef);
        String serviceTitle = serviceName.toLowerCase(Locale.ENGLISH);
        String srcFile = String.format("%s_service.bal", serviceTitle);
        List complexPaths = GeneratorUtils.getComplexPaths((OpenAPI)openAPIDef);
        boolean isResource = options.isResource;
        if (!complexPaths.isEmpty()) {
            isResource = false;
            outStream.println("WARNING: remote function(s) will be generated for client and the service generation can not proceed due to the openapi definition contain following complex path(s):");
            for (String path : complexPaths) {
                outStream.println(path);
            }
        }
        OpenAPI normalizedOpenAPI = GeneratorUtils.normalizeOpenAPI((OpenAPI)openAPIDef, (!isResource ? 1 : 0) != 0, (boolean)options.isSanitizedOas);
        TypeHandler.createInstance((OpenAPI)normalizedOpenAPI, (boolean)options.nullable);
        OASClientConfig.Builder clientMetaDataBuilder = new OASClientConfig.Builder();
        OASClientConfig oasClientConfig = clientMetaDataBuilder.withFilters(filter).withNullable(options.nullable).withPlugin(false).withOpenAPI(normalizedOpenAPI).withResourceMode(isResource).withStatusCodeBinding(options.statusCodeBinding).withMock(options.isMock).build();
        BallerinaClientGenerator clientGenerator = BallerinaCodeGenerator.getBallerinaClientGenerator(oasClientConfig);
        String clientContent = Formatter.format((SyntaxTree)clientGenerator.generateSyntaxTree()).toSourceCode();
        List authNodes = clientGenerator.getBallerinaAuthConfigGenerator().getAuthRelatedTypeDefinitionNodes();
        for (TypeDefinitionNode typeDef : authNodes) {
            TypeHandler.getInstance().addTypeDefinitionNode(typeDef.typeName().text(), typeDef);
        }
        sourceFiles.add(new GenSrcFile(GenSrcFile.GenFileType.GEN_SRC, this.srcPackage, "client.bal", (this.licenseHeader.isBlank() ? "// AUTO-GENERATED FILE. DO NOT MODIFY.\n// This file is auto-generated by the Ballerina OpenAPI tool.\n\n" : this.licenseHeader) + clientContent));
        String utilContent = Formatter.format((SyntaxTree)clientGenerator.getBallerinaUtilGenerator().generateUtilSyntaxTree()).toString();
        if (!utilContent.isBlank()) {
            sourceFiles.add(new GenSrcFile(GenSrcFile.GenFileType.UTIL_SRC, this.srcPackage, "utils.bal", (this.licenseHeader.isBlank() ? "// AUTO-GENERATED FILE.\n// This file is auto-generated by the Ballerina OpenAPI tool.\n\n" : this.licenseHeader) + utilContent));
        }
        if (complexPaths.isEmpty()) {
            OASServiceMetadata oasServiceMetadata = new OASServiceMetadata.Builder().withOpenAPI(normalizedOpenAPI).withFilters(filter).withNullable(options.nullable).withGenerateServiceType(options.generateServiceType).withGenerateServiceContract(options.generateServiceContract).withGenerateWithoutDataBinding(options.generateWithoutDataBinding).withSrcFile(srcFile).withSrcPackage(this.srcPackage).withLicenseHeader(this.licenseHeader).build();
            ServiceGenerationHandler serviceGenerationHandler = new ServiceGenerationHandler();
            sourceFiles.addAll(serviceGenerationHandler.generateServiceFiles(oasServiceMetadata));
            this.diagnostics.addAll(serviceGenerationHandler.getDiagnostics());
        }
        TypeHandler typeHandler = TypeHandler.getInstance();
        SyntaxTree schemaSyntaxTree = typeHandler.generateTypeSyntaxTree();
        String schemaContent = Formatter.format((SyntaxTree)schemaSyntaxTree).toSourceCode();
        this.diagnostics.addAll(TypeHandler.getInstance().getDiagnostics());
        this.generateSchemaFile(sourceFiles, schemaContent, this.licenseHeader);
        if (this.includeTestFiles) {
            BallerinaTestGenerator ballerinaTestGenerator = new BallerinaTestGenerator(clientGenerator);
            String testContent = Formatter.format((SyntaxTree)ballerinaTestGenerator.generateSyntaxTree()).toSourceCode();
            sourceFiles.add(new GenSrcFile(GenSrcFile.GenFileType.GEN_SRC, this.srcPackage, "test.bal", (this.licenseHeader.isBlank() ? "// AUTO-GENERATED FILE.\n// This file is auto-generated by the Ballerina OpenAPI tool.\n\n" : this.licenseHeader) + testContent));
            String configContent = ballerinaTestGenerator.getConfigTomlFile();
            if (!configContent.isBlank()) {
                sourceFiles.add(new GenSrcFile(GenSrcFile.GenFileType.GEN_SRC, this.srcPackage, "Config.toml", configContent));
            }
        }
        List<GenSrcFile> newGenFiles = sourceFiles.stream().filter(BallerinaCodeGenerator.distinctByKey(GenSrcFile::getFileName)).collect(Collectors.toList());
        List clientDiagnostic = clientGenerator.getDiagnostics();
        for (ClientDiagnostic diagnostic : clientDiagnostic) {
            outStream.println(String.valueOf(diagnostic.getDiagnosticSeverity()) + ":" + diagnostic.getMessage());
        }
        this.printDiagnostic(this.diagnostics);
        this.writeGeneratedSources(newGenFiles, srcPath, implPath, CmdConstants.GenType.GEN_BOTH);
    }

    public static <T> Predicate<T> distinctByKey(Function<? super T, ?> keyExtractor) {
        ConcurrentHashMap seen = new ConcurrentHashMap();
        return t -> seen.putIfAbsent(keyExtractor.apply(t), Boolean.TRUE) == null;
    }

    public void generateClient(String definitionPath, String outPath, Filter filter, ClientGeneratorOptions options) throws IOException, FormatterException, BallerinaOpenApiException, OASTypeGenException {
        Path srcPath = Paths.get(outPath, new String[0]);
        Path implPath = BallerinaCodeGenerator.getImplPath(this.srcPackage, srcPath);
        List<GenSrcFile> genFiles = null;
        try {
            genFiles = this.generateClientFiles(Paths.get(definitionPath, new String[0]), filter, options);
            if (!genFiles.isEmpty()) {
                this.writeGeneratedSources(genFiles, srcPath, implPath, CmdConstants.GenType.GEN_CLIENT);
            }
        }
        catch (ClientException e) {
            outStream.println("error occurred while generating the client: " + e.getMessage());
        }
    }

    public void generateService(String definitionPath, String serviceName, String outPath, Filter filter, ServiceGeneratorOptions options) throws IOException, BallerinaOpenApiException, FormatterException {
        Path srcPath = Paths.get(outPath, new String[0]);
        Path implPath = BallerinaCodeGenerator.getImplPath(this.srcPackage, srcPath);
        List<GenSrcFile> genFiles = this.generateBallerinaService(Paths.get(definitionPath, new String[0]), serviceName, filter, options);
        if (genFiles.isEmpty()) {
            return;
        }
        this.diagnostics.forEach(diagnostic -> outStream.println(String.format("%s: %s", diagnostic.diagnosticInfo().severity(), diagnostic.message())));
        this.writeGeneratedSources(genFiles, srcPath, implPath, CmdConstants.GenType.GEN_SERVICE);
    }

    private void writeGeneratedSources(List<GenSrcFile> sources, Path srcPath, Path implPath, CmdConstants.GenType type) throws IOException {
        Object files;
        ArrayList<File> listFiles = new ArrayList<File>();
        if (Files.exists(srcPath, new LinkOption[0]) && (files = new File(String.valueOf(srcPath)).listFiles()) != null) {
            listFiles.addAll(Arrays.asList(files));
            for (Object file : files) {
                File[] innerFiles;
                if (!((File)file).isDirectory() || !((File)file).getName().equals("tests") || (innerFiles = new File(String.valueOf(srcPath) + "/tests").listFiles()) == null) continue;
                listFiles.addAll(Arrays.asList(innerFiles));
            }
        }
        for (File file : listFiles) {
            for (GenSrcFile gFile : sources) {
                String userInput;
                if (!file.getName().equals(gFile.getFileName()) || System.console() == null || Objects.equals((userInput = System.console().readLine("There is already a/an " + file.getName() + " in the location. Do you want to override the file? [y/N] ", new Object[0])).toLowerCase(Locale.ENGLISH), "y")) continue;
                int duplicateCount = 0;
                CmdUtils.setGeneratedFileName(listFiles, gFile, duplicateCount);
            }
        }
        for (GenSrcFile genSrcFile : sources) {
            boolean isDuplicatedFileInTests;
            Path filePath;
            if (!genSrcFile.getType().isOverwritable()) {
                filePath = implPath.resolve(genSrcFile.getFileName());
                if (!Files.notExists(filePath, new LinkOption[0])) continue;
                String fileContent = genSrcFile.getContent();
                BallerinaCodeGenerator.writeFile(filePath, fileContent);
                continue;
            }
            boolean bl = isDuplicatedFileInTests = genSrcFile.getFileName().matches("test.+[0-9]+.bal") || genSrcFile.getFileName().matches("Config.+[0-9]+.toml");
            if (genSrcFile.getFileName().equals("test.bal") || genSrcFile.getFileName().equals("Config.toml") || isDuplicatedFileInTests) {
                Files.createDirectories(Paths.get(String.valueOf(srcPath) + "/tests", new String[0]), new FileAttribute[0]);
                filePath = Paths.get(srcPath.resolve("tests/" + genSrcFile.getFileName()).toFile().getCanonicalPath(), new String[0]);
            } else {
                filePath = Paths.get(srcPath.resolve(genSrcFile.getFileName()).toFile().getCanonicalPath(), new String[0]);
            }
            String fileContent = genSrcFile.getContent();
            BallerinaCodeGenerator.writeFile(filePath, fileContent);
        }
        if (type.equals((Object)CmdConstants.GenType.GEN_SERVICE)) {
            outStream.println("Service generated successfully and the OpenAPI contract is copied to path " + String.valueOf(srcPath) + ".");
        } else if (type.equals((Object)CmdConstants.GenType.GEN_CLIENT)) {
            outStream.println("Client generated successfully.");
        }
        outStream.println("Following files were created.");
        Iterator<GenSrcFile> iterator = sources.iterator();
        while (iterator.hasNext()) {
            outStream.println("-- " + iterator.next().getFileName());
        }
    }

    private List<GenSrcFile> generateClientFiles(Path openAPI, Filter filter, ClientGeneratorOptions options) throws IOException, BallerinaOpenApiException, FormatterException, ClientException {
        if (this.srcPackage == null || this.srcPackage.isEmpty()) {
            this.srcPackage = "client";
        }
        ArrayList<GenSrcFile> sourceFiles = new ArrayList<GenSrcFile>();
        OpenAPI openAPIDef = GeneratorUtils.getOpenAPIFromOpenAPIV3Parser((Path)openAPI);
        this.checkOpenAPIVersion(openAPIDef);
        List complexPaths = GeneratorUtils.getComplexPaths((OpenAPI)openAPIDef);
        boolean isResource = options.isResource;
        if (!complexPaths.isEmpty()) {
            outStream.println("WARNING: remote function(s) will be generated for client as the given openapi definition contains following complex path(s):");
            for (String path : complexPaths) {
                outStream.println(path);
            }
            isResource = false;
        }
        OpenAPI normalizedOpenAPI = GeneratorUtils.normalizeOpenAPI((OpenAPI)openAPIDef, (!isResource ? 1 : 0) != 0, (boolean)options.isSanitizedOas);
        OASClientConfig.Builder clientMetaDataBuilder = new OASClientConfig.Builder();
        OASClientConfig oasClientConfig = clientMetaDataBuilder.withFilters(filter).withNullable(options.nullable).withPlugin(false).withOpenAPI(normalizedOpenAPI).withResourceMode(isResource).withStatusCodeBinding(options.statusCodeBinding).withMock(options.isMock).build();
        this.licenseHeader = this.licenseHeader.isBlank() ? "// AUTO-GENERATED FILE. DO NOT MODIFY.\n// This file is auto-generated by the Ballerina OpenAPI tool.\n\n" : this.licenseHeader;
        TypeHandler.createInstance((OpenAPI)normalizedOpenAPI, (boolean)options.nullable);
        BallerinaClientGenerator clientGenerator = BallerinaCodeGenerator.getBallerinaClientGenerator(oasClientConfig);
        SyntaxTree syntaxTree = clientGenerator.generateSyntaxTree();
        List authNodes = clientGenerator.getBallerinaAuthConfigGenerator().getAuthRelatedTypeDefinitionNodes();
        for (TypeDefinitionNode typeDef : authNodes) {
            TypeHandler.getInstance().addTypeDefinitionNode(typeDef.typeName().text(), typeDef);
        }
        if (options.singleFile) {
            syntaxTree = BallerinaCodeGenerator.generateSingleFileForClient(syntaxTree, clientGenerator);
        } else {
            this.generateFilesForClient(syntaxTree, sourceFiles, clientGenerator);
        }
        List diagnosticList = TypeHandler.getInstance().getDiagnostics();
        if (this.includeTestFiles) {
            BallerinaTestGenerator ballerinaTestGenerator = new BallerinaTestGenerator(clientGenerator);
            String testContent = Formatter.format((SyntaxTree)ballerinaTestGenerator.generateSyntaxTree()).toSourceCode();
            sourceFiles.add(new GenSrcFile(GenSrcFile.GenFileType.GEN_SRC, this.srcPackage, "test.bal", this.licenseHeader + testContent));
            String configContent = ballerinaTestGenerator.getConfigTomlFile();
            if (!configContent.isBlank()) {
                sourceFiles.add(new GenSrcFile(GenSrcFile.GenFileType.GEN_SRC, this.srcPackage, "Config.toml", configContent));
            }
        }
        List clientDiagnostic = clientGenerator.getDiagnostics();
        for (ClientDiagnostic diagnostic : clientDiagnostic) {
            outStream.println(String.valueOf(diagnostic.getDiagnosticSeverity()) + ":" + diagnostic.getMessage());
        }
        this.printDiagnostic(diagnosticList);
        if (options.singleFile) {
            sourceFiles.add(new GenSrcFile(GenSrcFile.GenFileType.GEN_SRC, this.srcPackage, "client.bal", this.licenseHeader + Formatter.format((SyntaxTree)syntaxTree).toSourceCode()));
        }
        return sourceFiles;
    }

    private void generateFilesForClient(SyntaxTree syntaxTree, List<GenSrcFile> sourceFiles, BallerinaClientGenerator clientGenerator) throws FormatterException, IOException {
        String mainContent = Formatter.format((SyntaxTree)syntaxTree).toSourceCode();
        sourceFiles.add(new GenSrcFile(GenSrcFile.GenFileType.GEN_SRC, this.srcPackage, "client.bal", this.licenseHeader + mainContent));
        String utilContent = Formatter.format((SyntaxTree)clientGenerator.getBallerinaUtilGenerator().generateUtilSyntaxTree()).toString();
        if (!utilContent.isBlank()) {
            sourceFiles.add(new GenSrcFile(GenSrcFile.GenFileType.UTIL_SRC, this.srcPackage, "utils.bal", this.licenseHeader + utilContent));
        }
        SyntaxTree schemaSyntaxTree = TypeHandler.getInstance().generateTypeSyntaxTree();
        String schemaContent = Formatter.format((SyntaxTree)schemaSyntaxTree).toSourceCode();
        this.generateSchemaFile(sourceFiles, schemaContent, this.licenseHeader);
    }

    private static SyntaxTree generateSingleFileForClient(SyntaxTree syntaxTree, BallerinaClientGenerator clientGenerator) throws IOException {
        syntaxTree = SingleFileGenerator.combineSyntaxTrees((SyntaxTree[])new SyntaxTree[]{syntaxTree, clientGenerator.getBallerinaUtilGenerator().generateUtilSyntaxTree(), TypeHandler.getInstance().generateTypeSyntaxTree()});
        return syntaxTree;
    }

    private void generateSchemaFile(List<GenSrcFile> sourceFiles, String schemaContent, String licenseHeader) {
        if (!schemaContent.isBlank()) {
            sourceFiles.add(new GenSrcFile(GenSrcFile.GenFileType.MODEL_SRC, this.srcPackage, "types.bal", (licenseHeader.isBlank() ? "// AUTO-GENERATED FILE.\n// This file is auto-generated by the Ballerina OpenAPI tool.\n\n" : licenseHeader) + schemaContent));
        }
    }

    private static BallerinaClientGenerator getBallerinaClientGenerator(OASClientConfig oasClientConfig) {
        boolean statusCodeBinding = oasClientConfig.isStatusCodeBinding();
        boolean isMock = oasClientConfig.isMock();
        if (statusCodeBinding && isMock) {
            return new AdvanceMockClientGenerator(oasClientConfig);
        }
        if (statusCodeBinding) {
            return new BallerinaClientGeneratorWithStatusCodeBinding(oasClientConfig);
        }
        if (isMock) {
            return new BallerinaMockClientGenerator(oasClientConfig);
        }
        return new BallerinaClientGenerator(oasClientConfig);
    }

    public List<GenSrcFile> generateBallerinaService(Path openAPI, String serviceName, Filter filter, ServiceGeneratorOptions options) throws IOException, FormatterException, BallerinaOpenApiException {
        OpenAPI openAPIDef;
        if (this.srcPackage == null || this.srcPackage.isEmpty()) {
            this.srcPackage = "mock";
        }
        if ((openAPIDef = GeneratorUtils.normalizeOpenAPI((Path)openAPI, (boolean)false, (boolean)options.isSanitizedOas)).getInfo() == null) {
            throw new BallerinaOpenApiException("Info section of the definition file cannot be empty/null: " + String.valueOf(openAPI));
        }
        this.checkOpenAPIVersion(openAPIDef);
        if (openAPIDef.getInfo().getTitle().isBlank() && (serviceName == null || serviceName.isBlank())) {
            openAPIDef.getInfo().setTitle("UntitledAPI");
        } else {
            openAPIDef.getInfo().setTitle(serviceName);
        }
        List complexPaths = GeneratorUtils.getComplexPaths((OpenAPI)openAPIDef);
        if (!complexPaths.isEmpty()) {
            outStream.println("service generation can not be done as the openapi definition contain following complex path(s):");
            for (String path : complexPaths) {
                outStream.println(path);
            }
            return new ArrayList<GenSrcFile>();
        }
        String concatTitle = serviceName == null ? openAPIDef.getInfo().getTitle().toLowerCase(Locale.ENGLISH) : serviceName.toLowerCase(Locale.ENGLISH);
        String srcFile = concatTitle + "_service.bal";
        OASServiceMetadata oasServiceMetadata = new OASServiceMetadata.Builder().withOpenAPI(openAPIDef).withFilters(filter).withNullable(options.nullable).withGenerateServiceType(options.generateServiceType).withGenerateServiceContract(options.generateServiceContract).withGenerateWithoutDataBinding(options.generateWithoutDataBinding).withLicenseHeader(this.licenseHeader).withSrcFile(srcFile).withSrcPackage(this.srcPackage).build();
        TypeHandler.createInstance((OpenAPI)openAPIDef, (boolean)options.nullable);
        ServiceGenerationHandler serviceGenerationHandler = new ServiceGenerationHandler();
        List<GenSrcFile> sourceFiles = new ArrayList<GenSrcFile>();
        if (options.singleFile) {
            BallerinaCodeGenerator.generateSingleFileForService(serviceGenerationHandler, oasServiceMetadata, sourceFiles);
        } else {
            sourceFiles = BallerinaCodeGenerator.generateFilesForService(serviceGenerationHandler, oasServiceMetadata);
        }
        this.diagnostics.addAll(serviceGenerationHandler.getDiagnostics());
        this.diagnostics.addAll(TypeHandler.getInstance().getDiagnostics());
        this.printDiagnostic(this.diagnostics);
        return sourceFiles;
    }

    private static List<GenSrcFile> generateFilesForService(ServiceGenerationHandler serviceGenerationHandler, OASServiceMetadata oasServiceMetadata) throws FormatterException, BallerinaOpenApiException {
        String schemaSyntaxTree;
        List sourceFiles = serviceGenerationHandler.generateServiceFiles(oasServiceMetadata);
        if (!oasServiceMetadata.generateWithoutDataBinding() && !(schemaSyntaxTree = Formatter.format((SyntaxTree)TypeHandler.getInstance().generateTypeSyntaxTree()).toSourceCode()).isBlank()) {
            sourceFiles.add(new GenSrcFile(GenSrcFile.GenFileType.MODEL_SRC, oasServiceMetadata.getSrcPackage(), "types.bal", (oasServiceMetadata.getLicenseHeader().isBlank() ? "// AUTO-GENERATED FILE.\n// This file is auto-generated by the Ballerina OpenAPI tool.\n\n" : oasServiceMetadata.getLicenseHeader()) + schemaSyntaxTree));
        }
        return sourceFiles;
    }

    private static void generateSingleFileForService(ServiceGenerationHandler serviceGenerationHandler, OASServiceMetadata oasServiceMetadata, List<GenSrcFile> sourceFiles) throws BallerinaOpenApiException, FormatterException {
        SyntaxTree syntaxTree = serviceGenerationHandler.generateSingleSyntaxTree(oasServiceMetadata);
        if (!oasServiceMetadata.generateWithoutDataBinding()) {
            syntaxTree = SingleFileGenerator.combineSyntaxTrees((SyntaxTree[])new SyntaxTree[]{syntaxTree, TypeHandler.getInstance().generateTypeSyntaxTree()});
        }
        sourceFiles.add(new GenSrcFile(GenSrcFile.GenFileType.GEN_SRC, oasServiceMetadata.getSrcPackage(), oasServiceMetadata.getSrcFile(), (oasServiceMetadata.getLicenseHeader().isBlank() ? "// AUTO-GENERATED FILE.\n// This file is auto-generated by the Ballerina OpenAPI tool.\n\n" : oasServiceMetadata.getLicenseHeader()) + Formatter.format((SyntaxTree)syntaxTree).toSourceCode()));
    }

    private void printDiagnostic(List<Diagnostic> diagnostics) {
        for (Diagnostic diagnostic : diagnostics) {
            outStream.printf("%s: %s%n", diagnostic.diagnosticInfo().severity(), diagnostic.message());
        }
    }

    public void setLicenseHeader(String licenseHeader) {
        this.licenseHeader = licenseHeader;
    }

    public void setIncludeTestFiles(boolean includeTestFiles) {
        this.includeTestFiles = includeTestFiles;
    }

    private void checkOpenAPIVersion(OpenAPI openAPIDef) {
        if (!CmdConstants.SUPPORTED_OPENAPI_VERSIONS.contains(openAPIDef.getOpenapi())) {
            outStream.printf("WARNING: The tool has not been tested with OpenAPI version %s. The generated code may potentially contain errors.%n", openAPIDef.getOpenapi());
        }
    }

    private static Path getImplPath(String pkg, Path srcPath) {
        return pkg == null || pkg.isEmpty() ? srcPath : srcPath.getParent();
    }

    private static void writeFile(Path filePath, String content) throws IOException {
        try (FileWriter writer = new FileWriter(filePath.toString(), StandardCharsets.UTF_8);){
            writer.write(content);
        }
    }

    public record ClientServiceGeneratorOptions(boolean nullable, boolean isResource, boolean generateServiceType, boolean generateServiceContract, boolean generateWithoutDataBinding, boolean statusCodeBinding, boolean isMock, boolean isSanitizedOas) {
    }

    public record ClientGeneratorOptions(boolean nullable, boolean isResource, boolean statusCodeBinding, boolean isMock, boolean singleFile, boolean isSanitizedOas) {
    }

    public record ServiceGeneratorOptions(boolean nullable, boolean generateServiceType, boolean generateServiceContract, boolean generateWithoutDataBinding, boolean singleFile, boolean isSanitizedOas) {
    }
}

