/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.stdlib.grpc;

import io.ballerina.stdlib.grpc.Codec;
import io.ballerina.stdlib.grpc.Decompressor;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public final class DecompressorRegistry {
    private static final DecompressorRegistry DEFAULT_INSTANCE = new DecompressorRegistry(new Codec.Gzip(), Codec.Identity.NONE);
    private final ConcurrentMap<String, Decompressor> decompressors = new ConcurrentHashMap<String, Decompressor>();
    private final Set<String> advertisedDecompressors = new HashSet<String>();

    public static DecompressorRegistry getDefaultInstance() {
        return DEFAULT_INSTANCE;
    }

    private DecompressorRegistry(Decompressor ... cs) {
        for (Decompressor c : cs) {
            this.decompressors.put(c.getMessageEncoding(), c);
            if (Codec.Identity.NONE.getMessageEncoding().equals(c.getMessageEncoding())) continue;
            this.advertisedDecompressors.add(c.getMessageEncoding());
        }
    }

    public Decompressor lookupDecompressor(String compressorName) {
        return (Decompressor)this.decompressors.get(compressorName);
    }

    public Set<String> getAdvertisedMessageEncodings() {
        return this.advertisedDecompressors;
    }
}

