/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.stdlib.grpc;

import com.google.protobuf.DescriptorProtos;
import io.ballerina.runtime.api.utils.StringUtils;
import io.ballerina.runtime.api.values.BString;
import io.ballerina.stdlib.grpc.Status;
import io.ballerina.stdlib.grpc.nativeimpl.ModuleUtils;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public class GrpcConstants {
    public static final String PROTOCOL_PACKAGE_GRPC = "grpc";
    public static final String PROTOCOL_PACKAGE_VERSION_GRPC = ModuleUtils.getModule().getMajorVersion();
    public static final String ORG_NAME = "ballerina";
    public static final String PROTOCOL_STRUCT_PACKAGE_GRPC = "ballerina/grpc:" + PROTOCOL_PACKAGE_VERSION_GRPC;
    public static final String PROTOCOL_STRUCT_PACKAGE_PROTOBUF = "ballerina/protobuf:" + PROTOCOL_PACKAGE_VERSION_GRPC;
    public static final String HTTPS_ENDPOINT_STARTED = "[ballerina/grpc] started HTTPS/WSS listener ";
    public static final String HTTP_ENDPOINT_STARTED = "[ballerina/grpc] started HTTP/WS listener ";
    public static final String HTTPS_ENDPOINT_STOPPED = "[ballerina/grpc] stopped HTTPS/WSS listener ";
    public static final String HTTP_ENDPOINT_STOPPED = "[ballerina/grpc] stopped HTTP/WS listener ";
    public static final String SERVICE_REGISTRY_BUILDER = "SERVICE_REGISTRY_BUILDER";
    public static final String SERVER_CONNECTOR = "SERVER_CONNECTOR";
    public static final String CONNECTOR_STARTED = "CONNECTOR_STARTED";
    public static final String CALLER = "Caller";
    public static final String RESPONSE_OBSERVER = "RESPONSE_OBSERVER";
    public static final String RESPONSE_MESSAGE_DEFINITION = "RESPONSE_DEFINITION";
    public static final BString CALLER_ID = StringUtils.fromString((String)"instanceId");
    public static final String MESSAGE_QUEUE = "messageQueue";
    public static final String COMPLETED_MESSAGE = "completedMessage";
    public static final String ERROR_MESSAGE = "errorMessage";
    public static final String ITERATOR_OBJECT_NAME = "StreamIterator";
    public static final String ITERATOR_OBJECT_ENTRY = "streamIterator";
    public static final String ROOT_DESCRIPTOR = "ROOT_DESCRIPTOR";
    public static final String ANN_SERVICE_DESCRIPTOR = "ServiceDescriptor";
    public static final BString ANN_SERVICE_DESCRIPTOR_FQN = StringUtils.fromString((String)(PROTOCOL_STRUCT_PACKAGE_GRPC + ":ServiceDescriptor"));
    public static final String ANN_DESCRIPTOR = "Descriptor";
    public static final BString ANN_DESCRIPTOR_FQN = StringUtils.fromString((String)(PROTOCOL_STRUCT_PACKAGE_GRPC + ":Descriptor"));
    public static final BString ANN_PROTOBUF_DESCRIPTOR = StringUtils.fromString((String)(PROTOCOL_STRUCT_PACKAGE_PROTOBUF + ":Descriptor"));
    public static final String CLIENT_ENDPOINT_RESPONSE_OBSERVER = "ResponseObserver";
    public static final String CLIENT_CONNECTOR = "ClientConnector";
    public static final String ENDPOINT_URL = "url";
    public static final String RECEIVE_ENTRY = "receive";
    public static final String CONTEXT_ENTRY = "context";
    public static final String SERVICE_STUB = "Stub";
    public static final String METHOD_DESCRIPTORS = "MethodDescriptors";
    public static final String REQUEST_SENDER = "REQUEST_SENDER";
    public static final String REQUEST_MESSAGE_DEFINITION = "REQUEST_DEFINITION";
    public static final String REGEX_DOT_SEPERATOR = "\\.";
    public static final String DOT = ".";
    public static final String STREAMING_CLIENT = "StreamingClient";
    public static final String HEADERS = "Headers";
    public static final String MAX_INBOUND_MESSAGE_SIZE = "maxInboundMessageSize";
    public static final Map<DescriptorProtos.FieldDescriptorProto.Type, Integer> WIRE_TYPE_MAP;
    public static final String WRAPPER_DOUBLE_MESSAGE = "DoubleValue";
    public static final String WRAPPER_FLOAT_MESSAGE = "FloatValue";
    public static final String WRAPPER_INT64_MESSAGE = "Int64Value";
    public static final String WRAPPER_UINT64_MESSAGE = "UInt64Value";
    public static final String WRAPPER_INT32_MESSAGE = "Int32Value";
    public static final String WRAPPER_UINT32_MESSAGE = "UInt32Value";
    public static final String WRAPPER_BOOL_MESSAGE = "BoolValue";
    public static final String WRAPPER_STRING_MESSAGE = "StringValue";
    public static final String WRAPPER_BYTES_MESSAGE = "BytesValue";
    public static final String TIMESTAMP_MESSAGE = "Timestamp";
    public static final String DURATION_MESSAGE = "Duration";
    public static final String STRUCT_MESSAGE = "Struct";
    public static final String ANY_MESSAGE = "Any";
    public static final String IS_BIDI_STREAMING = "isBidiStreaming";
    public static final String IS_STREAM_CANCELLED = "isStreamCancelled";
    public static final String WRAPPER_DOUBLE_TYPE_NAME = "google.protobuf.DoubleValue";
    public static final String WRAPPER_FLOAT_TYPE_NAME = "google.protobuf.FloatValue";
    public static final String WRAPPER_INT64_TYPE_NAME = "google.protobuf.Int64Value";
    public static final String WRAPPER_UINT64_TYPE_NAME = "google.protobuf.UInt64Value";
    public static final String WRAPPER_INT32_TYPE_NAME = "google.protobuf.Int32Value";
    public static final String WRAPPER_UINT32_TYPE_NAME = "google.protobuf.UInt32Value";
    public static final String WRAPPER_BOOL_TYPE_NAME = "google.protobuf.BoolValue";
    public static final String WRAPPER_STRING_TYPE_NAME = "google.protobuf.StringValue";
    public static final String WRAPPER_BYTES_TYPE_NAME = "google.protobuf.BytesValue";
    public static final String ANY_TYPE_NAME = "google.protobuf.Any";
    public static final String EMPTY_TYPE_NAME = "google.protobuf.Empty";
    public static final String TIMESTAMP_TYPE_NAME = "google.protobuf.Timestamp";
    public static final String DURATION_TYPE_NAME = "google.protobuf.Duration";
    public static final String STRUCT_TYPE_NAME = "google.protobuf.Struct";
    public static final String ON_MESSAGE_RESOURCE = "onMessage";
    public static final String EMPTY_DATATYPE_NAME = "Empty";
    static final String GRPC_STATUS_KEY = "grpc-status";
    static final String GRPC_MESSAGE_KEY = "grpc-message";
    static final String CONTENT_TYPE_KEY = "content-type";
    static final String TE_KEY = "te";
    static final String TO_HEADER = "TO";
    public static final String SCHEME_HEADER = "scheme";
    public static final String AUTHORITY = "authority";
    public static final String AUTHORIZATION = "authorization";
    public static final String CONTENT_TYPE_GRPC = "application/grpc";
    public static final String HTTP_METHOD = "POST";
    public static final String TE_TRAILERS = "trailers";
    static final String MESSAGE_ENCODING = "grpc-encoding";
    static final String MESSAGE_ACCEPT_ENCODING = "grpc-accept-encoding";
    static final String CONTENT_ENCODING = "content-encoding";
    public static final String CANCELLED_ERROR = "CancelledError";
    public static final String UNKNOWN_ERROR = "UnKnownError";
    public static final String INVALID_ARGUMENT_ERROR = "InvalidArgumentError";
    public static final String DEADLINE_EXCEEDED_ERROR = "DeadlineExceededError";
    public static final String NOT_FOUND_ERROR = "NotFoundError";
    public static final String ALREADY_EXISTS_ERROR = "AlreadyExistsError";
    public static final String PERMISSION_DENIED_ERROR = "PermissionDeniedError";
    public static final String RESOURCE_EXHAUSTED_ERROR = "ResourceExhaustedError";
    public static final String FAILED_PRECONDITION_ERROR = "FailedPreconditionError";
    public static final String ABORTED_ERROR = "AbortedError";
    public static final String OUT_OF_RANGE_ERROR = "OutOfRangeError";
    public static final String UNIMPLEMENTED_ERROR = "UnimplementedError";
    public static final String INTERNAL_ERROR = "InternalError";
    public static final String UNAVAILABLE_ERROR = "UnavailableError";
    public static final String DATA_LOSS_ERROR = "DataLossError";
    public static final String UNAUTHENTICATED_ERROR = "UnauthenticatedError";
    public static final String INTERNAL_UNAUTHENTICATED_ERROR = "InternalUnauthenticatedError";
    public static final String INTERNAL_PERMISSION_DENIED_ERROR = "InternalPermissionDeniedError";
    public static final Map<Integer, String> STATUS_ERROR_MAP;
    public static final String TAG_KEY_GRPC_ERROR_MESSAGE = "grpc.error_message";
    public static final BString ENDPOINT_CONFIG_SECURESOCKET;
    public static final BString SECURESOCKET_CONFIG_DISABLE_SSL;
    public static final BString SECURESOCKET_CONFIG_CERT;
    public static final BString SECURESOCKET_CONFIG_TRUSTSTORE_FILE_PATH;
    public static final BString SECURESOCKET_CONFIG_TRUSTSTORE_PASSWORD;
    public static final BString SECURESOCKET_CONFIG_KEY;
    public static final BString SECURESOCKET_CONFIG_CERTKEY_CERT_FILE;
    public static final BString SECURESOCKET_CONFIG_CERTKEY_KEY_FILE;
    public static final BString SECURESOCKET_CONFIG_CERTKEY_KEY_PASSWORD;
    public static final BString SECURESOCKET_CONFIG_KEYSTORE_FILE_PATH;
    public static final BString SECURESOCKET_CONFIG_KEYSTORE_PASSWORD;
    public static final BString SECURESOCKET_CONFIG_PROTOCOL;
    public static final BString SECURESOCKET_CONFIG_PROTOCOL_NAME;
    public static final BString SECURESOCKET_CONFIG_PROTOCOL_VERSIONS;
    public static final BString SECURESOCKET_CONFIG_CERT_VALIDATION;
    public static final BString SECURESOCKET_CONFIG_CERT_VALIDATION_TYPE;
    public static final BString SECURESOCKET_CONFIG_CERT_VALIDATION_CACHE_SIZE;
    public static final BString SECURESOCKET_CONFIG_CERT_VALIDATION_CACHE_VALIDITY_PERIOD;
    public static final BString SECURESOCKET_CONFIG_CIPHERS;
    public static final BString SECURESOCKET_CONFIG_HOST_NAME_VERIFICATION_ENABLED;
    public static final BString SECURESOCKET_CONFIG_SHARE_SESSION;
    public static final BString SECURESOCKET_CONFIG_HANDSHAKE_TIMEOUT;
    public static final BString SECURESOCKET_CONFIG_SESSION_TIMEOUT;
    public static final BString SECURESOCKET_CONFIG_MUTUAL_SSL;
    public static final BString SECURESOCKET_CONFIG_VERIFY_CLIENT;
    public static final BString SECURESOCKET_CONFIG_CERT_VALIDATION_TYPE_OCSP_STAPLING;
    public static final String CONTENT_FIELD = "content";
    public static final String HEADER_FIELD = "headers";
    public static final String STREAMING_NEXT_FUNCTION = "next";
    public static final BString CONFIG;

    private GrpcConstants() {
    }

    public static <T, E> T getKeyByValue(Map<T, E> map, E value) {
        for (Map.Entry<T, E> entry : map.entrySet()) {
            if (!Objects.equals(value, entry.getValue())) continue;
            return entry.getKey();
        }
        return null;
    }

    static {
        HashMap<DescriptorProtos.FieldDescriptorProto.Type, Integer> wireMap = new HashMap<DescriptorProtos.FieldDescriptorProto.Type, Integer>();
        wireMap.put(DescriptorProtos.FieldDescriptorProto.Type.TYPE_DOUBLE, 1);
        wireMap.put(DescriptorProtos.FieldDescriptorProto.Type.TYPE_FLOAT, 5);
        wireMap.put(DescriptorProtos.FieldDescriptorProto.Type.TYPE_INT32, 0);
        wireMap.put(DescriptorProtos.FieldDescriptorProto.Type.TYPE_INT64, 0);
        wireMap.put(DescriptorProtos.FieldDescriptorProto.Type.TYPE_UINT32, 0);
        wireMap.put(DescriptorProtos.FieldDescriptorProto.Type.TYPE_UINT64, 0);
        wireMap.put(DescriptorProtos.FieldDescriptorProto.Type.TYPE_SINT32, 0);
        wireMap.put(DescriptorProtos.FieldDescriptorProto.Type.TYPE_SINT64, 0);
        wireMap.put(DescriptorProtos.FieldDescriptorProto.Type.TYPE_FIXED32, 5);
        wireMap.put(DescriptorProtos.FieldDescriptorProto.Type.TYPE_FIXED64, 1);
        wireMap.put(DescriptorProtos.FieldDescriptorProto.Type.TYPE_SFIXED32, 5);
        wireMap.put(DescriptorProtos.FieldDescriptorProto.Type.TYPE_SFIXED64, 1);
        wireMap.put(DescriptorProtos.FieldDescriptorProto.Type.TYPE_BOOL, 0);
        wireMap.put(DescriptorProtos.FieldDescriptorProto.Type.TYPE_ENUM, 0);
        wireMap.put(DescriptorProtos.FieldDescriptorProto.Type.TYPE_STRING, 2);
        wireMap.put(DescriptorProtos.FieldDescriptorProto.Type.TYPE_BYTES, 2);
        WIRE_TYPE_MAP = Collections.unmodifiableMap(wireMap);
        STATUS_ERROR_MAP = Map.ofEntries(Map.entry(Status.Code.CANCELLED.value(), CANCELLED_ERROR), Map.entry(Status.Code.UNKNOWN.value(), UNKNOWN_ERROR), Map.entry(Status.Code.INVALID_ARGUMENT.value(), INVALID_ARGUMENT_ERROR), Map.entry(Status.Code.DEADLINE_EXCEEDED.value(), DEADLINE_EXCEEDED_ERROR), Map.entry(Status.Code.NOT_FOUND.value(), NOT_FOUND_ERROR), Map.entry(Status.Code.ALREADY_EXISTS.value(), ALREADY_EXISTS_ERROR), Map.entry(Status.Code.PERMISSION_DENIED.value(), PERMISSION_DENIED_ERROR), Map.entry(Status.Code.RESOURCE_EXHAUSTED.value(), RESOURCE_EXHAUSTED_ERROR), Map.entry(Status.Code.FAILED_PRECONDITION.value(), FAILED_PRECONDITION_ERROR), Map.entry(Status.Code.ABORTED.value(), ABORTED_ERROR), Map.entry(Status.Code.OUT_OF_RANGE.value(), OUT_OF_RANGE_ERROR), Map.entry(Status.Code.UNIMPLEMENTED.value(), UNIMPLEMENTED_ERROR), Map.entry(Status.Code.INTERNAL.value(), INTERNAL_ERROR), Map.entry(Status.Code.UNAVAILABLE.value(), UNAVAILABLE_ERROR), Map.entry(Status.Code.DATA_LOSS.value(), DATA_LOSS_ERROR), Map.entry(Status.Code.UNAUTHENTICATED.value(), UNAUTHENTICATED_ERROR));
        ENDPOINT_CONFIG_SECURESOCKET = StringUtils.fromString((String)"secureSocket");
        SECURESOCKET_CONFIG_DISABLE_SSL = StringUtils.fromString((String)"enable");
        SECURESOCKET_CONFIG_CERT = StringUtils.fromString((String)"cert");
        SECURESOCKET_CONFIG_TRUSTSTORE_FILE_PATH = StringUtils.fromString((String)"path");
        SECURESOCKET_CONFIG_TRUSTSTORE_PASSWORD = StringUtils.fromString((String)"password");
        SECURESOCKET_CONFIG_KEY = StringUtils.fromString((String)"key");
        SECURESOCKET_CONFIG_CERTKEY_CERT_FILE = StringUtils.fromString((String)"certFile");
        SECURESOCKET_CONFIG_CERTKEY_KEY_FILE = StringUtils.fromString((String)"keyFile");
        SECURESOCKET_CONFIG_CERTKEY_KEY_PASSWORD = StringUtils.fromString((String)"keyPassword");
        SECURESOCKET_CONFIG_KEYSTORE_FILE_PATH = StringUtils.fromString((String)"path");
        SECURESOCKET_CONFIG_KEYSTORE_PASSWORD = StringUtils.fromString((String)"password");
        SECURESOCKET_CONFIG_PROTOCOL = StringUtils.fromString((String)"protocol");
        SECURESOCKET_CONFIG_PROTOCOL_NAME = StringUtils.fromString((String)"name");
        SECURESOCKET_CONFIG_PROTOCOL_VERSIONS = StringUtils.fromString((String)"versions");
        SECURESOCKET_CONFIG_CERT_VALIDATION = StringUtils.fromString((String)"certValidation");
        SECURESOCKET_CONFIG_CERT_VALIDATION_TYPE = StringUtils.fromString((String)"type");
        SECURESOCKET_CONFIG_CERT_VALIDATION_CACHE_SIZE = StringUtils.fromString((String)"cacheSize");
        SECURESOCKET_CONFIG_CERT_VALIDATION_CACHE_VALIDITY_PERIOD = StringUtils.fromString((String)"cacheValidityPeriod");
        SECURESOCKET_CONFIG_CIPHERS = StringUtils.fromString((String)"ciphers");
        SECURESOCKET_CONFIG_HOST_NAME_VERIFICATION_ENABLED = StringUtils.fromString((String)"verifyHostName");
        SECURESOCKET_CONFIG_SHARE_SESSION = StringUtils.fromString((String)"shareSession");
        SECURESOCKET_CONFIG_HANDSHAKE_TIMEOUT = StringUtils.fromString((String)"handshakeTimeout");
        SECURESOCKET_CONFIG_SESSION_TIMEOUT = StringUtils.fromString((String)"sessionTimeout");
        SECURESOCKET_CONFIG_MUTUAL_SSL = StringUtils.fromString((String)"mutualSsl");
        SECURESOCKET_CONFIG_VERIFY_CLIENT = StringUtils.fromString((String)"verifyClient");
        SECURESOCKET_CONFIG_CERT_VALIDATION_TYPE_OCSP_STAPLING = StringUtils.fromString((String)"OCSP_STAPLING");
        CONFIG = StringUtils.fromString((String)"config");
    }
}

