/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.stdlib.grpc;

import com.google.protobuf.CodedOutputStream;
import com.google.protobuf.InvalidProtocolBufferException;
import io.ballerina.stdlib.grpc.Drainable;
import io.ballerina.stdlib.grpc.KnownLength;
import io.ballerina.stdlib.grpc.Message;
import io.ballerina.stdlib.grpc.ProtoUtils;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

class ProtoInputStream
extends InputStream
implements Drainable,
KnownLength {
    private Message message;
    private ByteArrayInputStream partial;

    ProtoInputStream(Message message) {
        this.message = message;
    }

    @Override
    public int read() {
        if (this.message != null) {
            this.partial = new ByteArrayInputStream(this.message.toByteArray());
            this.message = null;
        }
        if (this.partial != null) {
            return this.partial.read();
        }
        return -1;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        if (this.message != null) {
            int size = this.message.getSerializedSize();
            if (size == 0) {
                this.message = null;
                this.partial = null;
                return -1;
            }
            if (len >= size) {
                CodedOutputStream stream = CodedOutputStream.newInstance((byte[])b, (int)off, (int)size);
                this.message.writeTo(stream);
                stream.flush();
                stream.checkNoSpaceLeft();
                this.message = null;
                this.partial = null;
                return size;
            }
            this.partial = new ByteArrayInputStream(this.message.toByteArray());
            this.message = null;
        }
        if (this.partial != null) {
            return this.partial.read(b, off, len);
        }
        return -1;
    }

    @Override
    public int available() throws InvalidProtocolBufferException {
        if (this.message != null) {
            return this.message.getSerializedSize();
        }
        if (this.partial != null) {
            return this.partial.available();
        }
        return 0;
    }

    Message message() {
        if (this.message == null) {
            throw new IllegalStateException("message not available");
        }
        return this.message;
    }

    @Override
    public int drainTo(OutputStream target) throws IOException {
        int written;
        if (this.message != null) {
            written = this.message.getSerializedSize();
            CodedOutputStream codedOutput = CodedOutputStream.newInstance((OutputStream)target, (int)written);
            this.message.writeTo(codedOutput);
            codedOutput.flush();
            this.message = null;
        } else if (this.partial != null) {
            written = (int)ProtoUtils.copy(this.partial, target);
            this.partial = null;
        } else {
            written = 0;
        }
        return written;
    }
}

