/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.stdlib.grpc;

import com.google.protobuf.Descriptors;
import io.ballerina.runtime.api.Runtime;
import io.ballerina.runtime.api.types.MethodType;
import io.ballerina.runtime.api.types.Type;
import io.ballerina.runtime.api.values.BObject;
import io.ballerina.stdlib.grpc.MessageUtils;
import io.ballerina.stdlib.grpc.ServicesBuilderUtils;
import java.util.List;

public class ServiceResource {
    private final BObject service;
    private final String serviceName;
    private final String functionName;
    private final Type[] paramTypes;
    private final boolean headerRequired;
    private final Runtime runtime;
    private final Type returnType;
    private final Type rpcOutputType;
    private final Type rpcInputType;

    public ServiceResource(Runtime runtime, BObject service, String serviceName, MethodType function, Descriptors.MethodDescriptor methodDescriptor) {
        this.service = service;
        this.serviceName = serviceName;
        this.functionName = function.getName();
        this.paramTypes = ServicesBuilderUtils.getParameterTypesFromParameters(function.getParameters());
        this.returnType = function.getReturnType();
        this.rpcOutputType = ServicesBuilderUtils.getBallerinaValueType(ServicesBuilderUtils.getOutputPackage(service, this.functionName), methodDescriptor.getOutputType().getName());
        this.rpcInputType = ServicesBuilderUtils.getBallerinaValueType(ServicesBuilderUtils.getInputPackage(service, this.functionName), methodDescriptor.getInputType().getName());
        this.headerRequired = MessageUtils.headersRequired(function, this.rpcInputType);
        this.runtime = runtime;
    }

    public BObject getService() {
        return this.service;
    }

    public List<Type> getParamTypes() {
        return List.of(this.paramTypes);
    }

    public boolean isHeaderRequired() {
        return this.headerRequired;
    }

    public String getFunctionName() {
        return this.functionName;
    }

    public Runtime getRuntime() {
        return this.runtime;
    }

    public Type getReturnType() {
        return this.returnType;
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public Type getRpcOutputType() {
        return this.rpcOutputType;
    }

    public Type getRpcInputType() {
        return this.rpcInputType;
    }
}

