/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.stdlib.grpc;

import io.ballerina.stdlib.grpc.GrpcConstants;
import io.ballerina.stdlib.grpc.exception.StatusRuntimeException;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Objects;
import java.util.TreeMap;

public final class Status
implements Serializable {
    private static final long serialVersionUID = -1L;
    static final StatusMessageMarshaller MESSAGE_MARSHALLER = new StatusMessageMarshaller();
    static final StatusCodeMarshaller CODE_MARSHALLER = new StatusCodeMarshaller();
    private final Code code;
    private final String description;
    private final Throwable cause;
    private static final List<Status> STATUS_LIST = Status.buildStatusList();

    private static List<Status> buildStatusList() {
        TreeMap<Integer, Status> canonicalizer = new TreeMap<Integer, Status>();
        for (Code code : Code.values()) {
            Status replaced = canonicalizer.put(code.value(), new Status(code));
            if (replaced == null) continue;
            throw new IllegalStateException("Code value duplication between " + replaced.getCode().name() + " & " + code.name());
        }
        return List.copyOf(canonicalizer.values());
    }

    public static Status fromCodeValue(int codeValue) {
        if (codeValue < 0 || codeValue > STATUS_LIST.size()) {
            return Code.UNKNOWN.toStatus().withDescription("Unknown code " + codeValue);
        }
        return STATUS_LIST.get(codeValue);
    }

    private static Status fromCodeValue(byte[] asciiCodeValue) {
        if (asciiCodeValue.length == 1 && asciiCodeValue[0] == 48) {
            return Code.OK.toStatus();
        }
        return Status.fromCodeValueSlow(asciiCodeValue);
    }

    private static Status fromCodeValueSlow(byte[] asciiCodeValue) {
        int index = 0;
        int codeValue = 0;
        switch (asciiCodeValue.length) {
            case 2: {
                if (asciiCodeValue[index] < 48 || asciiCodeValue[index] > 57) break;
                codeValue += (asciiCodeValue[index++] - 48) * 10;
                if ((codeValue += asciiCodeValue[index] - 48) >= STATUS_LIST.size()) break;
                return STATUS_LIST.get(codeValue);
            }
            case 1: {
                if (asciiCodeValue[index] < 48 || asciiCodeValue[index] > 57 || (codeValue += asciiCodeValue[index] - 48) >= STATUS_LIST.size()) break;
                return STATUS_LIST.get(codeValue);
            }
        }
        return Code.UNKNOWN.toStatus().withDescription("Unknown code " + new String(asciiCodeValue, StandardCharsets.US_ASCII));
    }

    public static Status fromCode(Code code) {
        return code.toStatus();
    }

    public static Status fromThrowable(Throwable t) {
        if (t == null) {
            throw new IllegalArgumentException("Cause is null");
        }
        for (Throwable cause = t; cause != null; cause = cause.getCause()) {
            if (!(cause instanceof StatusRuntimeException)) continue;
            return ((StatusRuntimeException)cause).getStatus();
        }
        return Code.UNKNOWN.toStatus().withCause(t);
    }

    public static String formatThrowableMessage(Status status) {
        if (status.description == null) {
            return status.code.toString();
        }
        return String.valueOf((Object)status.code) + ": " + status.description;
    }

    private Status(Code code) {
        this(code, null, null);
    }

    private Status(Code code, String description, Throwable cause) {
        this.code = code;
        this.description = description;
        this.cause = cause;
    }

    public Status withCause(Throwable cause) {
        if (Objects.equals(this.cause, cause)) {
            return this;
        }
        return new Status(this.code, this.description, cause);
    }

    public Status withDescription(String description) {
        if (Objects.equals(this.description, description)) {
            return this;
        }
        return new Status(this.code, description, this.cause);
    }

    Status augmentDescription(String additionalDetail) {
        if (additionalDetail == null) {
            return this;
        }
        if (this.description == null) {
            return new Status(this.code, additionalDetail, this.cause);
        }
        return new Status(this.code, this.description + "\n" + additionalDetail, this.cause);
    }

    public Code getCode() {
        return this.code;
    }

    String getDescription() {
        return this.description;
    }

    public Throwable getCause() {
        return this.cause;
    }

    public boolean isOk() {
        return Code.OK == this.code;
    }

    String getReason() {
        return GrpcConstants.STATUS_ERROR_MAP.get(this.code.value());
    }

    public StatusRuntimeException asRuntimeException() {
        return new StatusRuntimeException(this);
    }

    public String toString() {
        return "Status{ code " + this.code.name() + ", description " + this.description + ", cause " + (this.cause != null ? this.cause.getMessage() : null) + "}";
    }

    public static enum Code {
        OK(0),
        CANCELLED(1),
        UNKNOWN(2),
        INVALID_ARGUMENT(3),
        DEADLINE_EXCEEDED(4),
        NOT_FOUND(5),
        ALREADY_EXISTS(6),
        PERMISSION_DENIED(7),
        RESOURCE_EXHAUSTED(8),
        FAILED_PRECONDITION(9),
        ABORTED(10),
        OUT_OF_RANGE(11),
        UNIMPLEMENTED(12),
        INTERNAL(13),
        UNAVAILABLE(14),
        DATA_LOSS(15),
        UNAUTHENTICATED(16);

        private final int value;
        private final byte[] valueAscii;

        private Code(int value) {
            this.value = value;
            this.valueAscii = Integer.toString(value).getBytes(StandardCharsets.US_ASCII);
        }

        public int value() {
            return this.value;
        }

        public Status toStatus() {
            return STATUS_LIST.get(this.value);
        }

        private byte[] valueAscii() {
            return this.valueAscii;
        }
    }

    static final class StatusMessageMarshaller {
        private static final byte[] HEX = new byte[]{48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 65, 66, 67, 68, 69, 70};

        StatusMessageMarshaller() {
        }

        byte[] toAsciiString(String value) {
            byte[] valueBytes = value.getBytes(StandardCharsets.UTF_8);
            for (int i = 0; i < valueBytes.length; ++i) {
                byte b = valueBytes[i];
                if (!StatusMessageMarshaller.isEscapingChar(b)) continue;
                return StatusMessageMarshaller.toAsciiStringSlow(valueBytes, i);
            }
            return valueBytes;
        }

        private static boolean isEscapingChar(byte b) {
            return b < 32 || b >= 126 || b == 37;
        }

        private static byte[] toAsciiStringSlow(byte[] valueBytes, int ri) {
            byte[] escapedBytes = new byte[ri + (valueBytes.length - ri) * 3];
            if (ri != 0) {
                System.arraycopy(valueBytes, 0, escapedBytes, 0, ri);
            }
            int wi = ri;
            while (ri < valueBytes.length) {
                byte b = valueBytes[ri];
                if (StatusMessageMarshaller.isEscapingChar(b)) {
                    escapedBytes[wi] = 37;
                    escapedBytes[wi + 1] = HEX[b >> 4 & 0xF];
                    escapedBytes[wi + 2] = HEX[b & 0xF];
                    wi += 3;
                } else {
                    escapedBytes[wi++] = b;
                }
                ++ri;
            }
            byte[] dest = new byte[wi];
            System.arraycopy(escapedBytes, 0, dest, 0, wi);
            return dest;
        }
    }

    static final class StatusCodeMarshaller {
        StatusCodeMarshaller() {
        }

        byte[] toAsciiString(Status status) {
            return status.getCode().valueAscii();
        }

        Status parseAsciiString(byte[] serialized) {
            return Status.fromCodeValue(serialized);
        }
    }
}

