/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.stdlib.grpc.callback;

import com.google.protobuf.Descriptors;
import io.ballerina.runtime.api.Module;
import io.ballerina.runtime.api.Runtime;
import io.ballerina.runtime.api.concurrent.StrandMetadata;
import io.ballerina.runtime.api.creators.ErrorCreator;
import io.ballerina.runtime.api.types.ObjectType;
import io.ballerina.runtime.api.types.Type;
import io.ballerina.runtime.api.utils.StringUtils;
import io.ballerina.runtime.api.utils.TypeUtils;
import io.ballerina.runtime.api.values.BError;
import io.ballerina.runtime.api.values.BMap;
import io.ballerina.runtime.api.values.BObject;
import io.ballerina.runtime.api.values.BStream;
import io.ballerina.runtime.api.values.BString;
import io.ballerina.runtime.observability.ObserverContext;
import io.ballerina.stdlib.grpc.Message;
import io.ballerina.stdlib.grpc.MessageUtils;
import io.ballerina.stdlib.grpc.StreamObserver;
import io.ballerina.stdlib.grpc.callback.AbstractCallableUnitCallBack;
import io.ballerina.stdlib.grpc.listener.ServerCallHandler;
import io.ballerina.stdlib.grpc.nativeimpl.ModuleUtils;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpResponseStatus;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UnaryCallableUnitCallBack
extends AbstractCallableUnitCallBack {
    private static final Logger LOG = LoggerFactory.getLogger(UnaryCallableUnitCallBack.class);
    private final Runtime runtime;
    private final StreamObserver requestSender;
    private final boolean emptyResponse;
    private final Descriptors.Descriptor outputType;
    private final ObserverContext observerContext;

    public UnaryCallableUnitCallBack(Runtime runtime, StreamObserver requestSender, boolean isEmptyResponse, Descriptors.Descriptor outputType, ObserverContext context) {
        this.runtime = runtime;
        this.requestSender = requestSender;
        this.emptyResponse = isEmptyResponse;
        this.outputType = outputType;
        this.observerContext = context;
    }

    public void notifySuccess(Object response) {
        Object content;
        if (this.requestSender instanceof ServerCallHandler.ServerCallStreamObserver) {
            ServerCallHandler.ServerCallStreamObserver serverCallStreamObserver = (ServerCallHandler.ServerCallStreamObserver)this.requestSender;
            if (!serverCallStreamObserver.isReady()) {
                return;
            }
            if (serverCallStreamObserver.isCancelled()) {
                return;
            }
        }
        if (response instanceof BError) {
            ((BError)((Object)response)).printStackTrace();
            UnaryCallableUnitCallBack.handleFailure(this.requestSender, (BError)((Object)response));
            if (this.observerContext != null) {
                this.observerContext.addProperty("_http_status_code_", (Object)HttpResponseStatus.INTERNAL_SERVER_ERROR.code());
            }
            return;
        }
        BMap headerValues = null;
        if (MessageUtils.isContextRecordByValue(response)) {
            content = ((BMap)response).get((Object)StringUtils.fromString((String)"content"));
            headerValues = ((BMap)response).getMapValue(StringUtils.fromString((String)"headers"));
        } else {
            content = response;
        }
        HttpHeaders headers = MessageUtils.convertToHttpHeaders(headerValues);
        if (this.emptyResponse) {
            Message responseMessage = new Message("Empty", null);
            responseMessage.setHeaders(headers);
            this.requestSender.onNext(responseMessage);
            this.requestSender.onCompleted();
        } else if (content instanceof BStream) {
            BObject bObject = ((BStream)content).getIteratorObj();
            ReturnStreamUnitCallBack returnStreamUnitCallBack = new ReturnStreamUnitCallBack(this, this.runtime, this.requestSender, this.outputType, bObject, headers);
            ObjectType serviceObjectType = (ObjectType)TypeUtils.getReferredType((Type)TypeUtils.getType((Object)bObject));
            Thread.startVirtualThread(() -> {
                try {
                    boolean isConcurrentSafe = serviceObjectType.isIsolated() && serviceObjectType.isIsolated("next");
                    StrandMetadata metadata = new StrandMetadata(isConcurrentSafe, null);
                    Object result = this.runtime.callMethod(bObject, "next", metadata, new Object[0]);
                    returnStreamUnitCallBack.notifySuccess(result);
                }
                catch (BError error) {
                    returnStreamUnitCallBack.notifyFailure(error);
                }
            });
        } else if (content == null) {
            this.requestSender.onCompleted();
        } else {
            Message responseMessage = new Message(this.outputType, content);
            responseMessage.setHeaders(headers);
            if (this.observerContext != null) {
                headers.entries().forEach(x -> this.observerContext.addTag((String)x.getKey(), (String)x.getValue()));
            }
            this.requestSender.onNext(responseMessage);
            if (this.observerContext != null) {
                this.observerContext.addProperty("_http_status_code_", (Object)HttpResponseStatus.OK.code());
            }
            this.requestSender.onCompleted();
        }
    }

    public void notifyFailure(BError error) {
        ServerCallHandler.ServerCallStreamObserver serverCallStreamObserver;
        if (this.requestSender instanceof ServerCallHandler.ServerCallStreamObserver && (!(serverCallStreamObserver = (ServerCallHandler.ServerCallStreamObserver)this.requestSender).isReady() || serverCallStreamObserver.isCancelled())) {
            LOG.warn("Call already closed");
            return;
        }
        error.printStackTrace();
        boolean isPanic = false;
        if (error.getType().getName().equals("InternalUnauthenticatedError")) {
            error = ErrorCreator.createError((Module)ModuleUtils.getModule(), (String)"UnauthenticatedError", (BString)error.getErrorMessage(), (BError)error.getCause(), null);
        } else if (error.getType().getName().equals("InternalPermissionDeniedError")) {
            error = ErrorCreator.createError((Module)ModuleUtils.getModule(), (String)"PermissionDeniedError", (BString)error.getErrorMessage(), (BError)error.getCause(), null);
        } else {
            isPanic = true;
        }
        UnaryCallableUnitCallBack.handleFailure(this.requestSender, error);
        if (this.observerContext != null) {
            this.observerContext.addProperty("_http_status_code_", (Object)HttpResponseStatus.INTERNAL_SERVER_ERROR.code());
        }
        if (isPanic) {
            System.exit(1);
        }
    }

    public class ReturnStreamUnitCallBack
    extends AbstractCallableUnitCallBack {
        private final StreamObserver requestSender;
        private final Descriptors.Descriptor outputType;
        private final Runtime runtime;
        private final BObject bObject;
        private HttpHeaders headers;

        public ReturnStreamUnitCallBack(UnaryCallableUnitCallBack this$0, Runtime runtime, StreamObserver requestSender, Descriptors.Descriptor outputType, BObject bObject, HttpHeaders headers) {
            this.runtime = runtime;
            this.requestSender = requestSender;
            this.outputType = outputType;
            this.bObject = bObject;
            this.headers = headers;
        }

        public void notifySuccess(Object response) {
            if (response != null) {
                Message msg = MessageUtils.isRecordMapValue(response) ? new Message(this.outputType, ((BMap)response).get((Object)StringUtils.fromString((String)"value"))) : new Message(this.outputType, response);
                if (this.headers != null) {
                    msg.setHeaders(this.headers);
                    this.headers = null;
                }
                this.requestSender.onNext(msg);
                ObjectType serviceObjectType = (ObjectType)TypeUtils.getReferredType((Type)TypeUtils.getType((Object)this.bObject));
                Thread.startVirtualThread(() -> {
                    try {
                        boolean isConcurrentSafe = serviceObjectType.isIsolated() && serviceObjectType.isIsolated("next");
                        StrandMetadata metadata = new StrandMetadata(isConcurrentSafe, null);
                        Object result = this.runtime.callMethod(this.bObject, "next", metadata, new Object[0]);
                        this.notifySuccess(result);
                    }
                    catch (BError error) {
                        this.notifyFailure(error);
                    }
                });
            } else {
                this.requestSender.onCompleted();
            }
        }

        public void notifyFailure(BError error) {
        }
    }
}

