/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.stdlib.grpc.listener;

import com.google.protobuf.Descriptors;
import io.ballerina.runtime.api.Module;
import io.ballerina.runtime.api.concurrent.StrandMetadata;
import io.ballerina.runtime.api.creators.ValueCreator;
import io.ballerina.runtime.api.types.ArrayType;
import io.ballerina.runtime.api.types.ObjectType;
import io.ballerina.runtime.api.types.PredefinedTypes;
import io.ballerina.runtime.api.types.Type;
import io.ballerina.runtime.api.utils.TypeUtils;
import io.ballerina.runtime.api.values.BError;
import io.ballerina.runtime.api.values.BMap;
import io.ballerina.runtime.api.values.BObject;
import io.ballerina.runtime.observability.ObserveUtils;
import io.ballerina.runtime.observability.ObserverContext;
import io.ballerina.stdlib.grpc.CallStreamObserver;
import io.ballerina.stdlib.grpc.GrpcConstants;
import io.ballerina.stdlib.grpc.GrpcUtil;
import io.ballerina.stdlib.grpc.Message;
import io.ballerina.stdlib.grpc.MessageUtils;
import io.ballerina.stdlib.grpc.ServerCall;
import io.ballerina.stdlib.grpc.ServiceResource;
import io.ballerina.stdlib.grpc.Status;
import io.ballerina.stdlib.grpc.StreamObserver;
import io.ballerina.stdlib.grpc.callback.UnaryCallableUnitCallBack;
import io.ballerina.stdlib.grpc.nativeimpl.ModuleUtils;
import io.netty.handler.codec.http.DefaultHttpHeaders;
import io.netty.handler.codec.http.HttpHeaders;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public abstract class ServerCallHandler {
    static final String TOO_MANY_REQUESTS = "Too many requests";
    static final String MISSING_REQUEST = "Half-closed without a request";
    static final String CALLER_TYPE = "Caller";
    protected Descriptors.MethodDescriptor methodDescriptor;

    ServerCallHandler(Descriptors.MethodDescriptor methodDescriptor) {
        this.methodDescriptor = methodDescriptor;
    }

    public abstract Listener startCall(ServerCall var1);

    BObject getConnectionParameter(ServiceResource resource, StreamObserver responseObserver) {
        BObject clientEndpoint = ValueCreator.createObjectValue((Module)ModuleUtils.getModule(), (String)CALLER_TYPE, (Object[])new Object[0]);
        clientEndpoint.set(GrpcConstants.CALLER_ID, (Object)responseObserver.hashCode());
        clientEndpoint.addNativeData("RESPONSE_OBSERVER", (Object)responseObserver);
        clientEndpoint.addNativeData("RESPONSE_DEFINITION", (Object)this.methodDescriptor.getOutputType());
        String serviceName = resource.getServiceName();
        Type returnType = resource.getRpcOutputType() instanceof ArrayType ? TypeUtils.getReferredType((Type)((ArrayType)resource.getRpcOutputType()).getElementType()) : resource.getRpcOutputType();
        String outputType = returnType != PredefinedTypes.TYPE_NULL ? GrpcUtil.getTypeName(returnType) : null;
        return ValueCreator.createObjectValue((Module)TypeUtils.getType((Object)resource.getService()).getPackage(), (String)MessageUtils.getCallerTypeName(serviceName, outputType), (Object[])new Object[]{clientEndpoint});
    }

    private boolean isEmptyResponse() {
        return this.methodDescriptor != null && MessageUtils.isEmptyResponse(this.methodDescriptor.getOutputType());
    }

    void onMessageInvoke(ServiceResource resource, Message request, StreamObserver responseObserver, ObserverContext context) {
        UnaryCallableUnitCallBack callback = new UnaryCallableUnitCallBack(resource.getRuntime(), responseObserver, this.isEmptyResponse(), this.methodDescriptor.getOutputType(), context);
        Object requestParam = request != null ? request.getbMessage() : null;
        HttpHeaders headers = request != null ? request.getHeaders() : null;
        Object[] requestParams = this.computeResourceParams(resource, requestParam, headers, responseObserver);
        HashMap<String, Object> properties = new HashMap<String, Object>();
        if (ObserveUtils.isObservabilityEnabled()) {
            properties.put("__observer_context__", context);
        }
        properties.put("authorization", headers.get("authorization"));
        String functionName = resource.getFunctionName();
        ObjectType serviceObjectType = (ObjectType)TypeUtils.getReferredType((Type)TypeUtils.getType((Object)resource.getService()));
        Thread.startVirtualThread(() -> {
            try {
                boolean isEmpty = this.isEmpty(requestParams);
                boolean isConcurrentSafe = serviceObjectType.isIsolated() && serviceObjectType.isIsolated(functionName);
                StrandMetadata metadata = new StrandMetadata(isConcurrentSafe, properties);
                Object result = isEmpty ? resource.getRuntime().callMethod(resource.getService(), functionName, metadata, new Object[0]) : resource.getRuntime().callMethod(resource.getService(), functionName, metadata, requestParams);
                callback.notifySuccess(result);
            }
            catch (BError error) {
                callback.notifyFailure(error);
            }
        });
    }

    Boolean isEmpty(Object[] requestParams) {
        boolean isEmpty = true;
        for (Object param : requestParams) {
            if (param == null) continue;
            isEmpty = false;
            break;
        }
        return isEmpty;
    }

    Object[] computeResourceParams(ServiceResource resource, Object requestParam, HttpHeaders headers, StreamObserver responseObserver) {
        Object[] paramValues;
        List<Type> signatureParams = resource.getParamTypes();
        int signatureParamSize = signatureParams.size();
        int i = 0;
        if (signatureParamSize >= 1 && signatureParams.get(0).getTag() == 47 && signatureParams.get(0).getName().contains(CALLER_TYPE)) {
            paramValues = new Object[signatureParams.size()];
            paramValues[i] = this.getConnectionParameter(resource, responseObserver);
            ++i;
        } else {
            paramValues = new Object[1];
        }
        if (resource.isHeaderRequired()) {
            BMap headerValues = MessageUtils.createHeaderMap(headers);
            Map valueMap = requestParam != null ? Map.ofEntries(Map.entry("content", requestParam), Map.entry("headers", headerValues)) : Map.ofEntries(Map.entry("headers", headerValues));
            if (signatureParamSize >= 1) {
                Type inputParameter = signatureParams.get(signatureParamSize - 1);
                BMap contentContext = inputParameter.getName().contains("Stream") && (signatureParamSize == 1 && signatureParams.get(0).getTag() == 24 || signatureParamSize > 1 && signatureParams.get(1).getTag() == 24) ? ValueCreator.createRecordValue((Module)inputParameter.getPackage(), (String)MessageUtils.getContextStreamTypeName(resource.getRpcInputType()), valueMap) : ValueCreator.createRecordValue((Module)inputParameter.getPackage(), (String)MessageUtils.getContextTypeName(resource.getRpcInputType()), valueMap);
                paramValues[i] = contentContext;
            }
        } else if (requestParam != null) {
            paramValues[i] = requestParam;
        }
        return paramValues;
    }

    public static interface Listener {
        public void onMessage(Message var1);

        public void onHalfClose();

        public void onCancel(Message var1);

        public void onComplete();
    }

    public static final class ServerCallStreamObserver
    implements CallStreamObserver {
        final ServerCall call;
        volatile boolean cancelled;
        private boolean sentHeaders;

        ServerCallStreamObserver(ServerCall call) {
            this.call = call;
        }

        @Override
        public void setMessageCompression(boolean enable) {
            this.call.setMessageCompression(enable);
        }

        @Override
        public void onNext(Message response) {
            if (this.cancelled) {
                throw Status.Code.CANCELLED.toStatus().withDescription("call already cancelled").asRuntimeException();
            }
            if (!this.sentHeaders) {
                this.call.sendHeaders(response.getHeaders());
                this.sentHeaders = true;
            }
            this.call.sendMessage(response);
        }

        @Override
        public void onError(Message error) {
            if (!this.sentHeaders) {
                this.call.sendHeaders(error.getHeaders());
                this.sentHeaders = true;
            }
            this.call.close(Status.fromThrowable(error.getError()), (HttpHeaders)new DefaultHttpHeaders());
        }

        @Override
        public void onCompleted() {
            if (this.cancelled) {
                throw Status.Code.CANCELLED.toStatus().withDescription("call already cancelled").asRuntimeException();
            }
            this.call.close(Status.Code.OK.toStatus(), (HttpHeaders)new DefaultHttpHeaders());
        }

        @Override
        public boolean isReady() {
            return this.call.isReady();
        }

        public boolean isCancelled() {
            return this.call.isCancelled();
        }
    }
}

