/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.stdlib.grpc.nativeimpl.caller;

import com.google.protobuf.Descriptors;
import io.ballerina.runtime.api.Environment;
import io.ballerina.runtime.api.utils.StringUtils;
import io.ballerina.runtime.api.values.BError;
import io.ballerina.runtime.api.values.BMap;
import io.ballerina.runtime.api.values.BObject;
import io.ballerina.runtime.observability.ObserveUtils;
import io.ballerina.runtime.observability.ObserverContext;
import io.ballerina.stdlib.grpc.GrpcConstants;
import io.ballerina.stdlib.grpc.Message;
import io.ballerina.stdlib.grpc.MessageUtils;
import io.ballerina.stdlib.grpc.Status;
import io.ballerina.stdlib.grpc.StreamObserver;
import io.ballerina.stdlib.grpc.exception.StatusRuntimeException;
import io.ballerina.stdlib.grpc.listener.ServerCallHandler;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpResponseStatus;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FunctionUtils {
    private static final Logger LOG = LoggerFactory.getLogger(FunctionUtils.class);
    private static final String CONTENT = "content";

    private FunctionUtils() {
    }

    public static Object externComplete(Environment env, BObject endpointClient) {
        StreamObserver responseObserver = MessageUtils.getResponseObserver(endpointClient);
        Descriptors.Descriptor outputType = (Descriptors.Descriptor)endpointClient.getNativeData("RESPONSE_DEFINITION");
        ObserverContext observerContext = ObserveUtils.getObserverContextOfCurrentFrame((Environment)env);
        if (responseObserver == null) {
            return MessageUtils.getConnectorError(new StatusRuntimeException(Status.fromCode(Status.Code.INTERNAL.toStatus().getCode()).withDescription("Error while initializing connector. response sender does not exist")));
        }
        try {
            if (!MessageUtils.isEmptyResponse(outputType)) {
                responseObserver.onCompleted();
            }
            if (observerContext != null) {
                observerContext.addProperty("_http_status_code_", (Object)HttpResponseStatus.OK.code());
            }
        }
        catch (Exception e) {
            LOG.error("Error while sending complete message to caller.", (Throwable)e);
            return MessageUtils.getConnectorError(e);
        }
        return null;
    }

    public static boolean externIsCancelled(BObject endpointClient) {
        StreamObserver responseObserver = MessageUtils.getResponseObserver(endpointClient);
        if (responseObserver instanceof ServerCallHandler.ServerCallStreamObserver) {
            ServerCallHandler.ServerCallStreamObserver serverCallStreamObserver = (ServerCallHandler.ServerCallStreamObserver)responseObserver;
            return serverCallStreamObserver.isCancelled();
        }
        return Boolean.FALSE;
    }

    public static Object externSend(Environment env, BObject endpointClient, Object responseValue) {
        StreamObserver responseObserver = MessageUtils.getResponseObserver(endpointClient);
        Descriptors.Descriptor outputType = (Descriptors.Descriptor)endpointClient.getNativeData("RESPONSE_DEFINITION");
        ObserverContext observerContext = ObserveUtils.getObserverContextOfCurrentFrame((Environment)env);
        if (responseObserver == null) {
            return MessageUtils.getConnectorError(new StatusRuntimeException(Status.fromCode(Status.Code.INTERNAL.toStatus().getCode()).withDescription("Error while initializing connector. Response sender does not exist")));
        }
        try {
            if (!MessageUtils.isEmptyResponse(outputType)) {
                Object content;
                BMap headerValues = null;
                if (MessageUtils.isContextRecordByValue(responseValue)) {
                    content = ((BMap)responseValue).get((Object)StringUtils.fromString((String)CONTENT));
                    headerValues = ((BMap)responseValue).getMapValue(StringUtils.fromString((String)"headers"));
                } else {
                    content = responseValue;
                }
                Message responseMessage = new Message(outputType, content);
                HttpHeaders headers = MessageUtils.convertToHttpHeaders(headerValues);
                responseMessage.setHeaders(headers);
                if (observerContext != null) {
                    headers.entries().forEach(x -> observerContext.addTag((String)x.getKey(), (String)x.getValue()));
                }
                responseObserver.onNext(responseMessage);
            }
        }
        catch (Exception e) {
            LOG.error("Error while sending client response.", (Throwable)e);
            return MessageUtils.getConnectorError(e);
        }
        return null;
    }

    public static Object externSendError(Environment env, BObject endpointClient, BError errorValue) {
        StreamObserver responseObserver = MessageUtils.getResponseObserver(endpointClient);
        ObserverContext observerContext = ObserveUtils.getObserverContextOfCurrentFrame((Environment)env);
        if (responseObserver == null) {
            return MessageUtils.getConnectorError(new StatusRuntimeException(Status.fromCode(Status.Code.INTERNAL.toStatus().getCode()).withDescription("Error while sending the error. Response observer not found.")));
        }
        try {
            Integer statusCode = GrpcConstants.getKeyByValue(GrpcConstants.STATUS_ERROR_MAP, errorValue.getType().getName());
            if (statusCode == null) {
                statusCode = Status.Code.INTERNAL.value();
            }
            Message errorMessage = new Message(new StatusRuntimeException(Status.fromCodeValue(statusCode).withDescription(errorValue.getErrorMessage().getValue())));
            int mappedStatusCode = MessageUtils.getMappingHttpStatusCode(statusCode);
            if (observerContext != null) {
                observerContext.addProperty("_http_status_code_", (Object)mappedStatusCode);
            }
            responseObserver.onError(errorMessage);
        }
        catch (Exception e) {
            LOG.error("Error while sending error to caller.", (Throwable)e);
            return MessageUtils.getConnectorError(e);
        }
        return null;
    }

    public static Object externGetAuthorizationHeader(Environment env) {
        String headers = (String)env.getStrandLocal("authorization");
        if (headers == null) {
            return MessageUtils.getConnectorError(new StatusRuntimeException(Status.fromCode(Status.Code.INTERNAL.toStatus().getCode()).withDescription("Authorization header does not exist")));
        }
        return StringUtils.fromString((String)headers);
    }
}

