/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.stdlib.grpc.stubs;

import io.ballerina.stdlib.grpc.ClientCall;
import io.ballerina.stdlib.grpc.Message;
import io.ballerina.stdlib.grpc.MessageUtils;
import io.ballerina.stdlib.grpc.OutboundMessage;
import io.ballerina.stdlib.grpc.Status;
import io.ballerina.stdlib.http.transport.contract.HttpClientConnector;
import io.ballerina.stdlib.http.transport.message.HttpCarbonMessage;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaders;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class AbstractStub {
    private static final Logger logger = Logger.getLogger(AbstractStub.class.getName());
    private final HttpClientConnector connector;
    private String urlString;
    private static final String CACHE_BALLERINA_VERSION = System.getProperty("ballerina.version");

    AbstractStub(HttpClientConnector connector, String url) {
        this.connector = connector;
        this.urlString = url;
    }

    public final HttpClientConnector getConnector() {
        return this.connector;
    }

    OutboundMessage createOutboundRequest(HttpHeaders httpHeaders) {
        try {
            HttpCarbonMessage carbonMessage = MessageUtils.createHttpCarbonMessage(true);
            URL url = new URL(this.urlString);
            int port = this.getOutboundReqPort(url);
            String host = url.getHost();
            carbonMessage.setHeader("scheme", url.getProtocol());
            carbonMessage.setHeader("authority", this.urlString);
            this.setOutboundReqProperties(carbonMessage, url, port, host);
            this.setOutboundReqHeaders(carbonMessage, port, host);
            if (httpHeaders != null) {
                carbonMessage.addHeaders(httpHeaders);
            }
            return new OutboundMessage(carbonMessage);
        }
        catch (MalformedURLException e) {
            throw new RuntimeException("Malformed url specified. " + e.getMessage());
        }
        catch (Exception t) {
            throw new RuntimeException("Failed to prepare request. " + t.getMessage());
        }
    }

    private int getOutboundReqPort(URL url) {
        int port = 80;
        if (url.getPort() != -1) {
            port = url.getPort();
        } else if (url.getProtocol().equalsIgnoreCase("https")) {
            port = 443;
        }
        return port;
    }

    private void setOutboundReqHeaders(HttpCarbonMessage outboundRequest, int port, String host) {
        HttpHeaders headers = outboundRequest.getHeaders();
        this.setHostHeader(host, port, headers);
        this.setOutboundUserAgent(headers);
        this.removeConnectionHeader(headers);
    }

    private void setOutboundReqProperties(HttpCarbonMessage outboundRequest, URL url, int port, String host) {
        outboundRequest.setProperty("host", (Object)host);
        outboundRequest.setProperty("port", (Object)port);
        outboundRequest.setProperty("PROTOCOL", (Object)url.getProtocol());
    }

    private void setHostHeader(String host, int port, HttpHeaders headers) {
        if (port == 80 || port == 443) {
            headers.set((CharSequence)HttpHeaderNames.HOST, (Object)host);
        } else {
            headers.set((CharSequence)HttpHeaderNames.HOST, (Object)(host + ":" + port));
        }
    }

    private void removeConnectionHeader(HttpHeaders headers) {
        if (headers.contains((CharSequence)HttpHeaderNames.CONNECTION)) {
            headers.remove((CharSequence)HttpHeaderNames.CONNECTION);
        }
    }

    private void setOutboundUserAgent(HttpHeaders headers) {
        Object userAgent = CACHE_BALLERINA_VERSION != null ? "ballerina/" + CACHE_BALLERINA_VERSION : "ballerina";
        if (!headers.contains((CharSequence)HttpHeaderNames.USER_AGENT)) {
            headers.set((CharSequence)HttpHeaderNames.USER_AGENT, userAgent);
        }
    }

    static void cancelThrow(ClientCall call, Exception ex) throws Exception {
        try {
            call.cancel(null, ex);
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Error encountered while closing the client call.", e);
        }
        throw ex;
    }

    public static interface Listener {
        public void onHeaders(HttpHeaders var1);

        public void onMessage(Message var1);

        public void onClose(Status var1, HttpHeaders var2);
    }
}

