/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.stdlib.grpc.stubs;

import io.ballerina.runtime.api.Module;
import io.ballerina.runtime.api.creators.TypeCreator;
import io.ballerina.runtime.api.creators.ValueCreator;
import io.ballerina.runtime.api.types.PredefinedTypes;
import io.ballerina.runtime.api.types.StreamType;
import io.ballerina.runtime.api.types.TupleType;
import io.ballerina.runtime.api.types.Type;
import io.ballerina.runtime.api.values.BArray;
import io.ballerina.runtime.api.values.BError;
import io.ballerina.runtime.api.values.BMap;
import io.ballerina.runtime.api.values.BObject;
import io.ballerina.stdlib.grpc.CallStreamObserver;
import io.ballerina.stdlib.grpc.ClientCall;
import io.ballerina.stdlib.grpc.DataContext;
import io.ballerina.stdlib.grpc.Message;
import io.ballerina.stdlib.grpc.MessageUtils;
import io.ballerina.stdlib.grpc.MethodDescriptor;
import io.ballerina.stdlib.grpc.Status;
import io.ballerina.stdlib.grpc.nativeimpl.ModuleUtils;
import io.ballerina.stdlib.grpc.stubs.AbstractStub;
import io.ballerina.stdlib.http.transport.contract.HttpClientConnector;
import io.netty.handler.codec.http.HttpHeaders;
import java.util.Arrays;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;

public class Stub
extends AbstractStub {
    public Stub(HttpClientConnector clientConnector, String url) {
        super(clientConnector, url);
    }

    public void executeUnary(Message request, MethodDescriptor methodDescriptor, DataContext dataContext, Map<String, Long> messageSizeMap) throws Exception {
        ClientCall call = new ClientCall(this.getConnector(), this.createOutboundRequest(request.getHeaders()), methodDescriptor, dataContext, messageSizeMap);
        call.start(new UnaryCallListener(dataContext));
        try {
            call.sendMessage(request);
            call.halfClose();
        }
        catch (Exception e) {
            Stub.cancelThrow(call, e);
        }
    }

    public void executeServerStreaming(Message request, MethodDescriptor methodDescriptor, DataContext context, Map<String, Long> messageSizeMap) throws Exception {
        ClientCall call = new ClientCall(this.getConnector(), this.createOutboundRequest(request.getHeaders()), methodDescriptor, context, messageSizeMap);
        ServerStreamingCallListener streamingCallListener = new ServerStreamingCallListener(context);
        call.start(streamingCallListener);
        try {
            call.sendMessage(request);
            call.halfClose();
        }
        catch (Exception e) {
            Stub.cancelThrow(call, e);
        }
    }

    public BObject executeClientStreaming(HttpHeaders requestHeaders, MethodDescriptor methodDescriptor, DataContext context, Map<String, Long> messageSizeMap) {
        ClientCall call = new ClientCall(this.getConnector(), this.createOutboundRequest(requestHeaders), methodDescriptor, context, messageSizeMap);
        ClientCallStreamObserver streamObserver = new ClientCallStreamObserver(call);
        StreamingCallListener streamingCallListener = new StreamingCallListener(false);
        call.start(streamingCallListener);
        BObject streamingConnection = ValueCreator.createObjectValue((Module)ModuleUtils.getModule(), (String)"StreamingClient", (Object[])new Object[0]);
        streamingConnection.addNativeData("REQUEST_SENDER", (Object)streamObserver);
        streamingConnection.addNativeData("REQUEST_DEFINITION", (Object)methodDescriptor.getSchemaDescriptor().getInputType());
        streamingConnection.addNativeData("messageQueue", streamingCallListener.getMessageQueue());
        streamingConnection.addNativeData("Headers", (Object)streamingCallListener.getHeaderMap());
        streamingConnection.addNativeData("isBidiStreaming", (Object)false);
        return streamingConnection;
    }

    public BObject executeBidirectionalStreaming(HttpHeaders requestHeaders, MethodDescriptor methodDescriptor, DataContext context, Map<String, Long> messageSizeMap) {
        ClientCall call = new ClientCall(this.getConnector(), this.createOutboundRequest(requestHeaders), methodDescriptor, context, messageSizeMap);
        ClientCallStreamObserver streamObserver = new ClientCallStreamObserver(call);
        StreamingCallListener streamingCallListener = new StreamingCallListener(true);
        call.start(streamingCallListener);
        BObject streamingConnection = ValueCreator.createObjectValue((Module)ModuleUtils.getModule(), (String)"StreamingClient", (Object[])new Object[0]);
        streamingConnection.addNativeData("REQUEST_SENDER", (Object)streamObserver);
        streamingConnection.addNativeData("REQUEST_DEFINITION", (Object)methodDescriptor.getSchemaDescriptor().getInputType());
        streamingConnection.addNativeData("messageQueue", streamingCallListener.getMessageQueue());
        streamingConnection.addNativeData("Headers", (Object)streamingCallListener.getHeaderMap());
        streamingConnection.addNativeData("isBidiStreaming", (Object)true);
        return streamingConnection;
    }

    private static final class UnaryCallListener
    implements AbstractStub.Listener {
        private final DataContext dataContext;
        private Message value;

        private UnaryCallListener(DataContext dataContext) {
            this.dataContext = dataContext;
        }

        @Override
        public void onHeaders(HttpHeaders headers) {
        }

        @Override
        public void onMessage(Message value) {
            if (this.value != null) {
                throw Status.Code.INTERNAL.toStatus().withDescription("More than one value received for unary call").asRuntimeException();
            }
            this.value = value;
        }

        @Override
        public void onClose(Status status, HttpHeaders trailers) {
            BError httpConnectorError = null;
            BArray inboundResponse = null;
            if (status.isOk()) {
                if (this.value == null) {
                    httpConnectorError = MessageUtils.getConnectorError(Status.Code.INTERNAL.toStatus().withDescription("No value received for unary call").asRuntimeException());
                } else {
                    Object responseBValue = this.value.getbMessage();
                    BMap headerMap = MessageUtils.createHeaderMap(this.value.getHeaders());
                    BArray contentTuple = ValueCreator.createTupleValue((TupleType)TypeCreator.createTupleType(Arrays.asList(PredefinedTypes.TYPE_ANYDATA, headerMap.getType())));
                    contentTuple.add(0L, responseBValue);
                    contentTuple.add(1L, (Object)headerMap);
                    inboundResponse = contentTuple;
                }
            } else {
                httpConnectorError = MessageUtils.getConnectorError(status.asRuntimeException());
            }
            if (inboundResponse != null) {
                this.dataContext.getFuture().complete(inboundResponse);
            } else {
                this.dataContext.getFuture().complete((Object)httpConnectorError);
            }
        }
    }

    private static final class ServerStreamingCallListener
    implements AbstractStub.Listener {
        private final DataContext dataContext;
        BlockingQueue<Message> messageQueue;
        private boolean firstResponseReceived;
        Object responseBValue;
        Type streamType = TypeCreator.createStreamType((Type)PredefinedTypes.TYPE_ANYDATA);

        ServerStreamingCallListener(DataContext dataContext) {
            this.messageQueue = new LinkedBlockingQueue<Message>();
            this.dataContext = dataContext;
            BObject streamIterator = ValueCreator.createObjectValue((Module)ModuleUtils.getModule(), (String)"StreamIterator", (Object[])new Object[1]);
            streamIterator.addNativeData("messageQueue", this.messageQueue);
            this.responseBValue = ValueCreator.createStreamValue((StreamType)TypeCreator.createStreamType((Type)PredefinedTypes.TYPE_ANYDATA), (BObject)streamIterator);
        }

        @Override
        public void onHeaders(HttpHeaders headers) {
        }

        @Override
        public void onMessage(Message message) {
            this.messageQueue.add(message);
            if (!this.firstResponseReceived) {
                BMap headerMap = MessageUtils.createHeaderMap(message.getHeaders());
                BArray contentTuple = ValueCreator.createTupleValue((TupleType)TypeCreator.createTupleType(Arrays.asList(this.streamType, headerMap.getType())));
                contentTuple.add(0L, this.responseBValue);
                contentTuple.add(1L, (Object)headerMap);
                this.dataContext.getFuture().complete(contentTuple);
                this.firstResponseReceived = true;
            }
        }

        @Override
        public void onClose(Status status, HttpHeaders trailers) {
            if (status.isOk()) {
                this.messageQueue.add(new Message("completedMessage", null));
            } else {
                this.messageQueue.add(new Message(status.asRuntimeException()));
            }
            if (!this.firstResponseReceived) {
                BMap headerMap = MessageUtils.createHeaderMap(trailers);
                BArray contentTuple = ValueCreator.createTupleValue((TupleType)TypeCreator.createTupleType(Arrays.asList(this.streamType, headerMap.getType())));
                contentTuple.add(0L, this.responseBValue);
                contentTuple.add(1L, (Object)headerMap);
                this.dataContext.getFuture().complete(contentTuple);
            }
        }
    }

    private static final class ClientCallStreamObserver
    implements CallStreamObserver {
        private final ClientCall call;

        ClientCallStreamObserver(ClientCall call) {
            this.call = call;
        }

        @Override
        public void onNext(Message value) {
            if (value.getHeaders() != null) {
                this.call.injectHeaders(value.getHeaders());
            }
            this.call.sendMessage(value);
        }

        @Override
        public void onError(Message error) {
            this.call.cancel("Cancelled by client with StreamObserver.onError()", error.getError());
        }

        @Override
        public void onCompleted() {
            this.call.halfClose();
        }

        @Override
        public boolean isReady() {
            return this.call.isReady();
        }

        @Override
        public void setMessageCompression(boolean enable) {
            this.call.setMessageCompression(enable);
        }
    }

    private static final class StreamingCallListener
    implements AbstractStub.Listener {
        private final boolean streamingResponse;
        BlockingQueue<Message> messageQueue;
        BMap headerMap = null;
        private boolean firstResponseReceived;

        StreamingCallListener(boolean streamingResponse) {
            this.streamingResponse = streamingResponse;
            this.messageQueue = new LinkedBlockingQueue<Message>();
        }

        @Override
        public void onHeaders(HttpHeaders headers) {
        }

        @Override
        public void onMessage(Message message) {
            if (this.firstResponseReceived && !this.streamingResponse) {
                throw Status.Code.INTERNAL.toStatus().withDescription("More than one responses received for unary or client-streaming call").asRuntimeException();
            }
            if (!this.firstResponseReceived) {
                this.headerMap = MessageUtils.createHeaderMap(message.getHeaders());
                this.firstResponseReceived = true;
            }
            this.messageQueue.add(message);
        }

        @Override
        public void onClose(Status status, HttpHeaders trailers) {
            if (status.isOk()) {
                this.messageQueue.add(new Message("completedMessage", null));
            } else {
                Message errorMsg = new Message(status.asRuntimeException());
                errorMsg.setHeaders(trailers);
                this.messageQueue.add(errorMsg);
            }
        }

        BlockingQueue<Message> getMessageQueue() {
            return this.messageQueue;
        }

        BMap getHeaderMap() {
            return this.headerMap;
        }
    }
}

