/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.stdlib.websocket;

import io.ballerina.runtime.api.Module;
import io.ballerina.runtime.api.creators.ErrorCreator;
import io.ballerina.runtime.api.creators.ValueCreator;
import io.ballerina.runtime.api.types.PredefinedTypes;
import io.ballerina.runtime.api.types.Type;
import io.ballerina.runtime.api.utils.StringUtils;
import io.ballerina.runtime.api.values.BError;
import io.ballerina.runtime.api.values.BMap;
import io.ballerina.runtime.api.values.BString;
import io.ballerina.stdlib.websocket.ModuleUtils;
import io.ballerina.stdlib.websocket.WebSocketConstants;
import io.ballerina.stdlib.websocket.WebSocketUtil;

public final class WebSocketException
extends RuntimeException {
    private final String message;
    private BError wsError;

    public WebSocketException(Throwable ex, String typeIdName) {
        this(WebSocketConstants.ErrorCode.Error.errorCode() + ":" + WebSocketUtil.getErrorMessage(ex), typeIdName);
    }

    public WebSocketException(String message, String typeIdName) {
        this(message, (BMap<BString, Object>)ValueCreator.createMapValue((Type)PredefinedTypes.TYPE_ERROR_DETAIL), typeIdName);
    }

    public WebSocketException(String message, BError cause, String typeIdName) {
        this.message = message;
        this.wsError = ErrorCreator.createError((Module)ModuleUtils.getWebsocketModule(), (String)typeIdName, (BString)StringUtils.fromString((String)message), (BError)cause, null);
    }

    public WebSocketException(String message, BMap<BString, Object> details, String typeIdName) {
        this.message = message;
        this.wsError = ErrorCreator.createError((Module)ModuleUtils.getWebsocketModule(), (String)typeIdName, (BString)StringUtils.fromString((String)message), null, details);
    }

    public BError getWsError() {
        return this.wsError;
    }
}

