/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.stdlib.websocket.client.listener;

import io.ballerina.runtime.api.values.BObject;
import io.ballerina.stdlib.http.api.HttpUtil;
import io.ballerina.stdlib.http.transport.contract.websocket.ClientHandshakeListener;
import io.ballerina.stdlib.http.transport.contract.websocket.WebSocketConnection;
import io.ballerina.stdlib.http.transport.message.HttpCarbonMessage;
import io.ballerina.stdlib.http.transport.message.HttpCarbonResponse;
import io.ballerina.stdlib.websocket.WebSocketService;
import io.ballerina.stdlib.websocket.WebSocketUtil;
import io.ballerina.stdlib.websocket.client.RetryContext;
import io.ballerina.stdlib.websocket.client.listener.SyncClientConnectorListener;
import io.ballerina.stdlib.websocket.observability.WebSocketObservabilityUtil;
import io.ballerina.stdlib.websocket.server.WebSocketConnectionInfo;
import java.io.IOException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RetryWebSocketClientHandshakeListener
implements ClientHandshakeListener {
    private final WebSocketService wsService;
    private final SyncClientConnectorListener connectorListener;
    private final BObject webSocketClient;
    private WebSocketConnectionInfo connectionInfo;
    private CompletableFuture<Object> balFuture;
    private RetryContext retryConfig;
    AtomicBoolean callbackCompleted;
    private static final Logger logger = LoggerFactory.getLogger(RetryWebSocketClientHandshakeListener.class);

    public RetryWebSocketClientHandshakeListener(BObject webSocketClient, WebSocketService wsService, SyncClientConnectorListener connectorListener, CompletableFuture<Object> future, RetryContext retryConfig, AtomicBoolean callbackCompleted) {
        this.webSocketClient = webSocketClient;
        this.wsService = wsService;
        this.connectorListener = connectorListener;
        this.balFuture = future;
        this.retryConfig = retryConfig;
        this.callbackCompleted = callbackCompleted;
    }

    public void onSuccess(WebSocketConnection webSocketConnection, HttpCarbonResponse carbonResponse) {
        this.webSocketClient.addNativeData("response", (Object)HttpUtil.createResponseStruct((HttpCarbonMessage)carbonResponse));
        WebSocketUtil.populatWebSocketEndpoint(webSocketConnection, this.webSocketClient);
        this.setWebSocketOpenConnectionInfo(webSocketConnection, this.webSocketClient, this.wsService);
        this.connectorListener.setConnectionInfo(this.connectionInfo);
        if (this.retryConfig.isFirstConnectionMadeSuccessfully()) {
            webSocketConnection.readNextFrame();
        } else if (!this.callbackCompleted.get()) {
            this.balFuture.complete(null);
            this.callbackCompleted.set(true);
        }
        WebSocketObservabilityUtil.observeConnection(this.connectionInfo);
        WebSocketUtil.adjustContextOnSuccess(this.retryConfig);
    }

    public void onError(Throwable throwable, HttpCarbonResponse response) {
        if (response != null) {
            this.webSocketClient.addNativeData("response", (Object)HttpUtil.createResponseStruct((HttpCarbonMessage)response));
        }
        this.setWebSocketOpenConnectionInfo(null, this.webSocketClient, this.wsService);
        if (throwable instanceof IOException && WebSocketUtil.reconnect(this.connectionInfo, this.balFuture, this.callbackCompleted)) {
            return;
        }
        if (!this.callbackCompleted.get()) {
            this.balFuture.complete((Object)WebSocketUtil.createErrorByType(throwable));
            this.callbackCompleted.set(true);
        }
    }

    private void setWebSocketOpenConnectionInfo(WebSocketConnection webSocketConnection, BObject webSocketClient, WebSocketService wsService) {
        this.connectionInfo = new WebSocketConnectionInfo(wsService, webSocketConnection, webSocketClient);
        webSocketClient.addNativeData("NATIVE_DATA_WEBSOCKET_CONNECTION_INFO", (Object)this.connectionInfo);
    }
}

