/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.stdlib.websocket.client.listener;

import io.ballerina.runtime.api.values.BArray;
import io.ballerina.runtime.api.values.BObject;
import io.ballerina.stdlib.http.api.HttpUtil;
import io.ballerina.stdlib.http.transport.contract.websocket.ClientHandshakeListener;
import io.ballerina.stdlib.http.transport.contract.websocket.WebSocketConnection;
import io.ballerina.stdlib.http.transport.message.HttpCarbonMessage;
import io.ballerina.stdlib.http.transport.message.HttpCarbonResponse;
import io.ballerina.stdlib.websocket.WebSocketConstants;
import io.ballerina.stdlib.websocket.WebSocketService;
import io.ballerina.stdlib.websocket.WebSocketUtil;
import io.ballerina.stdlib.websocket.actions.websocketconnector.WebSocketConnector;
import io.ballerina.stdlib.websocket.client.RetryContext;
import io.ballerina.stdlib.websocket.client.listener.SyncClientConnectorListener;
import io.ballerina.stdlib.websocket.observability.WebSocketObservabilityUtil;
import io.ballerina.stdlib.websocket.server.WebSocketConnectionInfo;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.util.concurrent.EventExecutor;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.GenericFutureListener;
import io.netty.util.concurrent.ImmediateEventExecutor;
import io.netty.util.concurrent.Promise;
import io.netty.util.concurrent.PromiseCombiner;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RetryWriteBinaryHandshakeListener
implements ClientHandshakeListener {
    private final BArray message;
    private final BObject clientEndpoint;
    private final SyncClientConnectorListener connectorListener;
    private WebSocketConnectionInfo connectionInfo;
    private final CompletableFuture<Object> balFuture;
    AtomicBoolean binaryCallbackCompleted;
    private static final Logger logger = LoggerFactory.getLogger(RetryWriteBinaryHandshakeListener.class);

    public RetryWriteBinaryHandshakeListener(BArray message, BObject clientEndpoint, SyncClientConnectorListener connectorListener, CompletableFuture<Object> balFuture, AtomicBoolean textCallbackCompleted) {
        this.message = message;
        this.clientEndpoint = clientEndpoint;
        this.connectorListener = connectorListener;
        this.balFuture = balFuture;
        this.binaryCallbackCompleted = textCallbackCompleted;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onSuccess(WebSocketConnection webSocketConnection, HttpCarbonResponse httpCarbonResponse) {
        this.clientEndpoint.addNativeData("response", (Object)HttpUtil.createResponseStruct((HttpCarbonMessage)httpCarbonResponse));
        WebSocketUtil.populatWebSocketEndpoint(webSocketConnection, this.clientEndpoint);
        this.setWebSocketOpenConnectionInfo(webSocketConnection, this.clientEndpoint, (WebSocketService)this.clientEndpoint.getNativeData("callbackService"));
        this.connectorListener.setConnectionInfo(this.connectionInfo);
        webSocketConnection.removeReadIdleStateHandler();
        WebSocketObservabilityUtil.observeConnection(this.connectionInfo);
        WebSocketConnectionInfo connectionInfo = (WebSocketConnectionInfo)this.clientEndpoint.getNativeData("NATIVE_DATA_WEBSOCKET_CONNECTION_INFO");
        PromiseCombiner promiseCombiner = new PromiseCombiner((EventExecutor)ImmediateEventExecutor.INSTANCE);
        ByteBuf byteBuf = null;
        ByteBuf lastSlice = null;
        try {
            int index;
            WebSocketConnector.setWriteTimeoutHandler(this.clientEndpoint, this.balFuture, this.binaryCallbackCompleted, connectionInfo);
            byteBuf = WebSocketConnector.fromByteArray(ByteBuffer.wrap(this.message.getBytes()));
            int noBytes = byteBuf.readableBytes();
            int size = (Integer)connectionInfo.getWebSocketEndpoint().getNativeData("MAX_FRAME_SIZE");
            for (index = 0; index < noBytes - size; index += size) {
                ByteBuf slice = null;
                try {
                    slice = byteBuf.retainedSlice(index, size);
                    byte[] chunk = WebSocketConnector.getByteChunk(size, slice);
                    ChannelFuture future2 = connectionInfo.getWebSocketConnection().pushBinary(ByteBuffer.wrap(chunk), false);
                    promiseCombiner.add((Future)future2);
                }
                catch (Throwable throwable) {
                    WebSocketConnector.release(slice);
                    throw throwable;
                }
                WebSocketConnector.release(slice);
            }
            lastSlice = byteBuf.retainedSlice(index, noBytes - index);
            byte[] finalChunk = WebSocketConnector.getByteChunk(noBytes - index, lastSlice);
            ChannelFuture webSocketChannelFuture = connectionInfo.getWebSocketConnection().pushBinary(ByteBuffer.wrap(finalChunk), true);
            promiseCombiner.add((Future)webSocketChannelFuture);
            promiseCombiner.finish((Promise)connectionInfo.getWebSocketConnection().getChannel().newPromise().addListener((GenericFutureListener)((ChannelFutureListener)future -> {
                WebSocketConnector.removeWriteTimeoutHandler(this.clientEndpoint, connectionInfo);
                if (webSocketChannelFuture.isSuccess()) {
                    WebSocketUtil.handleWebSocketCallback(this.balFuture, webSocketChannelFuture, logger, connectionInfo, this.binaryCallbackCompleted);
                    WebSocketObservabilityUtil.observeSend("binary", connectionInfo);
                    WebSocketUtil.adjustContextOnSuccess((RetryContext)this.clientEndpoint.getNativeData(WebSocketConstants.RETRY_CONFIG.toString()));
                } else if (!this.binaryCallbackCompleted.get()) {
                    WebSocketUtil.setCallbackFunctionBehaviour(connectionInfo, this.balFuture, future.cause(), this.binaryCallbackCompleted);
                }
            })));
        }
        catch (IllegalAccessException | IllegalStateException e) {
            try {
                logger.error("Error occurred when pushing binary data", (Throwable)e);
                WebSocketObservabilityUtil.observeError(WebSocketObservabilityUtil.getConnectionInfo(this.clientEndpoint), "message_sent", "binary", e.getMessage());
                WebSocketUtil.setCallbackFunctionBehaviour(connectionInfo, this.balFuture, e, this.binaryCallbackCompleted);
            }
            catch (Throwable throwable) {
                WebSocketConnector.release(byteBuf);
                WebSocketConnector.release(lastSlice);
                throw throwable;
            }
            WebSocketConnector.release(byteBuf);
            WebSocketConnector.release(lastSlice);
        }
        WebSocketConnector.release(byteBuf);
        WebSocketConnector.release(lastSlice);
    }

    public void onError(Throwable throwable, HttpCarbonResponse httpCarbonResponse) {
        this.setWebSocketOpenConnectionInfo(null, this.clientEndpoint, (WebSocketService)this.clientEndpoint.getNativeData("callbackService"));
        if (throwable instanceof IOException && WebSocketUtil.reconnectForWrite(this.connectionInfo, this.balFuture, this.binaryCallbackCompleted, null, this.message)) {
            return;
        }
        if (!this.binaryCallbackCompleted.get()) {
            this.balFuture.complete((Object)WebSocketUtil.createErrorByType(throwable));
            this.binaryCallbackCompleted.set(true);
        }
    }

    private void setWebSocketOpenConnectionInfo(WebSocketConnection webSocketConnection, BObject webSocketClient, WebSocketService wsService) {
        this.connectionInfo = new WebSocketConnectionInfo(wsService, webSocketConnection, webSocketClient);
        webSocketClient.addNativeData("NATIVE_DATA_WEBSOCKET_CONNECTION_INFO", (Object)this.connectionInfo);
    }
}

