/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.stdlib.websocket.client.listener;

import io.ballerina.runtime.api.creators.ValueCreator;
import io.ballerina.runtime.api.types.Type;
import io.ballerina.runtime.api.utils.JsonUtils;
import io.ballerina.runtime.api.utils.StringUtils;
import io.ballerina.runtime.api.utils.TypeUtils;
import io.ballerina.runtime.api.utils.ValueUtils;
import io.ballerina.runtime.api.utils.XmlUtils;
import io.ballerina.runtime.api.values.BError;
import io.ballerina.runtime.api.values.BObject;
import io.ballerina.runtime.api.values.BString;
import io.ballerina.runtime.api.values.BTypedesc;
import io.ballerina.stdlib.constraint.Constraints;
import io.ballerina.stdlib.http.transport.contract.websocket.WebSocketBinaryMessage;
import io.ballerina.stdlib.http.transport.contract.websocket.WebSocketCloseMessage;
import io.ballerina.stdlib.http.transport.contract.websocket.WebSocketConnection;
import io.ballerina.stdlib.http.transport.contract.websocket.WebSocketConnectorListener;
import io.ballerina.stdlib.http.transport.contract.websocket.WebSocketControlMessage;
import io.ballerina.stdlib.http.transport.contract.websocket.WebSocketHandshaker;
import io.ballerina.stdlib.http.transport.contract.websocket.WebSocketTextMessage;
import io.ballerina.stdlib.websocket.WebSocketConstants;
import io.ballerina.stdlib.websocket.WebSocketResourceDispatcher;
import io.ballerina.stdlib.websocket.WebSocketUtil;
import io.ballerina.stdlib.websocket.observability.WebSocketObservabilityUtil;
import io.ballerina.stdlib.websocket.server.WebSocketConnectionInfo;
import java.io.IOException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicBoolean;
import org.ballerinalang.langlib.value.FromJsonStringWithType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SyncClientConnectorListener
implements WebSocketConnectorListener {
    private WebSocketConnectionInfo connectionInfo = null;
    private CompletableFuture<Object> callback;
    private BTypedesc targetType;
    private AtomicBoolean futureCompleted;
    private static final Logger logger = LoggerFactory.getLogger(SyncClientConnectorListener.class);

    public void setConnectionInfo(WebSocketConnectionInfo connectionInfo) {
        this.connectionInfo = connectionInfo;
    }

    public void onHandshake(WebSocketHandshaker webSocketHandshaker) {
    }

    public void onMessage(WebSocketTextMessage webSocketTextMessage) {
        Type targetType = null;
        if (this.targetType != null) {
            targetType = TypeUtils.getReferredType((Type)this.targetType.getDescribingType());
        }
        try {
            WebSocketConnectionInfo.StringAggregator stringAggregator = this.connectionInfo.createIfNullAndGetStringAggregator();
            boolean finalFragment = webSocketTextMessage.isFinalFragment();
            if (finalFragment) {
                stringAggregator.appendAggregateString(webSocketTextMessage.getText());
                int typeTag = targetType == null ? 5 : targetType.getTag();
                Object message = switch (typeTag) {
                    case 5 -> StringUtils.fromString((String)stringAggregator.getAggregateString());
                    case 16 -> XmlUtils.parse((String)stringAggregator.getAggregateString());
                    case 24 -> this.cloneWithType(targetType, JsonUtils.parse((String)stringAggregator.getAggregateString()));
                    case 33 -> {
                        if (WebSocketUtil.hasStringType(targetType)) {
                            yield this.cloneWithType(targetType, StringUtils.fromString((String)stringAggregator.getAggregateString()));
                        }
                    }
                    default -> FromJsonStringWithType.fromJsonStringWithType((BString)StringUtils.fromString((String)stringAggregator.getAggregateString()), (BTypedesc)ValueCreator.createTypedescValue((Type)targetType));
                };
                stringAggregator.resetAggregateString();
                if (!this.futureCompleted.get()) {
                    if (message instanceof BError) {
                        this.callback.complete((Object)WebSocketUtil.createWebsocketError(String.format("data binding failed: %s", message), WebSocketConstants.ErrorCode.Error));
                    } else if (this.targetType != null) {
                        boolean validationEnabled = this.connectionInfo.getWebSocketEndpoint().getMapValue(WebSocketConstants.CLIENT_ENDPOINT_CONFIG).getBooleanValue(WebSocketConstants.ANNOTATION_ATTR_VALIDATION_ENABLED);
                        this.validateConstraints(message, validationEnabled);
                    } else {
                        this.callback.complete(message);
                    }
                    this.futureCompleted.set(true);
                    this.connectionInfo.getCallbacks().remove(this.callback);
                }
                this.connectionInfo.getWebSocketConnection().removeReadIdleStateHandler();
            } else {
                stringAggregator.appendAggregateString(webSocketTextMessage.getText());
                this.connectionInfo.getWebSocketConnection().readNextFrame();
            }
        }
        catch (BError | IllegalAccessException e) {
            if (e instanceof BError) {
                this.callback.complete((Object)WebSocketUtil.createWebsocketError(String.format("data binding failed: %s", e), WebSocketConstants.ErrorCode.Error));
            } else {
                this.callback.complete((Object)WebSocketUtil.createWebsocketError(e.getMessage(), WebSocketConstants.ErrorCode.ConnectionClosureError));
            }
            this.futureCompleted.set(true);
        }
    }

    private void validateConstraints(Object message, boolean validationEnabled) {
        if (validationEnabled) {
            Object validationResult = Constraints.validate((Object)message, (BTypedesc)this.targetType);
            if (validationResult instanceof BError) {
                this.callback.complete((Object)WebSocketUtil.createWebsocketErrorWithCause(String.format("data validation failed: %s", validationResult), WebSocketConstants.ErrorCode.PayloadValidationError, (BError)((Object)validationResult)));
            } else {
                this.callback.complete(message);
            }
        } else {
            this.callback.complete(message);
        }
    }

    public void onMessage(WebSocketBinaryMessage webSocketBinaryMessage) {
        Type targetType = null;
        if (this.targetType != null) {
            targetType = TypeUtils.getReferredType((Type)this.targetType.getDescribingType());
        }
        try {
            WebSocketConnectionInfo.ByteArrAggregator byteArrAggregator = this.connectionInfo.createIfNullAndGetByteArrAggregator();
            boolean finalFragment = webSocketBinaryMessage.isFinalFragment();
            if (finalFragment) {
                byteArrAggregator.appendAggregateArr(webSocketBinaryMessage.getByteArray());
                byte[] binMsg = byteArrAggregator.getAggregateByteArr();
                byteArrAggregator.resetAggregateByteArr();
                int typeTag = targetType == null || targetType.toString().equals("byte[]") ? 2 : targetType.getTag();
                Object message = switch (typeTag) {
                    case 2 -> ValueCreator.createArrayValue((byte[])binMsg);
                    case 5 -> WebSocketUtil.getBString(binMsg);
                    case 16 -> XmlUtils.parse((BString)WebSocketUtil.getBString(binMsg));
                    case 24 -> this.cloneWithType(targetType, JsonUtils.parse((BString)WebSocketUtil.getBString(binMsg)));
                    case 33 -> {
                        if (WebSocketUtil.hasByteArrayType(targetType)) {
                            yield this.cloneWithType(targetType, ValueCreator.createArrayValue((byte[])binMsg));
                        }
                    }
                    default -> FromJsonStringWithType.fromJsonStringWithType((BString)WebSocketUtil.getBString(binMsg), (BTypedesc)ValueCreator.createTypedescValue((Type)targetType));
                };
                if (message instanceof BError) {
                    this.callback.complete((Object)WebSocketUtil.createWebsocketError(String.format("data binding failed: %s", message), WebSocketConstants.ErrorCode.Error));
                } else if (this.targetType != null) {
                    boolean validationEnabled = this.connectionInfo.getWebSocketEndpoint().getMapValue(WebSocketConstants.CLIENT_ENDPOINT_CONFIG).getBooleanValue(WebSocketConstants.ANNOTATION_ATTR_VALIDATION_ENABLED);
                    this.validateConstraints(message, validationEnabled);
                } else {
                    this.callback.complete(message);
                }
                this.futureCompleted.set(true);
                this.connectionInfo.getCallbacks().remove(this.callback);
                this.connectionInfo.getWebSocketConnection().removeReadIdleStateHandler();
            } else {
                byteArrAggregator.appendAggregateArr(webSocketBinaryMessage.getByteArray());
                this.connectionInfo.getWebSocketConnection().readNextFrame();
            }
        }
        catch (IOException | IllegalAccessException e) {
            this.callback.complete((Object)WebSocketUtil.createWebsocketError(e.getMessage(), WebSocketConstants.ErrorCode.ConnectionClosureError));
            this.futureCompleted.set(true);
        }
    }

    public void onMessage(WebSocketControlMessage webSocketControlMessage) {
        WebSocketResourceDispatcher.dispatchOnPingOnPong(this.connectionInfo, webSocketControlMessage, false);
    }

    public void onMessage(WebSocketCloseMessage webSocketCloseMessage) {
        try {
            if (this.callback != null && !this.futureCompleted.get()) {
                String closeReason;
                int closeCode = webSocketCloseMessage.getCloseCode();
                String string = closeReason = webSocketCloseMessage.getCloseReason() == null || webSocketCloseMessage.getCloseReason().equals("") ? String.format("%s %s %d", "Connection closed", "Status code:", closeCode) : String.format("%s: %s %d", webSocketCloseMessage.getCloseReason(), "Status code:", closeCode);
                if (WebSocketUtil.hasRetryConfig(this.connectionInfo.getWebSocketEndpoint())) {
                    if (closeCode == 1006 && WebSocketUtil.reconnect(this.connectionInfo, this.callback, this.futureCompleted)) {
                        return;
                    }
                    if (closeCode != 1006) {
                        logger.debug("{} {}", (Object)"Reconnect attempt not made because of close initiated by the server: ", (Object)this.connectionInfo.getWebSocketEndpoint().getStringValue(WebSocketConstants.CLIENT_URL_CONFIG));
                    }
                }
                if (!this.futureCompleted.get()) {
                    this.callback.complete((Object)WebSocketUtil.createWebsocketError(closeReason, WebSocketConstants.ErrorCode.ConnectionClosureError));
                    this.futureCompleted.set(true);
                }
                WebSocketConnection wsConnection = this.connectionInfo.getWebSocketConnection();
                wsConnection.removeReadIdleStateHandler();
                WebSocketResourceDispatcher.finishConnectionClosureIfOpen(wsConnection, closeCode, this.connectionInfo);
                if (this.connectionInfo.getCallbacks().size() > 0) {
                    this.connectionInfo.getCallbacks().forEach(callback -> callback.complete(WebSocketUtil.createWebsocketError("Connection closed", WebSocketConstants.ErrorCode.ConnectionClosureError)));
                }
            }
        }
        catch (IllegalAccessException e) {
            this.callback.complete((Object)WebSocketUtil.createWebsocketError("Connection already closed", WebSocketConstants.ErrorCode.ConnectionClosureError));
        }
    }

    public void onError(WebSocketConnection webSocketConnection, Throwable throwable) {
        try {
            if (this.callback != null && !this.futureCompleted.get()) {
                BObject webSocketClient = this.connectionInfo.getWebSocketEndpoint();
                if (WebSocketUtil.hasRetryConfig(webSocketClient) && throwable instanceof IOException && WebSocketUtil.reconnect(this.connectionInfo, this.callback, this.futureCompleted)) {
                    return;
                }
                this.callback.complete((Object)WebSocketUtil.createWebsocketError(throwable.getMessage(), WebSocketConstants.ErrorCode.Error));
                this.futureCompleted.set(true);
                this.connectionInfo.getWebSocketConnection().removeReadIdleStateHandler();
            }
        }
        catch (IllegalAccessException e) {
            this.connectionInfo.getWebSocketEndpoint().set(WebSocketConstants.LISTENER_IS_OPEN_FIELD, (Object)false);
        }
    }

    public void onIdleTimeout(WebSocketControlMessage controlMessage) {
        try {
            this.callback.complete((Object)WebSocketUtil.createWebsocketError("Read timed out", WebSocketConstants.ErrorCode.ReadTimedOutError));
            this.connectionInfo.getWebSocketConnection().removeReadIdleStateHandler();
        }
        catch (IllegalAccessException illegalAccessException) {
            // empty catch block
        }
    }

    public void onClose(WebSocketConnection webSocketConnection) {
        WebSocketObservabilityUtil.observeClose(this.connectionInfo);
        if (this.connectionInfo.getCallbacks().size() > 0) {
            this.connectionInfo.getCallbacks().forEach(callback -> callback.complete(WebSocketUtil.createWebsocketError("Connection closed", WebSocketConstants.ErrorCode.ConnectionClosureError)));
        }
        try {
            WebSocketUtil.setListenerOpenField(this.connectionInfo);
        }
        catch (IllegalAccessException illegalAccessException) {
            // empty catch block
        }
    }

    public void setCallback(CompletableFuture<Object> callback) {
        this.callback = callback;
    }

    public void setTargetType(BTypedesc targetType) {
        this.targetType = targetType;
    }

    public void setFutureCompleted(AtomicBoolean futureCompleted) {
        this.futureCompleted = futureCompleted;
    }

    private Object cloneWithType(Type targetType, Object value) {
        try {
            return ValueUtils.convert((Object)value, (Type)targetType);
        }
        catch (BError e) {
            return e;
        }
    }
}

