/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.stdlib.websocket.server;

import io.ballerina.runtime.api.values.BObject;
import io.ballerina.stdlib.http.transport.contract.websocket.ServerHandshakeListener;
import io.ballerina.stdlib.http.transport.contract.websocket.WebSocketConnection;
import io.ballerina.stdlib.websocket.WebSocketConstants;
import io.ballerina.stdlib.websocket.WebSocketResourceDispatcher;
import io.ballerina.stdlib.websocket.WebSocketUtil;
import io.ballerina.stdlib.websocket.server.WebSocketConnectionManager;
import io.ballerina.stdlib.websocket.server.WebSocketServerService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class UpgradeListener
implements ServerHandshakeListener {
    private static final Logger logger = LoggerFactory.getLogger(UpgradeListener.class);
    private final WebSocketServerService wsService;
    private final Object dispatchingService;
    private final WebSocketConnectionManager connectionManager;

    UpgradeListener(WebSocketServerService wsService, WebSocketConnectionManager connectionManager, Object dispatchingService) {
        this.wsService = wsService;
        this.connectionManager = connectionManager;
        this.dispatchingService = dispatchingService;
    }

    public void onSuccess(WebSocketConnection webSocketConnection) {
        BObject webSocketCaller = WebSocketUtil.createAndPopulateWebSocketCaller(webSocketConnection, this.wsService, this.connectionManager);
        this.wsService.addWsService(webSocketConnection.getChannelId(), this.dispatchingService);
        WebSocketResourceDispatcher.dispatchOnOpen(webSocketConnection, webSocketCaller, this.wsService);
    }

    public void onError(Throwable throwable) {
        String msg = "Unable to complete WebSocket handshake: ";
        logger.error(msg, throwable);
        throw WebSocketUtil.getWebSocketError("", throwable, WebSocketConstants.ErrorCode.Error.errorCode(), null);
    }
}

