/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.stdlib.websocket.server;

import io.ballerina.runtime.api.values.BObject;
import io.ballerina.stdlib.http.transport.contract.websocket.WebSocketConnection;
import io.ballerina.stdlib.websocket.WebSocketService;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;

public class WebSocketConnectionInfo {
    private final WebSocketService webSocketService;
    private final BObject webSocketEndpoint;
    private final WebSocketConnection webSocketConnection;
    private StringAggregator stringAggregator = null;
    private ByteArrAggregator byteArrAggregator = null;
    private List<CompletableFuture<Object>> callbacks = new ArrayList<CompletableFuture<Object>>();

    public WebSocketConnectionInfo(WebSocketService webSocketService, WebSocketConnection webSocketConnection, BObject webSocketEndpoint) {
        this.webSocketService = webSocketService;
        this.webSocketConnection = webSocketConnection;
        this.webSocketEndpoint = webSocketEndpoint;
    }

    public WebSocketService getService() {
        return this.webSocketService;
    }

    public BObject getWebSocketEndpoint() {
        return this.webSocketEndpoint;
    }

    public WebSocketConnection getWebSocketConnection() throws IllegalAccessException {
        if (this.webSocketConnection != null) {
            return this.webSocketConnection;
        }
        throw new IllegalAccessException("WebSocket connection failure");
    }

    public StringAggregator createIfNullAndGetStringAggregator() {
        if (this.stringAggregator == null) {
            this.stringAggregator = new StringAggregator();
        }
        return this.stringAggregator;
    }

    public ByteArrAggregator createIfNullAndGetByteArrAggregator() {
        if (this.byteArrAggregator == null) {
            this.byteArrAggregator = new ByteArrAggregator();
        }
        return this.byteArrAggregator;
    }

    public void addCallback(CompletableFuture<Object> callback) {
        this.callbacks.add(callback);
    }

    public List<CompletableFuture<Object>> getCallbacks() {
        return this.callbacks;
    }

    public static class StringAggregator {
        private StringBuilder aggregateStrBuilder = new StringBuilder();

        private StringAggregator() {
        }

        public String getAggregateString() {
            return this.aggregateStrBuilder.toString();
        }

        public void appendAggregateString(String aggregateString) {
            this.aggregateStrBuilder.append(aggregateString);
        }

        public void resetAggregateString() {
            this.aggregateStrBuilder = new StringBuilder();
        }
    }

    public static class ByteArrAggregator {
        private ByteArrayOutputStream aggregateArr = new ByteArrayOutputStream();

        private ByteArrAggregator() {
        }

        public byte[] getAggregateByteArr() {
            return this.aggregateArr.toByteArray();
        }

        public void appendAggregateArr(byte[] aggregateByteArr) throws IOException {
            this.aggregateArr.write(aggregateByteArr);
        }

        public void resetAggregateByteArr() {
            this.aggregateArr = new ByteArrayOutputStream();
        }
    }
}

