/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.stdlib.websocket.serviceendpoint;

import io.ballerina.runtime.api.utils.StringUtils;
import io.ballerina.runtime.api.values.BObject;
import io.ballerina.stdlib.http.transport.contract.PortBindingEventListener;
import io.ballerina.stdlib.http.transport.contract.ServerConnector;
import io.ballerina.stdlib.http.transport.contract.ServerConnectorFuture;
import io.ballerina.stdlib.http.transport.contract.websocket.WebSocketConnectorListener;
import io.ballerina.stdlib.websocket.WebSocketConnectorPortBindingListener;
import io.ballerina.stdlib.websocket.WebSocketConstants;
import io.ballerina.stdlib.websocket.WebSocketUtil;
import io.ballerina.stdlib.websocket.server.WebSocketServerListener;
import io.ballerina.stdlib.websocket.serviceendpoint.AbstractWebsocketNativeFunction;

public class Start
extends AbstractWebsocketNativeFunction {
    public static Object start(BObject listener) {
        BObject httpListener = (BObject)listener.get(StringUtils.fromString((String)"httpListener"));
        if (!Start.isConnectorStarted(listener) && !Start.isConnectorStarted(httpListener)) {
            return Start.startServerConnector(listener);
        }
        if (httpListener != null) {
            ServerConnectorFuture serverConnectorFuture = (ServerConnectorFuture)((BObject)listener.get(StringUtils.fromString((String)"httpListener"))).getNativeData("ServerConnectorFuture");
            WebSocketServerListener wsListener = new WebSocketServerListener(Start.getWebSocketServicesRegistry(listener));
            serverConnectorFuture.setWebSocketConnectorListener((WebSocketConnectorListener)wsListener);
        }
        return null;
    }

    private static Object startServerConnector(BObject serviceEndpoint) {
        ServerConnector serverConnector = Start.getServerConnector(serviceEndpoint);
        ServerConnectorFuture serverConnectorFuture = serverConnector.start();
        WebSocketServerListener wsListener = new WebSocketServerListener(Start.getWebSocketServicesRegistry(serviceEndpoint));
        WebSocketConnectorPortBindingListener portBindingListener = new WebSocketConnectorPortBindingListener();
        serverConnectorFuture.setWebSocketConnectorListener((WebSocketConnectorListener)wsListener);
        serverConnectorFuture.setPortBindingEventListener((PortBindingEventListener)portBindingListener);
        try {
            serverConnectorFuture.sync();
        }
        catch (Exception ex) {
            throw WebSocketUtil.createWebsocketError(String.format("failed to start the listener on '%s': %s", serverConnector.getConnectorID(), ex.getMessage()), WebSocketConstants.ErrorCode.Error);
        }
        serviceEndpoint.addNativeData("CONNECTOR_STARTED", (Object)true);
        return null;
    }

    private Start() {
    }
}

