/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.protoc.builder.stub;

import com.google.protobuf.DescriptorProtos;
import io.ballerina.protoc.builder.balgen.BalGenerationUtils;
import java.io.ByteArrayInputStream;
import java.io.IOException;

public class Descriptor {
    private final String descriptorKey;
    private final String descriptorData;

    private Descriptor(String descriptorKey, String descriptorData) {
        this.descriptorKey = descriptorKey;
        this.descriptorData = descriptorData;
    }

    public String getKey() {
        return this.descriptorKey;
    }

    public String getData() {
        return this.descriptorData;
    }

    public static Builder newBuilder(byte[] descriptorData) {
        return new Builder(descriptorData);
    }

    public static class Builder {
        byte[] descriptorData;

        private Builder(byte[] descriptorData) {
            this.descriptorData = descriptorData;
        }

        public Descriptor build() throws IOException {
            try (ByteArrayInputStream targetStream = new ByteArrayInputStream(this.descriptorData);){
                DescriptorProtos.FileDescriptorProto fileDescriptorSet = DescriptorProtos.FileDescriptorProto.parseFrom(targetStream);
                Descriptor descriptor = new Descriptor(fileDescriptorSet.getName(), BalGenerationUtils.bytesToHex(this.descriptorData));
                return descriptor;
            }
        }
    }
}

