/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.protoc.builder.stub;

import com.google.protobuf.DescriptorProtos;
import io.ballerina.protoc.builder.BallerinaFileBuilder;
import io.ballerina.protoc.builder.stub.EnumField;
import java.util.ArrayList;
import java.util.List;

public class EnumMessage {
    private final List<EnumField> fieldList;
    private final String messageName;

    private EnumMessage(String messageName, List<EnumField> fieldList) {
        this.messageName = messageName;
        this.fieldList = fieldList;
    }

    public static Builder newBuilder(DescriptorProtos.EnumDescriptorProto enumDescriptor) {
        return new Builder(enumDescriptor, enumDescriptor.getName());
    }

    public static Builder newBuilder(DescriptorProtos.EnumDescriptorProto enumDescriptor, String messageName) {
        return new Builder(enumDescriptor, messageName);
    }

    public List<EnumField> getFieldList() {
        return this.fieldList;
    }

    public String getMessageName() {
        return this.messageName;
    }

    public static class Builder {
        private final DescriptorProtos.EnumDescriptorProto enumDescriptor;
        private final String messageName;

        public EnumMessage build() {
            int index = 0;
            ArrayList<EnumField> fieldList = new ArrayList<EnumField>();
            for (DescriptorProtos.EnumValueDescriptorProto fieldDescriptor : this.enumDescriptor.getValueList()) {
                EnumField field = EnumField.newBuilder(fieldDescriptor).build();
                fieldList.add(field);
                if (index == 0) {
                    BallerinaFileBuilder.enumDefaultValueMap.put(this.messageName, field.getName());
                }
                ++index;
            }
            return new EnumMessage(this.messageName, fieldList);
        }

        private Builder(DescriptorProtos.EnumDescriptorProto enumDescriptor, String messageName) {
            this.enumDescriptor = enumDescriptor;
            this.messageName = messageName;
        }
    }
}

