/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.protoc.builder.syntaxtree.components;

import io.ballerina.compiler.syntax.tree.AbstractNodeFactory;
import io.ballerina.compiler.syntax.tree.AnnotationNode;
import io.ballerina.compiler.syntax.tree.ExpressionNode;
import io.ballerina.compiler.syntax.tree.MetadataNode;
import io.ballerina.compiler.syntax.tree.MinutiaeList;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NodeFactory;
import io.ballerina.compiler.syntax.tree.NodeList;
import io.ballerina.compiler.syntax.tree.SeparatedNodeList;
import io.ballerina.compiler.syntax.tree.ServiceDeclarationNode;
import io.ballerina.compiler.syntax.tree.SimpleNameReferenceNode;
import io.ballerina.compiler.syntax.tree.SyntaxKind;
import io.ballerina.compiler.syntax.tree.Token;
import io.ballerina.compiler.syntax.tree.TypeDescriptorNode;
import io.ballerina.protoc.builder.syntaxtree.constants.SyntaxTreeConstants;
import java.util.ArrayList;

public class Service {
    private final NodeList<Token> qualifierList = NodeFactory.createEmptyNodeList();
    private final TypeDescriptorNode typeDescriptor = null;
    private NodeList<Node> absoluteResourcePath = NodeFactory.createEmptyNodeList();
    private final SeparatedNodeList<ExpressionNode> expressions;
    private NodeList<Node> members = NodeFactory.createEmptyNodeList();
    private NodeList<AnnotationNode> annotations = NodeFactory.createEmptyNodeList();

    public Service(String[] resourcePaths, String[] expressionList) {
        for (String path : resourcePaths) {
            this.absoluteResourcePath = this.absoluteResourcePath.add((Node)NodeFactory.createBasicLiteralNode((SyntaxKind)SyntaxKind.STRING_LITERAL, (Token)NodeFactory.createLiteralValueToken((SyntaxKind)SyntaxKind.STRING_LITERAL_TOKEN, (String)path, (MinutiaeList)NodeFactory.createEmptyMinutiaeList(), (MinutiaeList)NodeFactory.createEmptyMinutiaeList())));
        }
        ArrayList<SimpleNameReferenceNode> expressionNodes = new ArrayList<SimpleNameReferenceNode>();
        for (String expr : expressionList) {
            expressionNodes.add(NodeFactory.createSimpleNameReferenceNode((Token)AbstractNodeFactory.createIdentifierToken((String)expr)));
        }
        this.expressions = NodeFactory.createSeparatedNodeList(expressionNodes);
    }

    public ServiceDeclarationNode getServiceDeclarationNode() {
        return NodeFactory.createServiceDeclarationNode((MetadataNode)NodeFactory.createMetadataNode(null, this.annotations), this.qualifierList, (Token)SyntaxTreeConstants.SYNTAX_TREE_KEYWORD_SERVICE, (TypeDescriptorNode)this.typeDescriptor, this.absoluteResourcePath, (Token)SyntaxTreeConstants.SYNTAX_TREE_KEYWORD_ON, this.expressions, (Token)SyntaxTreeConstants.SYNTAX_TREE_OPEN_BRACE, this.members, (Token)SyntaxTreeConstants.SYNTAX_TREE_CLOSE_BRACE, null);
    }

    public void addMember(Node member) {
        if (this.members.size() == 0) {
            this.members = this.members.add((Node)SyntaxTreeConstants.SYNTAX_TREE_BLANK_LINE);
        }
        this.members = this.members.add(member);
    }

    public void addAnnotation(AnnotationNode annotation) {
        this.annotations = this.annotations.add((Node)annotation);
    }
}

