/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.protoc.builder.syntaxtree.components;

import io.ballerina.compiler.syntax.tree.AbstractNodeFactory;
import io.ballerina.compiler.syntax.tree.ArrayDimensionNode;
import io.ballerina.compiler.syntax.tree.ArrayTypeDescriptorNode;
import io.ballerina.compiler.syntax.tree.BindingPatternNode;
import io.ballerina.compiler.syntax.tree.BuiltinSimpleNameReferenceNode;
import io.ballerina.compiler.syntax.tree.CaptureBindingPatternNode;
import io.ballerina.compiler.syntax.tree.ExpressionNode;
import io.ballerina.compiler.syntax.tree.IdentifierToken;
import io.ballerina.compiler.syntax.tree.ListBindingPatternNode;
import io.ballerina.compiler.syntax.tree.MapTypeDescriptorNode;
import io.ballerina.compiler.syntax.tree.NilTypeDescriptorNode;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NodeFactory;
import io.ballerina.compiler.syntax.tree.NodeList;
import io.ballerina.compiler.syntax.tree.ObjectFieldNode;
import io.ballerina.compiler.syntax.tree.OptionalTypeDescriptorNode;
import io.ballerina.compiler.syntax.tree.ParameterizedTypeDescriptorNode;
import io.ballerina.compiler.syntax.tree.QualifiedNameReferenceNode;
import io.ballerina.compiler.syntax.tree.ReturnTypeDescriptorNode;
import io.ballerina.compiler.syntax.tree.SeparatedNodeList;
import io.ballerina.compiler.syntax.tree.SimpleNameReferenceNode;
import io.ballerina.compiler.syntax.tree.StreamTypeDescriptorNode;
import io.ballerina.compiler.syntax.tree.SyntaxKind;
import io.ballerina.compiler.syntax.tree.Token;
import io.ballerina.compiler.syntax.tree.TupleTypeDescriptorNode;
import io.ballerina.compiler.syntax.tree.TypeCastExpressionNode;
import io.ballerina.compiler.syntax.tree.TypeCastParamNode;
import io.ballerina.compiler.syntax.tree.TypeDescriptorNode;
import io.ballerina.compiler.syntax.tree.TypeParameterNode;
import io.ballerina.compiler.syntax.tree.TypeReferenceNode;
import io.ballerina.compiler.syntax.tree.TypedBindingPatternNode;
import io.ballerina.compiler.syntax.tree.UnionTypeDescriptorNode;
import io.ballerina.compiler.syntax.tree.WildcardBindingPatternNode;
import io.ballerina.protoc.builder.syntaxtree.components.Record;
import io.ballerina.protoc.builder.syntaxtree.constants.SyntaxTreeConstants;
import java.util.ArrayList;

public class TypeDescriptor {
    private TypeDescriptor() {
    }

    public static QualifiedNameReferenceNode getQualifiedNameReferenceNode(String modulePrefix, String identifier) {
        return NodeFactory.createQualifiedNameReferenceNode((Token)AbstractNodeFactory.createIdentifierToken((String)modulePrefix), (Node)SyntaxTreeConstants.SYNTAX_TREE_COLON, (IdentifierToken)AbstractNodeFactory.createIdentifierToken((String)(identifier + " ")));
    }

    public static OptionalTypeDescriptorNode getOptionalTypeDescriptorNode(String modulePrefix, String identifier) {
        if (modulePrefix.isEmpty()) {
            return NodeFactory.createOptionalTypeDescriptorNode((Node)TypeDescriptor.getSimpleNameReferenceNode(identifier), (Token)SyntaxTreeConstants.SYNTAX_TREE_QUESTION_MARK);
        }
        return NodeFactory.createOptionalTypeDescriptorNode((Node)TypeDescriptor.getQualifiedNameReferenceNode(modulePrefix, identifier), (Token)SyntaxTreeConstants.SYNTAX_TREE_QUESTION_MARK);
    }

    public static UnionTypeDescriptorNode getUnionTypeDescriptorNode(TypeDescriptorNode lhs, TypeDescriptorNode rhs) {
        return NodeFactory.createUnionTypeDescriptorNode((TypeDescriptorNode)lhs, (Token)SyntaxTreeConstants.SYNTAX_TREE_PIPE, (TypeDescriptorNode)rhs);
    }

    public static BuiltinSimpleNameReferenceNode getBuiltinSimpleNameReferenceNode(String name) {
        return NodeFactory.createBuiltinSimpleNameReferenceNode((SyntaxKind)(switch (name) {
            case "int" -> SyntaxKind.INT_TYPE_DESC;
            case "float" -> SyntaxKind.DECIMAL_TYPE_DESC;
            case "boolean" -> SyntaxKind.BOOLEAN_TYPE_DESC;
            case "byte" -> SyntaxKind.BYTE_TYPE_DESC;
            case "var" -> SyntaxKind.VAR_TYPE_DESC;
            default -> SyntaxKind.STRING_TYPE_DESC;
        }), (Token)AbstractNodeFactory.createIdentifierToken((String)(name + " ")));
    }

    public static ParameterizedTypeDescriptorNode getErrorTypeDescriptorNode() {
        return NodeFactory.createParameterizedTypeDescriptorNode((SyntaxKind)SyntaxKind.ERROR_TYPE_DESC, (Token)AbstractNodeFactory.createIdentifierToken((String)"error"), null);
    }

    public static ArrayTypeDescriptorNode getArrayTypeDescriptorNode(String type) {
        ArrayDimensionNode arrayDimensionNode = NodeFactory.createArrayDimensionNode((Token)SyntaxTreeConstants.SYNTAX_TREE_OPEN_BRACKET, null, (Token)SyntaxTreeConstants.SYNTAX_TREE_CLOSE_BRACKET);
        NodeList dimensionList = NodeFactory.createNodeList((Node[])new ArrayDimensionNode[]{arrayDimensionNode});
        return NodeFactory.createArrayTypeDescriptorNode((TypeDescriptorNode)TypeDescriptor.getBuiltinSimpleNameReferenceNode(type), (NodeList)dimensionList);
    }

    public static ArrayTypeDescriptorNode getArrayTypeDescriptorNode(Record type) {
        ArrayDimensionNode arrayDimensionNode = NodeFactory.createArrayDimensionNode((Token)SyntaxTreeConstants.SYNTAX_TREE_OPEN_BRACKET, null, (Token)SyntaxTreeConstants.SYNTAX_TREE_CLOSE_BRACKET);
        NodeList dimensionList = NodeFactory.createNodeList((Node[])new ArrayDimensionNode[]{arrayDimensionNode});
        return NodeFactory.createArrayTypeDescriptorNode((TypeDescriptorNode)type.getRecordTypeDescriptorNode(), (NodeList)dimensionList);
    }

    public static TypeReferenceNode getTypeReferenceNode(Node typeName) {
        return NodeFactory.createTypeReferenceNode((Token)SyntaxTreeConstants.SYNTAX_TREE_ASTERISK, (Node)typeName, (Token)SyntaxTreeConstants.SYNTAX_TREE_SEMICOLON);
    }

    public static ObjectFieldNode getObjectFieldNode(String visibility, String[] qualifiers, Node typeName, String fieldName) {
        NodeList qualifierList = NodeFactory.createEmptyNodeList();
        for (String qualifier : qualifiers) {
            qualifierList = qualifierList.add((Node)AbstractNodeFactory.createIdentifierToken((String)(qualifier + " ")));
        }
        return NodeFactory.createObjectFieldNode(null, (Token)AbstractNodeFactory.createIdentifierToken((String)("\n" + visibility + " ")), (NodeList)qualifierList, (Node)typeName, (Token)AbstractNodeFactory.createIdentifierToken((String)fieldName), null, null, (Token)SyntaxTreeConstants.SYNTAX_TREE_SEMICOLON);
    }

    public static StreamTypeDescriptorNode getStreamTypeDescriptorNode(Node lhs, Node rhs) {
        Token comma = rhs == null ? null : SyntaxTreeConstants.SYNTAX_TREE_COMMA;
        return NodeFactory.createStreamTypeDescriptorNode((Token)SyntaxTreeConstants.SYNTAX_TREE_KEYWORD_STREAM, (Node)NodeFactory.createStreamTypeParamsNode((Token)SyntaxTreeConstants.SYNTAX_TREE_IT, (Node)lhs, (Token)comma, (Node)rhs, (Token)SyntaxTreeConstants.SYNTAX_TREE_GT));
    }

    public static CaptureBindingPatternNode getCaptureBindingPatternNode(String name) {
        return NodeFactory.createCaptureBindingPatternNode((Token)AbstractNodeFactory.createIdentifierToken((String)name));
    }

    public static WildcardBindingPatternNode getWildcardBindingPatternNode() {
        return NodeFactory.createWildcardBindingPatternNode((Token)SyntaxTreeConstants.SYNTAX_TREE_UNDERSCORE);
    }

    public static TypedBindingPatternNode getTypedBindingPatternNode(TypeDescriptorNode typeDescriptorNode, BindingPatternNode bindingPatternNode) {
        return NodeFactory.createTypedBindingPatternNode((TypeDescriptorNode)typeDescriptorNode, (BindingPatternNode)bindingPatternNode);
    }

    public static TupleTypeDescriptorNode getTupleTypeDescriptorNode(SeparatedNodeList<Node> memberTypeDesc) {
        return NodeFactory.createTupleTypeDescriptorNode((Token)SyntaxTreeConstants.SYNTAX_TREE_OPEN_BRACKET, memberTypeDesc, (Token)SyntaxTreeConstants.SYNTAX_TREE_CLOSE_BRACKET);
    }

    public static ListBindingPatternNode getListBindingPatternNode(String[] bindingPatterns) {
        ArrayList<Object> bindingPatterNodes = new ArrayList<Object>();
        for (String bindingPattern : bindingPatterns) {
            if (bindingPatterNodes.size() > 0) {
                bindingPatterNodes.add(SyntaxTreeConstants.SYNTAX_TREE_COMMA);
            }
            if (bindingPattern.equals("_")) {
                bindingPatterNodes.add(TypeDescriptor.getWildcardBindingPatternNode());
                continue;
            }
            bindingPatterNodes.add(TypeDescriptor.getCaptureBindingPatternNode(bindingPattern));
        }
        return NodeFactory.createListBindingPatternNode((Token)SyntaxTreeConstants.SYNTAX_TREE_OPEN_BRACKET, (SeparatedNodeList)NodeFactory.createSeparatedNodeList(bindingPatterNodes), (Token)SyntaxTreeConstants.SYNTAX_TREE_CLOSE_BRACKET);
    }

    public static TypeCastExpressionNode getTypeCastExpressionNode(String typeCastParam, ExpressionNode expression) {
        return NodeFactory.createTypeCastExpressionNode((Token)SyntaxTreeConstants.SYNTAX_TREE_IT, (TypeCastParamNode)NodeFactory.createTypeCastParamNode((NodeList)NodeFactory.createEmptyNodeList(), (Node)TypeDescriptor.getBuiltinSimpleNameReferenceNode(typeCastParam)), (Token)SyntaxTreeConstants.SYNTAX_TREE_GT, (ExpressionNode)expression);
    }

    public static ReturnTypeDescriptorNode getReturnTypeDescriptorNode(Node type) {
        NodeList annotations = NodeFactory.createEmptyNodeList();
        return NodeFactory.createReturnTypeDescriptorNode((Token)SyntaxTreeConstants.SYNTAX_TREE_KEYWORD_RETURNS, (NodeList)annotations, (Node)type);
    }

    public static NilTypeDescriptorNode getNilTypeDescriptorNode() {
        return NodeFactory.createNilTypeDescriptorNode((Token)SyntaxTreeConstants.SYNTAX_TREE_OPEN_PAREN, (Token)SyntaxTreeConstants.SYNTAX_TREE_CLOSE_PAREN);
    }

    public static SimpleNameReferenceNode getSimpleNameReferenceNode(String name) {
        return NodeFactory.createSimpleNameReferenceNode((Token)AbstractNodeFactory.createIdentifierToken((String)(name + " ")));
    }

    public static MapTypeDescriptorNode getMapTypeDescriptorNode(TypeDescriptorNode descriptorNode) {
        return NodeFactory.createMapTypeDescriptorNode((Token)AbstractNodeFactory.createIdentifierToken((String)"map"), (TypeParameterNode)NodeFactory.createTypeParameterNode((Token)SyntaxTreeConstants.SYNTAX_TREE_IT, (TypeDescriptorNode)descriptorNode, (Token)SyntaxTreeConstants.SYNTAX_TREE_GT));
    }
}

