/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.protoc.builder.syntaxtree.utils;

import io.ballerina.compiler.syntax.tree.BindingPatternNode;
import io.ballerina.compiler.syntax.tree.ExpressionNode;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NodeFactory;
import io.ballerina.compiler.syntax.tree.SeparatedNodeList;
import io.ballerina.compiler.syntax.tree.StatementNode;
import io.ballerina.compiler.syntax.tree.TypeDescriptorNode;
import io.ballerina.compiler.syntax.tree.TypedBindingPatternNode;
import io.ballerina.protoc.MethodDescriptor;
import io.ballerina.protoc.builder.stub.Method;
import io.ballerina.protoc.builder.syntaxtree.components.Class;
import io.ballerina.protoc.builder.syntaxtree.components.Expression;
import io.ballerina.protoc.builder.syntaxtree.components.Function;
import io.ballerina.protoc.builder.syntaxtree.components.IfElse;
import io.ballerina.protoc.builder.syntaxtree.components.Map;
import io.ballerina.protoc.builder.syntaxtree.components.Statement;
import io.ballerina.protoc.builder.syntaxtree.components.TypeDescriptor;
import io.ballerina.protoc.builder.syntaxtree.components.VariableDeclaration;
import io.ballerina.protoc.builder.syntaxtree.constants.SyntaxTreeConstants;
import io.ballerina.protoc.builder.syntaxtree.utils.CommonUtils;

public class ClientUtils {
    private ClientUtils() {
    }

    public static Function getStreamingClientFunction(Method method) {
        String methodName = method.getMethodType().equals((Object)MethodDescriptor.MethodType.BIDI_STREAMING) ? "executeBidirectionalStreaming" : "executeClientStreaming";
        String clientName = CommonUtils.capitalize(method.getMethodName()) + "StreamingClient";
        Function function = new Function(method.getMethodName());
        function.addReturns((TypeDescriptorNode)TypeDescriptor.getUnionTypeDescriptorNode((TypeDescriptorNode)TypeDescriptor.getSimpleNameReferenceNode(clientName), (TypeDescriptorNode)SyntaxTreeConstants.SYNTAX_TREE_GRPC_ERROR));
        VariableDeclaration sClient = new VariableDeclaration(TypeDescriptor.getTypedBindingPatternNode((TypeDescriptorNode)TypeDescriptor.getQualifiedNameReferenceNode("grpc", "StreamingClient"), (BindingPatternNode)TypeDescriptor.getCaptureBindingPatternNode("sClient")), (ExpressionNode)Expression.getCheckExpressionNode((ExpressionNode)Expression.getRemoteMethodCallActionNode((ExpressionNode)Expression.getFieldAccessExpressionNode("self", "grpcClient"), methodName, "\"" + method.getMethodId() + "\"")));
        function.addVariableStatement(sClient.getVariableDeclarationNode());
        function.addReturnStatement((ExpressionNode)Expression.getExplicitNewExpressionNode(clientName, new String[]{"sClient"}));
        function.addQualifiers(new String[]{"isolated", "remote"});
        return function;
    }

    public static Class getStreamingClientClass(Method method, String filename) {
        String name = method.getMethodName().substring(0, 1).toUpperCase() + method.getMethodName().substring(1) + "StreamingClient";
        Class streamingClient = new Class(name, true);
        streamingClient.addQualifiers(new String[]{"isolated", "client"});
        streamingClient.addMember((Node)TypeDescriptor.getObjectFieldNode("private", new String[]{"final"}, (Node)TypeDescriptor.getQualifiedNameReferenceNode("grpc", "StreamingClient"), "sClient"));
        streamingClient.addMember((Node)ClientUtils.getInitFunction().getFunctionDefinitionNode());
        streamingClient.addMember((Node)ClientUtils.getSendFunction(method, filename).getFunctionDefinitionNode());
        streamingClient.addMember((Node)ClientUtils.getSendContextFunction(method, filename).getFunctionDefinitionNode());
        streamingClient.addMember((Node)ClientUtils.getReceiveFunction(method, filename).getFunctionDefinitionNode());
        streamingClient.addMember((Node)ClientUtils.getReceiveContextFunction(method, filename).getFunctionDefinitionNode());
        streamingClient.addMember((Node)ClientUtils.getSendErrorFunction().getFunctionDefinitionNode());
        streamingClient.addMember((Node)ClientUtils.getCompleteFunction().getFunctionDefinitionNode());
        return streamingClient;
    }

    private static Function getInitFunction() {
        Function function = new Function("init");
        function.addRequiredParameter((Node)TypeDescriptor.getQualifiedNameReferenceNode("grpc", "StreamingClient"), "sClient");
        function.addAssignmentStatement((Node)Expression.getFieldAccessExpressionNode("self", "sClient"), (ExpressionNode)TypeDescriptor.getSimpleNameReferenceNode("sClient"));
        function.addQualifiers(new String[]{"isolated"});
        return function;
    }

    private static Function getSendFunction(Method method, String filename) {
        Function function = new Function("send" + (switch (method.getInputType()) {
            case "byte[]" -> "Bytes";
            case "time:Utc" -> "Timestamp";
            case "time:Seconds" -> "Duration";
            case "map<anydata>" -> "Struct";
            case "'any:Any" -> "Any";
            default -> CommonUtils.capitalize(method.getInputType());
        }));
        function.addRequiredParameter((Node)TypeDescriptor.getSimpleNameReferenceNode(method.getInputPackagePrefix(filename) + method.getInputType()), "message");
        function.addReturns((TypeDescriptorNode)SyntaxTreeConstants.SYNTAX_TREE_GRPC_ERROR_OPTIONAL);
        function.addReturnStatement((ExpressionNode)Expression.getRemoteMethodCallActionNode((ExpressionNode)Expression.getFieldAccessExpressionNode("self", "sClient"), "send", "message"));
        function.addQualifiers(new String[]{"isolated", "remote"});
        return function;
    }

    private static Function getSendContextFunction(Method method, String filename) {
        String inputCap = switch (method.getInputType()) {
            case "byte[]" -> "Bytes";
            case "time:Utc" -> "Timestamp";
            case "time:Seconds" -> "Duration";
            case "map<anydata>" -> "Struct";
            case "'any:Any" -> "Any";
            default -> CommonUtils.capitalize(method.getInputType());
        };
        Function function = new Function("sendContext" + inputCap);
        String contextParam = "Context" + inputCap;
        contextParam = CommonUtils.isBallerinaProtobufType(method.getInputType()) ? CommonUtils.getProtobufType(method.getInputType()) + ":" + contextParam : CommonUtils.getModulePrefix(contextParam, filename) + contextParam;
        function.addRequiredParameter((Node)TypeDescriptor.getSimpleNameReferenceNode(contextParam), "message");
        function.addReturns((TypeDescriptorNode)SyntaxTreeConstants.SYNTAX_TREE_GRPC_ERROR_OPTIONAL);
        function.addReturnStatement((ExpressionNode)Expression.getRemoteMethodCallActionNode((ExpressionNode)Expression.getFieldAccessExpressionNode("self", "sClient"), "send", "message"));
        function.addQualifiers(new String[]{"isolated", "remote"});
        return function;
    }

    private static Function getReceiveFunction(Method method, String filename) {
        Object functionName = "receive";
        if (method.getOutputType() != null) {
            functionName = "receive" + (switch (method.getOutputType()) {
                case "byte[]" -> "Bytes";
                case "time:Utc" -> "Timestamp";
                case "time:Seconds" -> "Duration";
                case "map<anydata>" -> "Struct";
                case "'any:Any" -> "Any";
                default -> CommonUtils.capitalize(method.getOutputType());
            });
        }
        Function function = new Function((String)functionName);
        SeparatedNodeList receiveArgs = NodeFactory.createSeparatedNodeList((Node[])new Node[]{TypeDescriptor.getBuiltinSimpleNameReferenceNode("anydata"), SyntaxTreeConstants.SYNTAX_TREE_COMMA, TypeDescriptor.getMapTypeDescriptorNode((TypeDescriptorNode)TypeDescriptor.getUnionTypeDescriptorNode(SyntaxTreeConstants.SYNTAX_TREE_VAR_STRING, SyntaxTreeConstants.SYNTAX_TREE_VAR_STRING_ARRAY))});
        if (method.getOutputType() != null) {
            function.addReturns((TypeDescriptorNode)TypeDescriptor.getUnionTypeDescriptorNode((TypeDescriptorNode)TypeDescriptor.getSimpleNameReferenceNode(method.getOutputPackageType(filename) + method.getOutputType()), (TypeDescriptorNode)SyntaxTreeConstants.SYNTAX_TREE_GRPC_ERROR_OPTIONAL));
        } else {
            function.addReturns((TypeDescriptorNode)SyntaxTreeConstants.SYNTAX_TREE_GRPC_ERROR_OPTIONAL);
        }
        VariableDeclaration response = new VariableDeclaration(TypeDescriptor.getTypedBindingPatternNode((TypeDescriptorNode)TypeDescriptor.getBuiltinSimpleNameReferenceNode("var"), (BindingPatternNode)TypeDescriptor.getCaptureBindingPatternNode("response")), (ExpressionNode)Expression.getCheckExpressionNode((ExpressionNode)Expression.getRemoteMethodCallActionNode((ExpressionNode)Expression.getFieldAccessExpressionNode("self", "sClient"), "receive", new String[0])));
        function.addVariableStatement(response.getVariableDeclarationNode());
        IfElse responseCheck = new IfElse((ExpressionNode)Expression.getTypeTestExpressionNode((ExpressionNode)TypeDescriptor.getSimpleNameReferenceNode("response"), (Node)TypeDescriptor.getNilTypeDescriptorNode()));
        responseCheck.addIfStatement((StatementNode)Statement.getReturnStatementNode((ExpressionNode)TypeDescriptor.getSimpleNameReferenceNode("response")));
        if (method.getOutputType() == null) {
            responseCheck.addElseStatement((StatementNode)Statement.getAssignmentStatementNode(TypeDescriptor.getWildcardBindingPatternNode().toSourceCode(), (ExpressionNode)TypeDescriptor.getSimpleNameReferenceNode("response")));
        } else {
            responseCheck.addElseStatement((StatementNode)new VariableDeclaration(TypeDescriptor.getTypedBindingPatternNode((TypeDescriptorNode)TypeDescriptor.getTupleTypeDescriptorNode((SeparatedNodeList<Node>)receiveArgs), (BindingPatternNode)TypeDescriptor.getListBindingPatternNode(new String[]{"payload", "_"})), (ExpressionNode)TypeDescriptor.getSimpleNameReferenceNode("response")).getVariableDeclarationNode());
        }
        if (method.getOutputType() != null) {
            if (method.getOutputType().equals("string")) {
                responseCheck.addElseStatement((StatementNode)Statement.getReturnStatementNode((ExpressionNode)Expression.getMethodCallExpressionNode((ExpressionNode)TypeDescriptor.getSimpleNameReferenceNode("payload"), "toString", new String[0])));
            } else if (method.getOutputType().equals("time:Utc")) {
                responseCheck.addElseStatement((StatementNode)Statement.getReturnStatementNode((ExpressionNode)TypeDescriptor.getTypeCastExpressionNode(method.getOutputType(), (ExpressionNode)Expression.getMethodCallExpressionNode((ExpressionNode)TypeDescriptor.getSimpleNameReferenceNode("payload"), "cloneReadOnly", new String[0]))));
            } else {
                responseCheck.addElseStatement((StatementNode)Statement.getReturnStatementNode((ExpressionNode)TypeDescriptor.getTypeCastExpressionNode(method.getOutputPackageType(filename) + method.getOutputType(), (ExpressionNode)TypeDescriptor.getSimpleNameReferenceNode("payload"))));
            }
        }
        function.addIfElseStatement(responseCheck.getIfElseStatementNode());
        function.addQualifiers(new String[]{"isolated", "remote"});
        return function;
    }

    private static Function getReceiveContextFunction(Method method, String filename) {
        String outCap = "Nil";
        if (method.getOutputType() != null) {
            switch (method.getOutputType()) {
                case "byte[]": {
                    outCap = "Bytes";
                    break;
                }
                case "time:Utc": {
                    outCap = "Timestamp";
                    break;
                }
                case "time:Seconds": {
                    outCap = "Duration";
                    break;
                }
                case "map<anydata>": {
                    outCap = "Struct";
                    break;
                }
                case "'any:Any": {
                    outCap = "Any";
                    break;
                }
                default: {
                    outCap = CommonUtils.capitalize(method.getOutputType());
                }
            }
        }
        Function function = new Function("receiveContext" + outCap);
        SeparatedNodeList receiveArgs = NodeFactory.createSeparatedNodeList((Node[])new Node[]{TypeDescriptor.getBuiltinSimpleNameReferenceNode("anydata"), SyntaxTreeConstants.SYNTAX_TREE_COMMA, TypeDescriptor.getMapTypeDescriptorNode((TypeDescriptorNode)TypeDescriptor.getUnionTypeDescriptorNode(SyntaxTreeConstants.SYNTAX_TREE_VAR_STRING, SyntaxTreeConstants.SYNTAX_TREE_VAR_STRING_ARRAY))});
        TypedBindingPatternNode receiveArgsPattern = method.getOutputType() == null ? TypeDescriptor.getTypedBindingPatternNode((TypeDescriptorNode)TypeDescriptor.getTupleTypeDescriptorNode((SeparatedNodeList<Node>)receiveArgs), (BindingPatternNode)TypeDescriptor.getListBindingPatternNode(new String[]{"_", "headers"})) : TypeDescriptor.getTypedBindingPatternNode((TypeDescriptorNode)TypeDescriptor.getTupleTypeDescriptorNode((SeparatedNodeList<Node>)receiveArgs), (BindingPatternNode)TypeDescriptor.getListBindingPatternNode(new String[]{"payload", "headers"}));
        String contextParam = "Context" + outCap;
        contextParam = CommonUtils.isBallerinaProtobufType(method.getOutputType()) ? CommonUtils.getProtobufType(method.getOutputType()) + ":" + contextParam : CommonUtils.getModulePrefix(contextParam, filename) + contextParam;
        function.addReturns((TypeDescriptorNode)TypeDescriptor.getUnionTypeDescriptorNode((TypeDescriptorNode)TypeDescriptor.getSimpleNameReferenceNode(contextParam), (TypeDescriptorNode)SyntaxTreeConstants.SYNTAX_TREE_GRPC_ERROR_OPTIONAL));
        VariableDeclaration response = new VariableDeclaration(TypeDescriptor.getTypedBindingPatternNode((TypeDescriptorNode)TypeDescriptor.getBuiltinSimpleNameReferenceNode("var"), (BindingPatternNode)TypeDescriptor.getCaptureBindingPatternNode("response")), (ExpressionNode)Expression.getCheckExpressionNode((ExpressionNode)Expression.getRemoteMethodCallActionNode((ExpressionNode)Expression.getFieldAccessExpressionNode("self", "sClient"), "receive", new String[0])));
        function.addVariableStatement(response.getVariableDeclarationNode());
        IfElse responseCheck = new IfElse((ExpressionNode)Expression.getTypeTestExpressionNode((ExpressionNode)TypeDescriptor.getSimpleNameReferenceNode("response"), (Node)TypeDescriptor.getNilTypeDescriptorNode()));
        responseCheck.addIfStatement((StatementNode)Statement.getReturnStatementNode((ExpressionNode)TypeDescriptor.getSimpleNameReferenceNode("response")));
        responseCheck.addElseStatement((StatementNode)new VariableDeclaration(receiveArgsPattern, (ExpressionNode)TypeDescriptor.getSimpleNameReferenceNode("response")).getVariableDeclarationNode());
        Map returnMap = new Map();
        if (method.getOutputType() != null) {
            if (method.getOutputType().equals("string")) {
                returnMap.addMethodCallField("content", (ExpressionNode)TypeDescriptor.getSimpleNameReferenceNode("payload"), "toString", new String[0]);
            } else if (method.getOutputType().equals("time:Utc")) {
                returnMap.addTypeCastExpressionField("content", method.getOutputType(), (ExpressionNode)Expression.getMethodCallExpressionNode((ExpressionNode)TypeDescriptor.getSimpleNameReferenceNode("payload"), "cloneReadOnly", new String[0]));
            } else {
                returnMap.addTypeCastExpressionField("content", method.getOutputPackageType(filename) + method.getOutputType(), (ExpressionNode)TypeDescriptor.getSimpleNameReferenceNode("payload"));
            }
        }
        returnMap.addSimpleNameReferenceField("headers", "headers");
        responseCheck.addElseStatement((StatementNode)Statement.getReturnStatementNode((ExpressionNode)returnMap.getMappingConstructorExpressionNode()));
        function.addIfElseStatement(responseCheck.getIfElseStatementNode());
        function.addQualifiers(new String[]{"isolated", "remote"});
        return function;
    }

    private static Function getSendErrorFunction() {
        Function function = new Function("sendError");
        function.addRequiredParameter((Node)SyntaxTreeConstants.SYNTAX_TREE_GRPC_ERROR, "response");
        function.addReturns((TypeDescriptorNode)SyntaxTreeConstants.SYNTAX_TREE_GRPC_ERROR_OPTIONAL);
        function.addReturnStatement((ExpressionNode)Expression.getRemoteMethodCallActionNode((ExpressionNode)Expression.getFieldAccessExpressionNode("self", "sClient"), "sendError", "response"));
        function.addQualifiers(new String[]{"isolated", "remote"});
        return function;
    }

    private static Function getCompleteFunction() {
        Function function = new Function("complete");
        function.addReturns((TypeDescriptorNode)SyntaxTreeConstants.SYNTAX_TREE_GRPC_ERROR_OPTIONAL);
        function.addReturnStatement((ExpressionNode)Expression.getRemoteMethodCallActionNode((ExpressionNode)Expression.getFieldAccessExpressionNode("self", "sClient"), "complete", new String[0]));
        function.addQualifiers(new String[]{"isolated", "remote"});
        return function;
    }
}

