/*
 * Decompiled with CFR 0.152.
 */
package org.wssec;

import io.ballerina.runtime.api.creators.ValueCreator;
import io.ballerina.runtime.api.values.BArray;
import io.ballerina.runtime.api.values.BObject;
import io.ballerina.runtime.api.values.BXml;
import java.io.StringReader;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.wssec.Utils;
import org.wssec.WsSecurityUtils;
import org.xml.sax.InputSource;

public final class DocumentBuilder {
    private final Document document;

    public DocumentBuilder(BObject documentBuilder, BXml xmlPayload) throws Exception {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setNamespaceAware(true);
        this.document = factory.newDocumentBuilder().parse(new InputSource(new StringReader(xmlPayload.toString())));
        documentBuilder.addNativeData("nativeDocumentBuilder", (Object)this.document);
    }

    protected DocumentBuilder(Document document) {
        this.document = document;
    }

    public static Object getEnvelope(BObject document) {
        Document nativeDocument = (Document)document.getNativeData().get("nativeDocumentBuilder");
        try {
            return ValueCreator.createXmlValue((String)WsSecurityUtils.convertDocumentToString(nativeDocument).toString());
        }
        catch (Exception e) {
            return Utils.createError(e.getMessage());
        }
    }

    public static BArray getSignatureData(BObject document) {
        Document nativeDocument = (Document)document.getNativeData().get("nativeDocumentBuilder");
        return ValueCreator.createArrayValue((byte[])WsSecurityUtils.getSignatureValue(nativeDocument));
    }

    public static BArray getEncryptedData(BObject document) {
        Document nativeDocument = (Document)document.getNativeData().get("nativeDocumentBuilder");
        return ValueCreator.createArrayValue((byte[])WsSecurityUtils.getEncryptedData(nativeDocument));
    }

    protected Document getNativeDocument() {
        return this.document;
    }
}

