/*
 * Decompiled with CFR 0.152.
 */
package org.wssec;

import io.ballerina.runtime.api.creators.ErrorCreator;
import io.ballerina.runtime.api.utils.StringUtils;
import io.ballerina.runtime.api.values.BString;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Base64;
import java.util.List;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.wss4j.common.WSEncryptionPart;
import org.apache.wss4j.dom.handler.RequestData;
import org.apache.wss4j.dom.message.WSSecSignature;
import org.apache.wss4j.dom.message.WSSecUsernameToken;
import org.apache.wss4j.dom.util.WSSecurityUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public final class WsSecurityUtils {
    private WsSecurityUtils() {
    }

    public static void buildSignature(RequestData reqData, WSSecSignature sign) throws Exception {
        ArrayList<WSEncryptionPart> parts = new ArrayList<WSEncryptionPart>(1);
        Document doc = reqData.getSecHeader().getSecurityHeaderElement().getOwnerDocument();
        parts.add(WSSecurityUtil.getDefaultEncryptionPart((Document)doc));
        List referenceList = sign.addReferencesToSign(parts);
        sign.computeSignature(referenceList);
        reqData.getSignatureValues().add(sign.getSignatureValue());
    }

    public static void setSignatureValue(Document doc, byte[] signature, String algorithm) {
        doc.getElementsByTagName("ds:SignatureMethod").item(0).getAttributes().item(0).setNodeValue(algorithm);
        NodeList digestValueList = doc.getElementsByTagName("ds:SignatureValue");
        digestValueList.item(0).getFirstChild().setNodeValue(Base64.getEncoder().encodeToString(signature));
    }

    public static byte[] getSignatureValue(Document doc) {
        String signature = doc.getElementsByTagName("ds:SignatureValue").item(0).getFirstChild().getNodeValue();
        return Base64.getDecoder().decode(signature);
    }

    public static void setEncryptedData(Document doc, byte[] encryptedData, String algorithm) {
        Element cipherDataElement = (Element)doc.getElementsByTagNameNS("http://www.w3.org/2001/04/xmlenc#", "CipherValue").item(0);
        cipherDataElement.getFirstChild().setNodeValue(Base64.getEncoder().encodeToString(encryptedData));
        doc.getElementsByTagName("xenc:EncryptionMethod").item(0).getAttributes().item(0).setNodeValue(algorithm);
    }

    public static byte[] getEncryptedData(Document document) {
        String encryptedText = document.getElementsByTagNameNS("http://www.w3.org/2001/04/xmlenc#", "CipherValue").item(0).getFirstChild().getNodeValue();
        return Base64.getDecoder().decode(encryptedText);
    }

    public static Object getEncryptedKeyElement(byte[] encryptKey) throws Exception {
        Document document = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
        Element encryptedKey = document.createElement("xenc:EncryptedKey");
        encryptedKey.setAttribute("xmlns:xenc", "http://www.w3.org/2001/04/xmlenc#");
        Element encryptionMethod = document.createElement("xenc:EncryptionMethod");
        encryptionMethod.setAttribute("Algorithm", "http://www.w3.org/2001/04/xmlenc#rsa-1_5");
        encryptedKey.appendChild(encryptionMethod);
        Element keyInfo = document.createElement("ds:KeyInfo");
        keyInfo.setAttribute("xmlns:ds", "http://www.w3.org/2000/09/xmldsig#");
        encryptedKey.appendChild(keyInfo);
        Element cipherData = document.createElement("xenc:CipherData");
        cipherData.appendChild(document.createTextNode(Base64.getEncoder().encodeToString(encryptKey)));
        encryptedKey.appendChild(cipherData);
        document.appendChild(encryptedKey);
        return WsSecurityUtils.convertDocumentToString(document);
    }

    public static void setUTChildElements(WSSecUsernameToken usernameToken, String passwordType, String username, String password) {
        if ("DIGEST".equals(passwordType) || "DERIVED_KEY_DIGEST".equals(passwordType)) {
            usernameToken.setPasswordType("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-username-token-profile-1.0#PasswordDigest");
            usernameToken.setUserInfo(username, password);
            usernameToken.addCreated();
            usernameToken.addNonce();
        } else {
            usernameToken.setPasswordType("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-username-token-profile-1.0#PasswordText");
            usernameToken.setUserInfo(username, password);
        }
    }

    public static Object convertDocumentToString(Document document) throws Exception {
        if (document == null) {
            return ErrorCreator.createError((BString)StringUtils.fromString((String)"XML Document is empty"));
        }
        Transformer transformer = TransformerFactory.newInstance().newTransformer();
        StringWriter writer = new StringWriter();
        transformer.transform(new DOMSource(document), new StreamResult(writer));
        return StringUtils.fromString((String)writer.toString());
    }
}

