/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.stdlib.auth.ldap;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.net.ssl.SSLContext;

public class SslContextTrustManager {
    private static SslContextTrustManager sslContextTrustManager;
    private Map<String, SSLContext> sslContextMap = new ConcurrentHashMap<String, SSLContext>();

    private SslContextTrustManager() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SslContextTrustManager getInstance() {
        if (sslContextTrustManager != null) {
            return sslContextTrustManager;
        }
        Class<SslContextTrustManager> clazz = SslContextTrustManager.class;
        synchronized (SslContextTrustManager.class) {
            if (sslContextTrustManager == null) {
                sslContextTrustManager = new SslContextTrustManager();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return sslContextTrustManager;
        }
    }

    public SSLContext getSSLContext(String contextId) {
        return SslContextTrustManager.getInstance().getSslContextMap().get(contextId);
    }

    public void addSSLContext(String key, SSLContext sslContext) {
        SslContextTrustManager.getInstance().getSslContextMap().put(key, sslContext);
    }

    public Map<String, SSLContext> getSslContextMap() {
        return this.sslContextMap;
    }
}

