/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.stdlib.auth.ldap.nativeimpl;

import io.ballerina.runtime.api.values.BError;
import io.ballerina.runtime.api.values.BMap;
import io.ballerina.runtime.api.values.BString;
import io.ballerina.stdlib.auth.ldap.CommonLdapConfiguration;
import io.ballerina.stdlib.auth.ldap.ConnectionContext;
import io.ballerina.stdlib.auth.ldap.utils.LdapUtils;
import java.nio.charset.StandardCharsets;
import javax.naming.NamingException;
import javax.naming.directory.DirContext;
import javax.naming.ldap.LdapContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Authenticate {
    private static final Logger LOG = LoggerFactory.getLogger(Authenticate.class);

    private Authenticate() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object authenticate(BMap<BString, Object> ldapConnection, BString userName, BString password) {
        if (userName == null || userName.getValue().isEmpty()) {
            return LdapUtils.createError("Username cannot be null or empty.");
        }
        byte[] credential = password.getValue().getBytes(StandardCharsets.UTF_8);
        ConnectionContext connectionSource = (ConnectionContext)ldapConnection.getNativeData("connectionSource");
        DirContext ldapConnectionContext = (DirContext)ldapConnection.getNativeData("connectionContext");
        CommonLdapConfiguration ldapConfiguration = (CommonLdapConfiguration)ldapConnection.getNativeData("ldapConfiguration");
        LdapUtils.setServiceName((String)ldapConnection.getNativeData("instanceId"));
        try {
            LOG.debug("Authenticating user '{}'", (Object)userName);
            String name = LdapUtils.getNameInSpaceForUsernameFromLDAP(userName.getValue().trim(), ldapConfiguration, ldapConnectionContext);
            if (name == null || name.isEmpty()) {
                BError bError = LdapUtils.createError("Username cannot be found in the directory.");
                return bError;
            }
            LdapContext cxt = connectionSource.getContextWithCredentials(name, credential);
            LOG.debug("User '{}' is authenticated", (Object)name);
            LdapUtils.closeContext(cxt);
        }
        catch (NamingException e) {
            LOG.error("Failed to bind user '{}'", (Object)userName, (Object)e);
            BError bError = LdapUtils.createError(e.getMessage());
            return bError;
        }
        finally {
            LdapUtils.removeServiceName();
        }
        return null;
    }
}

