/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.openapi.service.mapper;

import io.ballerina.compiler.syntax.tree.CheckExpressionNode;
import io.ballerina.compiler.syntax.tree.ExplicitNewExpressionNode;
import io.ballerina.compiler.syntax.tree.ExpressionNode;
import io.ballerina.compiler.syntax.tree.FunctionArgumentNode;
import io.ballerina.compiler.syntax.tree.ImplicitNewExpressionNode;
import io.ballerina.compiler.syntax.tree.ListenerDeclarationNode;
import io.ballerina.compiler.syntax.tree.MappingConstructorExpressionNode;
import io.ballerina.compiler.syntax.tree.MappingFieldNode;
import io.ballerina.compiler.syntax.tree.NamedArgumentNode;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.ParenthesizedArgList;
import io.ballerina.compiler.syntax.tree.QualifiedNameReferenceNode;
import io.ballerina.compiler.syntax.tree.SeparatedNodeList;
import io.ballerina.compiler.syntax.tree.SpecificFieldNode;
import io.ballerina.compiler.syntax.tree.SyntaxKind;
import io.ballerina.openapi.service.mapper.ServersMapper;
import io.ballerina.openapi.service.mapper.model.ServiceNode;
import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.servers.Server;
import io.swagger.v3.oas.models.servers.ServerVariable;
import io.swagger.v3.oas.models.servers.ServerVariables;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;

public class ServersMapperImpl
implements ServersMapper {
    final OpenAPI openAPI;
    final Set<ListenerDeclarationNode> endpoints;
    final ServiceNode service;

    public ServersMapperImpl(OpenAPI openAPI, Set<ListenerDeclarationNode> endpoints, ServiceNode service) {
        this.openAPI = openAPI;
        this.endpoints = endpoints;
        this.service = service;
    }

    @Override
    public void setServers() {
        if (this.service.kind().equals((Object)ServiceNode.Kind.SERVICE_OBJECT_TYPE)) {
            Server defaultServer = ServersMapperImpl.getDefaultServerWithBasePath(this.service.absoluteResourcePath());
            this.openAPI.setServers(Collections.singletonList(defaultServer));
            return;
        }
        this.extractServerForExpressionNode();
        List servers = this.openAPI.getServers();
        if (!this.endpoints.isEmpty()) {
            for (ListenerDeclarationNode ep : this.endpoints) {
                SeparatedNodeList<ExpressionNode> exprNodes = this.service.expressions();
                for (ExpressionNode node : exprNodes) {
                    this.updateServerDetails(servers, ep, node);
                }
            }
        }
        if (this.hasEmptyServer()) {
            Server defaultServer = ServersMapperImpl.getDefaultServerWithBasePath(this.service.absoluteResourcePath());
            this.openAPI.setServers(Collections.singletonList(defaultServer));
        }
        if (servers.size() > 1) {
            Server mainServer = ServersMapperImpl.addEnumValues(servers);
            this.openAPI.setServers(Collections.singletonList(mainServer));
        }
    }

    private boolean hasEmptyServer() {
        return this.openAPI.getServers().isEmpty() || this.openAPI.getServers().stream().allMatch(server -> Objects.isNull(server.getUrl()) && (Objects.isNull(server.getVariables()) || server.getVariables().isEmpty()));
    }

    private void updateServerDetails(List<Server> servers, ListenerDeclarationNode endPoint, ExpressionNode expNode) {
        if (expNode instanceof QualifiedNameReferenceNode) {
            QualifiedNameReferenceNode refNode = (QualifiedNameReferenceNode)expNode;
            if (refNode.identifier().text().trim().equals(endPoint.variableName().text().trim())) {
                String serviceBasePath = this.service.absoluteResourcePath();
                Server server = ServersMapperImpl.extractServer(endPoint, serviceBasePath);
                servers.add(server);
            }
        } else if (expNode.toString().trim().equals(endPoint.variableName().text().trim())) {
            String serviceBasePath = this.service.absoluteResourcePath();
            Server server = ServersMapperImpl.extractServer(endPoint, serviceBasePath);
            servers.add(server);
        }
    }

    private static Server addEnumValues(List<Server> servers) {
        Server mainServer = servers.get(0);
        ArrayList<Server> rotated = new ArrayList<Server>(servers);
        ServerVariables mainVariable = mainServer.getVariables();
        ServerVariable hostVariable = (ServerVariable)mainVariable.get((Object)"server");
        ServerVariable portVariable = (ServerVariable)mainVariable.get((Object)"port");
        if (servers.size() > 1) {
            Collections.rotate(rotated, servers.size() - 1);
            for (Server server : rotated) {
                ServerVariables variables = server.getVariables();
                if (variables.get((Object)"server") != null) {
                    hostVariable.addEnumItem(((ServerVariable)variables.get((Object)"server")).getDefault());
                }
                if (variables.get((Object)"port") == null) continue;
                portVariable.addEnumItem(((ServerVariable)variables.get((Object)"port")).getDefault());
            }
        }
        return mainServer;
    }

    private static Server extractServer(ListenerDeclarationNode ep, String serviceBasePath) {
        Optional<ParenthesizedArgList> list;
        if (ep.initializer().kind() == SyntaxKind.CHECK_EXPRESSION) {
            ExpressionNode expression = ((CheckExpressionNode)ep.initializer()).expression();
            list = ServersMapperImpl.extractListenerNodeType((Node)expression);
        } else {
            list = ServersMapperImpl.extractListenerNodeType(ep.initializer());
        }
        return ServersMapperImpl.generateServer(serviceBasePath, list);
    }

    private static Optional<ParenthesizedArgList> extractListenerNodeType(Node expression2) {
        Optional list = Optional.empty();
        if (expression2.kind() == SyntaxKind.EXPLICIT_NEW_EXPRESSION) {
            ExplicitNewExpressionNode bTypeExplicit = (ExplicitNewExpressionNode)expression2;
            list = Optional.ofNullable(bTypeExplicit.parenthesizedArgList());
        } else if (expression2.kind() == SyntaxKind.IMPLICIT_NEW_EXPRESSION) {
            ImplicitNewExpressionNode bTypeInit = (ImplicitNewExpressionNode)expression2;
            list = bTypeInit.parenthesizedArgList();
        }
        return list;
    }

    private void extractServerForExpressionNode() {
        SeparatedNodeList<ExpressionNode> bTypeExplicit = this.service.expressions();
        String serviceBasePath = this.service.absoluteResourcePath();
        ArrayList<Server> servers = new ArrayList<Server>();
        for (ExpressionNode expressionNode : bTypeExplicit) {
            if (!expressionNode.kind().equals((Object)SyntaxKind.EXPLICIT_NEW_EXPRESSION)) continue;
            ExplicitNewExpressionNode explicit = (ExplicitNewExpressionNode)expressionNode;
            Optional<ParenthesizedArgList> list = Optional.ofNullable(explicit.parenthesizedArgList());
            Server server = ServersMapperImpl.generateServer(serviceBasePath, list);
            servers.add(server);
        }
        this.openAPI.setServers(servers);
    }

    private static Server generateServer(String serviceBasePath, Optional<ParenthesizedArgList> list) {
        String port = null;
        String host = null;
        ServerVariables serverVariables = new ServerVariables();
        Server server = new Server();
        if (list.isPresent()) {
            ExpressionNode bLangRecordLiteral;
            SeparatedNodeList arg = list.get().arguments();
            port = ServersMapperImpl.getValidPort(((FunctionArgumentNode)arg.get(0)).toString());
            if (arg.size() > 1 && arg.get(1) instanceof NamedArgumentNode && (bLangRecordLiteral = ((NamedArgumentNode)arg.get(1)).expression()) instanceof MappingConstructorExpressionNode) {
                host = ServersMapperImpl.extractHost((MappingConstructorExpressionNode)bLangRecordLiteral);
            }
        }
        ServersMapperImpl.setServerVariableValues(serviceBasePath, port, host, serverVariables, server);
        return server;
    }

    private static String getValidPort(String port) {
        return port.matches("\\d+") ? port : null;
    }

    private static void setServerVariableValues(String serviceBasePath, String port, String host, ServerVariables serverVariables, Server server) {
        Object serverUrl;
        port = Objects.isNull(port) ? "9090" : port;
        ServerVariable serverUrlVariable = new ServerVariable();
        if (host != null) {
            serverUrlVariable._default(host);
            ServerVariable portVariable = new ServerVariable();
            portVariable._default(port);
            serverVariables.addServerVariable("server", serverUrlVariable);
            serverVariables.addServerVariable("port", portVariable);
            serverUrl = String.format("{server}:{port}%s", serviceBasePath);
        } else {
            if (port.equals("443")) {
                serverUrlVariable._default("https://localhost");
                ServerVariable portVariable = new ServerVariable();
                portVariable._default("443");
                serverVariables.addServerVariable("server", serverUrlVariable);
                serverVariables.addServerVariable("port", portVariable);
            } else {
                serverUrlVariable._default("http://localhost");
                ServerVariable portVariable = new ServerVariable();
                portVariable._default(port);
                serverVariables.addServerVariable("server", serverUrlVariable);
                serverVariables.addServerVariable("port", portVariable);
            }
            serverUrl = "{server}:{port}" + serviceBasePath;
        }
        server.setUrl((String)serverUrl);
        server.setVariables(serverVariables);
    }

    private static String extractHost(MappingConstructorExpressionNode bLangRecordLiteral) {
        String host = "";
        if (bLangRecordLiteral.fields() != null && !bLangRecordLiteral.fields().isEmpty()) {
            SeparatedNodeList recordFields = bLangRecordLiteral.fields();
            host = ServersMapperImpl.concatenateServerURL(host, (SeparatedNodeList<MappingFieldNode>)recordFields);
        }
        if (!host.isEmpty()) {
            host = host.replaceAll("\"", "");
        }
        return host;
    }

    private static String concatenateServerURL(String host, SeparatedNodeList<MappingFieldNode> recordFields) {
        for (MappingFieldNode filed : recordFields) {
            Node fieldName;
            if (!(filed instanceof SpecificFieldNode) || !(fieldName = ((SpecificFieldNode)filed).fieldName()).toString().equals("host") || !((SpecificFieldNode)filed).valueExpr().isPresent()) continue;
            host = ((ExpressionNode)((SpecificFieldNode)filed).valueExpr().get()).toString();
        }
        return host;
    }

    private static Server getDefaultServerWithBasePath(String serviceBasePath) {
        String serverUrl = String.format("http://{server}:{port}%s", serviceBasePath);
        ServerVariables serverVariables = new ServerVariables();
        ServerVariable serverUrlVariable = new ServerVariable();
        serverUrlVariable._default("localhost");
        serverVariables.addServerVariable("server", serverUrlVariable);
        ServerVariable portVariable = new ServerVariable();
        portVariable._default("9090");
        serverVariables.addServerVariable("port", portVariable);
        Server server = new Server();
        server.setUrl(serverUrl);
        server.setVariables(serverVariables);
        return server;
    }
}

