/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.openapi.service.mapper.interceptor.model;

import io.ballerina.compiler.api.SemanticModel;
import io.ballerina.compiler.api.symbols.TypeSymbol;
import java.util.LinkedHashSet;
import java.util.Objects;
import java.util.Set;

public class ResponseInfo {
    private final Set<TypeSymbol> returnTypesFromInterceptors = new LinkedHashSet<TypeSymbol>();
    private final Set<TypeSymbol> returnTypesFromTargetResource = new LinkedHashSet<TypeSymbol>();
    private boolean hasUnhandledDataBindingErrors;

    public ResponseInfo(boolean hasDataBinding) {
        this.hasUnhandledDataBindingErrors = hasDataBinding;
    }

    public void markDataBindingError() {
        this.hasUnhandledDataBindingErrors = true;
    }

    public void markDataBindingErrorHandled() {
        this.hasUnhandledDataBindingErrors = false;
    }

    public boolean hasUnhandledDataBindingErrors() {
        return this.hasUnhandledDataBindingErrors;
    }

    public void addReturnTypeFromInterceptors(TypeSymbol typeSymbol) {
        this.returnTypesFromInterceptors.add(typeSymbol);
    }

    public void addReturnTypeFromTargetResource(TypeSymbol typeSymbol) {
        this.returnTypesFromTargetResource.add(typeSymbol);
    }

    public boolean hasReturnTypesFromInterceptors() {
        return !this.returnTypesFromInterceptors.isEmpty();
    }

    public TypeSymbol getReturnTypesFromInterceptors(SemanticModel semanticModel) {
        return ResponseInfo.buildTypeSymbolFromList(this.returnTypesFromInterceptors, semanticModel);
    }

    public TypeSymbol getReturnTypesFromTargetResource(SemanticModel semanticModel) {
        return ResponseInfo.buildTypeSymbolFromList(this.returnTypesFromTargetResource, semanticModel);
    }

    private static TypeSymbol buildTypeSymbolFromList(Set<TypeSymbol> typeSymbols, SemanticModel semanticModel) {
        if (Objects.isNull(typeSymbols) || typeSymbols.isEmpty()) {
            return null;
        }
        if (typeSymbols.size() == 1) {
            return typeSymbols.iterator().next();
        }
        return semanticModel.types().builder().UNION_TYPE.withMemberTypes((TypeSymbol[])typeSymbols.toArray(TypeSymbol[]::new)).build();
    }
}

