/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.openapi.service.mapper.interceptor.resource;

import io.ballerina.compiler.api.SemanticModel;
import io.ballerina.openapi.service.mapper.interceptor.resource.PathParameterSegmentNode;
import io.ballerina.openapi.service.mapper.interceptor.resource.PathSegmentNode;
import io.ballerina.openapi.service.mapper.utils.MapperCommonUtils;
import java.util.Objects;

public class NamedPathSegmentNode
extends PathSegmentNode {
    String name;

    public NamedPathSegmentNode(String name) {
        this.name = Objects.nonNull(name) ? MapperCommonUtils.unescapeIdentifier(name) : "";
    }

    @Override
    public PathSegmentNode.Type getType() {
        return PathSegmentNode.Type.NAMED_SEGMENT;
    }

    @Override
    public boolean matches(PathSegmentNode refPathSegmentNode, SemanticModel semanticModel) {
        return switch (refPathSegmentNode.getType()) {
            default -> throw new MatchException(null, null);
            case PathSegmentNode.Type.DOT_SEGMENT -> false;
            case PathSegmentNode.Type.NAMED_SEGMENT -> ((NamedPathSegmentNode)refPathSegmentNode).getName().equals(this.name);
            case PathSegmentNode.Type.PARAMETER_SEGMENT -> this.name.matches(NamedPathSegmentNode.getRegex(((PathParameterSegmentNode)refPathSegmentNode).getParameterType(), semanticModel));
        };
    }

    public String getName() {
        return this.name;
    }
}

