/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.openapi.service.mapper.interceptor.resource;

import io.ballerina.compiler.api.SemanticModel;
import io.ballerina.compiler.api.symbols.PathParameterSymbol;
import io.ballerina.compiler.api.symbols.TypeSymbol;
import io.ballerina.compiler.api.symbols.resourcepath.PathRestParam;
import io.ballerina.compiler.api.symbols.resourcepath.PathSegmentList;
import io.ballerina.compiler.api.symbols.resourcepath.ResourcePath;
import io.ballerina.compiler.api.symbols.resourcepath.util.PathSegment;
import io.ballerina.openapi.service.mapper.interceptor.resource.DotPathSegmentNode;
import io.ballerina.openapi.service.mapper.interceptor.resource.NamedPathSegmentNode;
import io.ballerina.openapi.service.mapper.interceptor.resource.PathParameterSegmentNode;
import io.ballerina.openapi.service.mapper.interceptor.resource.PathRestParameterSegmentNode;
import io.ballerina.openapi.service.mapper.interceptor.resource.PathSegmentNode;
import java.util.List;

public class PathSegments {
    private PathSegmentNode firstSegment;
    private PathSegmentNode lastSegment;

    private PathSegments(PathSegmentNode firstSegment) {
        this.firstSegment = firstSegment;
        this.lastSegment = firstSegment;
    }

    private PathSegments(PathSegmentNode firstSegment, PathSegmentNode lastSegment) {
        this.firstSegment = firstSegment;
        this.lastSegment = lastSegment;
    }

    public static PathSegments build(ResourcePath resourcePath) {
        switch (resourcePath.kind()) {
            case DOT_RESOURCE_PATH: {
                return new PathSegments(new DotPathSegmentNode());
            }
            case PATH_REST_PARAM: {
                TypeSymbol restPathParamType = ((PathRestParam)resourcePath).parameter().typeDescriptor();
                return new PathSegments(new PathRestParameterSegmentNode(restPathParamType));
            }
        }
        List pathSegments = ((PathSegmentList)resourcePath).list();
        return PathSegments.build(pathSegments);
    }

    private static PathSegments build(List<PathSegment> pathSegments) {
        PathSegmentNode firstSegment;
        if (pathSegments.isEmpty()) {
            return new PathSegments(null);
        }
        PathSegmentNode currentSegment = firstSegment = PathSegments.buildPathSegmentNode(pathSegments.get(0));
        for (int i = 1; i < pathSegments.size(); ++i) {
            PathSegmentNode nextSegment = PathSegments.buildPathSegmentNode(pathSegments.get(i));
            currentSegment.setNext(nextSegment);
            currentSegment = nextSegment;
        }
        return new PathSegments(firstSegment, currentSegment);
    }

    private static PathSegmentNode buildPathSegmentNode(PathSegment pathSegment) {
        switch (pathSegment.pathSegmentKind()) {
            case NAMED_SEGMENT: {
                return new NamedPathSegmentNode(pathSegment.signature());
            }
            case PATH_REST_PARAMETER: {
                TypeSymbol restPathParamType = ((PathParameterSymbol)pathSegment).typeDescriptor();
                return new PathRestParameterSegmentNode(restPathParamType);
            }
        }
        TypeSymbol parameterType = ((PathParameterSymbol)pathSegment).typeDescriptor();
        return new PathParameterSegmentNode(parameterType);
    }

    public boolean matches(PathSegments refPathSegments, SemanticModel semanticModel) {
        PathSegmentNode refPathSegNode;
        PathSegmentNode targetPathSegNode = this.firstSegment;
        for (refPathSegNode = refPathSegments.firstSegment; refPathSegNode != null && targetPathSegNode != null; refPathSegNode = refPathSegNode.next(), targetPathSegNode = targetPathSegNode.next()) {
            if (!targetPathSegNode.matches(refPathSegNode, semanticModel)) {
                return false;
            }
            if (!(refPathSegNode instanceof PathRestParameterSegmentNode) || !(targetPathSegNode instanceof PathRestParameterSegmentNode)) continue;
            return true;
        }
        return refPathSegNode == null && targetPathSegNode == null || targetPathSegNode == null && refPathSegments.lastSegment instanceof PathRestParameterSegmentNode;
    }
}

