/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.openapi.service.mapper.interceptor.types;

import io.ballerina.compiler.api.SemanticModel;
import io.ballerina.compiler.api.symbols.ParameterSymbol;
import io.ballerina.compiler.api.symbols.ResourceMethodSymbol;
import io.ballerina.compiler.api.symbols.TypeReferenceTypeSymbol;
import io.ballerina.compiler.api.symbols.TypeSymbol;
import io.ballerina.compiler.api.symbols.UnionTypeSymbol;
import io.ballerina.openapi.service.mapper.response.utils.StatusCodeResponseUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public abstract class Resource {
    private final List<TypeSymbol> errorReturnType = new ArrayList<TypeSymbol>();
    private final List<TypeSymbol> nonErrorReturnType = new ArrayList<TypeSymbol>();
    protected final SemanticModel semanticModel;
    protected ResourceMethodSymbol resourceMethod = null;

    protected Resource(SemanticModel semanticModel) {
        this.semanticModel = semanticModel;
    }

    protected void extractErrorAndNonErrorReturnTypes(TypeSymbol effectiveReturnType) {
        ArrayList<TypeSymbol> baseTypes = new ArrayList<TypeSymbol>();
        this.destructUnionType(effectiveReturnType, baseTypes);
        baseTypes.forEach(this::addBaseReturnType);
    }

    private void addBaseReturnType(TypeSymbol typeSymbol) {
        if (typeSymbol.subtypeOf(this.semanticModel.types().ERROR)) {
            this.errorReturnType.add(typeSymbol);
        } else {
            this.nonErrorReturnType.add(typeSymbol);
        }
    }

    private void destructUnionType(TypeSymbol typeSymbol, List<TypeSymbol> memberTypes) {
        if (typeSymbol.subtypeOf(this.semanticModel.types().ERROR) || typeSymbol.subtypeOf(this.semanticModel.types().ANYDATA) || StatusCodeResponseUtils.isSubTypeOfHttpStatusCodeResponse(typeSymbol, this.semanticModel)) {
            memberTypes.add(typeSymbol);
        } else if (typeSymbol instanceof UnionTypeSymbol) {
            ((UnionTypeSymbol)typeSymbol).userSpecifiedMemberTypes().forEach(memberType -> this.destructUnionType((TypeSymbol)memberType, memberTypes));
        } else if (typeSymbol instanceof TypeReferenceTypeSymbol) {
            this.destructUnionType(((TypeReferenceTypeSymbol)typeSymbol).typeDescriptor(), memberTypes);
        } else {
            memberTypes.add(typeSymbol);
        }
    }

    public TypeSymbol getErrorReturnType() {
        return this.getTypeSymbol(this.errorReturnType);
    }

    public TypeSymbol getNonErrorReturnType() {
        return this.getTypeSymbol(this.nonErrorReturnType);
    }

    private TypeSymbol getTypeSymbol(List<TypeSymbol> listOfTypeSymbols) {
        if (listOfTypeSymbols.isEmpty()) {
            return null;
        }
        if (listOfTypeSymbols.size() == 1) {
            return listOfTypeSymbols.get(0);
        }
        return this.semanticModel.types().builder().UNION_TYPE.withMemberTypes((TypeSymbol[])listOfTypeSymbols.toArray(TypeSymbol[]::new)).build();
    }

    public boolean hasErrorReturn() {
        return !this.errorReturnType.isEmpty();
    }

    public boolean hasDataBinding() {
        return Objects.nonNull(this.resourceMethod) && this.hasAnydataParameters(this.resourceMethod.typeDescriptor().params().orElse(List.of()));
    }

    private boolean hasAnydataParameters(List<ParameterSymbol> params) {
        return params.stream().anyMatch(param -> param.typeDescriptor().subtypeOf(this.semanticModel.types().ANYDATA));
    }
}

