/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.openapi.service.mapper.model;

import io.ballerina.compiler.api.SemanticModel;
import io.ballerina.compiler.api.symbols.MethodSymbol;
import io.ballerina.compiler.api.symbols.ObjectTypeSymbol;
import io.ballerina.compiler.api.symbols.Symbol;
import io.ballerina.compiler.api.symbols.TypeDefinitionSymbol;
import io.ballerina.compiler.api.symbols.TypeSymbol;
import io.ballerina.compiler.syntax.tree.AbstractNodeFactory;
import io.ballerina.compiler.syntax.tree.AnnotationNode;
import io.ballerina.compiler.syntax.tree.BasicLiteralNode;
import io.ballerina.compiler.syntax.tree.ExpressionNode;
import io.ballerina.compiler.syntax.tree.MappingConstructorExpressionNode;
import io.ballerina.compiler.syntax.tree.MappingFieldNode;
import io.ballerina.compiler.syntax.tree.MetadataNode;
import io.ballerina.compiler.syntax.tree.ModuleMemberDeclarationNode;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NodeFactory;
import io.ballerina.compiler.syntax.tree.NodeList;
import io.ballerina.compiler.syntax.tree.ObjectTypeDescriptorNode;
import io.ballerina.compiler.syntax.tree.SeparatedNodeList;
import io.ballerina.compiler.syntax.tree.SpecificFieldNode;
import io.ballerina.compiler.syntax.tree.SyntaxKind;
import io.ballerina.compiler.syntax.tree.TypeDefinitionNode;
import io.ballerina.openapi.service.mapper.model.ServiceNode;
import io.ballerina.tools.diagnostics.Location;
import java.util.Optional;

public class ServiceContractType
implements ServiceNode {
    private static final String DEFAULT_PATH = "/";
    ObjectTypeDescriptorNode serviceObjType;
    TypeDefinitionNode serviceTypeDefinition;
    int serviceId;

    public ServiceContractType(TypeDefinitionNode serviceType) {
        this.serviceId = serviceType.hashCode();
        this.serviceTypeDefinition = new TypeDefinitionNode(serviceType.internalNode(), serviceType.position(), serviceType.parent());
        ObjectTypeDescriptorNode serviceObjTypeDesc = (ObjectTypeDescriptorNode)serviceType.typeDescriptor();
        this.serviceObjType = new ObjectTypeDescriptorNode(serviceObjTypeDesc.internalNode(), serviceObjTypeDesc.position(), serviceObjTypeDesc.parent());
    }

    public boolean matchesName(String name) {
        return this.serviceTypeDefinition.typeName().text().equals(name);
    }

    @Override
    public Optional<MetadataNode> metadata() {
        return this.serviceTypeDefinition.metadata();
    }

    @Override
    public Optional<Symbol> getSymbol(SemanticModel semanticModel) {
        return semanticModel.symbol((Node)this.serviceTypeDefinition);
    }

    @Override
    public Optional<TypeSymbol> typeDescriptor(SemanticModel semanticModel) {
        Object t;
        Optional serviceSymbol = semanticModel.symbol((Node)this.serviceTypeDefinition);
        if (serviceSymbol.isEmpty() || !((t = serviceSymbol.get()) instanceof TypeDefinitionSymbol)) {
            return Optional.empty();
        }
        TypeDefinitionSymbol serviceType = (TypeDefinitionSymbol)t;
        return Optional.of(serviceType.typeDescriptor());
    }

    @Override
    public SeparatedNodeList<ExpressionNode> expressions() {
        return AbstractNodeFactory.createSeparatedNodeList((Node[])new Node[0]);
    }

    @Override
    public String absoluteResourcePath() {
        Optional<MetadataNode> metadata = this.metadata();
        if (metadata.isEmpty()) {
            return DEFAULT_PATH;
        }
        Optional<AnnotationNode> serviceConfigAnnotation = this.getServiceConfigAnnotation(metadata.get());
        if (serviceConfigAnnotation.isEmpty()) {
            return DEFAULT_PATH;
        }
        Optional serviceConfig = serviceConfigAnnotation.get().annotValue();
        if (serviceConfig.isEmpty()) {
            return DEFAULT_PATH;
        }
        for (MappingFieldNode field : ((MappingConstructorExpressionNode)serviceConfig.get()).fields()) {
            Object t;
            Optional expressionNode;
            if (field.kind() != SyntaxKind.SPECIFIC_FIELD || !((SpecificFieldNode)field).fieldName().toString().trim().equals("basePath") || !(expressionNode = ((SpecificFieldNode)field).valueExpr()).isPresent() || !((t = expressionNode.get()) instanceof BasicLiteralNode)) continue;
            BasicLiteralNode literalNode = (BasicLiteralNode)t;
            return literalNode.literalToken().text().trim().replaceAll("\"", "");
        }
        return DEFAULT_PATH;
    }

    private Optional<AnnotationNode> getServiceConfigAnnotation(MetadataNode metadataNode) {
        NodeList annotations = metadataNode.annotations();
        for (AnnotationNode annotation : annotations) {
            String[] annotStrings;
            Node annotReference = annotation.annotReference();
            String annotName = annotReference.toString();
            if (annotReference.kind() != SyntaxKind.QUALIFIED_NAME_REFERENCE || !"ServiceConfig".equals((annotStrings = annotName.split(":"))[annotStrings.length - 1].trim()) || !"http".equals(annotStrings[0].trim())) continue;
            return Optional.of(annotation);
        }
        return Optional.empty();
    }

    @Override
    public NodeList<Node> members() {
        return this.serviceObjType.members();
    }

    @Override
    public ServiceNode.Kind kind() {
        return ServiceNode.Kind.SERVICE_OBJECT_TYPE;
    }

    @Override
    public Location location() {
        return this.serviceObjType.location();
    }

    @Override
    public int getServiceId() {
        return this.serviceId;
    }

    @Override
    public void updateAnnotations(NodeList<AnnotationNode> newAnnotations) {
        Optional metadataOpt = this.serviceTypeDefinition.metadata();
        MetadataNode updatedMetadata = metadataOpt.isEmpty() ? NodeFactory.createMetadataNode(null, newAnnotations) : ((MetadataNode)metadataOpt.get()).modify().withAnnotations(newAnnotations).apply();
        this.serviceTypeDefinition = this.serviceTypeDefinition.modify().withMetadata(updatedMetadata).apply();
    }

    @Override
    public ModuleMemberDeclarationNode getInternalNode() {
        return this.serviceTypeDefinition;
    }

    @Override
    public Optional<TypeSymbol> getInterceptorReturnType(SemanticModel semanticModel) {
        Object t;
        Optional symbol = semanticModel.symbol((Node)this.serviceTypeDefinition);
        if (symbol.isEmpty() || !((t = symbol.get()) instanceof TypeDefinitionSymbol)) {
            return Optional.empty();
        }
        TypeDefinitionSymbol serviceTypeDef = (TypeDefinitionSymbol)t;
        TypeSymbol serviceTypeSymbol = serviceTypeDef.typeDescriptor();
        if (!(serviceTypeSymbol instanceof ObjectTypeSymbol)) {
            return Optional.empty();
        }
        ObjectTypeSymbol serviceType = (ObjectTypeSymbol)serviceTypeSymbol;
        MethodSymbol methodSymbol = (MethodSymbol)serviceType.methods().get("createInterceptors");
        if (methodSymbol == null) {
            return Optional.empty();
        }
        return methodSymbol.typeDescriptor().returnTypeDescriptor();
    }
}

