/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.openapi.service.mapper.parameter;

import io.ballerina.compiler.api.SemanticModel;
import io.ballerina.compiler.api.symbols.IntersectionTypeSymbol;
import io.ballerina.compiler.api.symbols.ParameterSymbol;
import io.ballerina.compiler.api.symbols.TypeDescKind;
import io.ballerina.compiler.api.symbols.TypeReferenceTypeSymbol;
import io.ballerina.compiler.api.symbols.TypeSymbol;
import io.ballerina.compiler.api.symbols.UnionTypeSymbol;
import io.ballerina.compiler.syntax.tree.AnnotationNode;
import io.ballerina.openapi.service.mapper.model.AdditionalData;
import io.ballerina.openapi.service.mapper.model.OperationInventory;
import io.ballerina.openapi.service.mapper.model.ResourceFunction;
import io.ballerina.openapi.service.mapper.type.TypeMapper;
import io.ballerina.openapi.service.mapper.utils.MapperCommonUtils;
import io.ballerina.openapi.service.mapper.utils.MediaTypeUtils;
import io.swagger.v3.oas.models.media.Content;
import io.swagger.v3.oas.models.media.MediaType;
import io.swagger.v3.oas.models.parameters.RequestBody;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class RequestBodyMapper {
    private List<String> allowedMediaTypes = new ArrayList<String>();
    private final RequestBody requestBody = new RequestBody().required(Boolean.valueOf(true));
    private final TypeMapper typeMapper;
    private final SemanticModel semanticModel;
    private final OperationInventory operationInventory;
    private final String mediaTypeSubTypePrefix;

    public RequestBodyMapper(ParameterSymbol reqParameter, AnnotationNode annotation, OperationInventory operationInventory, ResourceFunction resourceNode, Map<String, String> apiDocs, AdditionalData additionalData, TypeMapper typeMapper) {
        this.typeMapper = typeMapper;
        this.semanticModel = additionalData.semanticModel();
        this.operationInventory = operationInventory;
        this.mediaTypeSubTypePrefix = MediaTypeUtils.extractCustomMediaType(resourceNode).orElse("");
        this.requestBody.description(apiDocs.get(reqParameter.getName().get()));
        this.extractAnnotationDetails(annotation);
        this.createReqBodyMapping(reqParameter.typeDescriptor());
    }

    public void setRequestBody() {
        this.operationInventory.overrideRequestBody(this.requestBody);
    }

    private void extractAnnotationDetails(AnnotationNode annotation) {
        if (annotation.annotReference().toString().trim().equals("http:Payload")) {
            this.allowedMediaTypes = MapperCommonUtils.extractAnnotationFieldDetails("http:Payload", "mediaType", annotation, this.semanticModel);
        }
    }

    private void createReqBodyMapping(TypeSymbol reqBodyType) {
        UnionTypeSymbol unionType = RequestBodyMapper.getUnionType(reqBodyType, this.semanticModel);
        if (Objects.nonNull(unionType)) {
            this.addReqBodyMappingForUnion(unionType);
        } else {
            this.addReqBodyMappingForSimpleType(reqBodyType);
        }
    }

    private static UnionTypeSymbol getUnionType(TypeSymbol typeSymbol, SemanticModel semanticModel) {
        if (Objects.isNull(typeSymbol)) {
            return null;
        }
        return switch (typeSymbol.typeKind()) {
            case TypeDescKind.UNION -> (UnionTypeSymbol)typeSymbol;
            case TypeDescKind.TYPE_REFERENCE -> {
                if (MediaTypeUtils.getInstance(semanticModel).isSameMediaType(typeSymbol)) {
                    yield null;
                }
                yield RequestBodyMapper.getUnionType(((TypeReferenceTypeSymbol)typeSymbol).typeDescriptor(), semanticModel);
            }
            case TypeDescKind.INTERSECTION -> RequestBodyMapper.getUnionType(((IntersectionTypeSymbol)typeSymbol).effectiveTypeDescriptor(), semanticModel);
            default -> null;
        };
    }

    private void addReqBodyMappingForUnion(UnionTypeSymbol unionType) {
        Map<String, TypeSymbol> reqContentMap = this.getReqContentMap(unionType);
        for (Map.Entry<String, TypeSymbol> entry : reqContentMap.entrySet()) {
            TypeSymbol typeSymbol = entry.getValue();
            String mediaType = entry.getKey();
            this.addRequestContent(typeSymbol, mediaType);
        }
    }

    private void addRequestContent(TypeSymbol reqBodyType, String mediaType) {
        MediaType mediaTypeObj = new MediaType();
        mediaTypeObj.setSchema(this.typeMapper.getTypeSchema(reqBodyType));
        this.updateReqBodyContentWithMediaType(mediaType, mediaTypeObj);
    }

    private void updateReqBodyContentWithMediaType(String mediaType, MediaType mediaTypeObj) {
        Content content = this.requestBody.getContent();
        if (Objects.isNull(content)) {
            content = new Content();
        }
        content.addMediaType(mediaType, mediaTypeObj);
        this.requestBody.setContent(content);
    }

    private void addReqBodyMappingForSimpleType(TypeSymbol returnType) {
        String mediaType = MediaTypeUtils.getInstance(this.semanticModel).getMediaTypeFromType(returnType, this.mediaTypeSubTypePrefix, this.allowedMediaTypes);
        this.addRequestContent(returnType, mediaType);
    }

    public Map<String, TypeSymbol> getReqContentMap(UnionTypeSymbol typeSymbol) {
        HashMap<String, List<TypeSymbol>> reqContentsList = new HashMap<String, List<TypeSymbol>>();
        this.extractBasicMembers(typeSymbol, reqContentsList);
        HashMap<String, TypeSymbol> reqContents = new HashMap<String, TypeSymbol>();
        for (Map.Entry entry : reqContentsList.entrySet()) {
            List typeSymbols = (List)entry.getValue();
            String mediaType = (String)entry.getKey();
            if (typeSymbols.size() == 1) {
                if (RequestBodyMapper.isSubTypeOfNil((TypeSymbol)typeSymbols.get(0), this.semanticModel)) {
                    this.requestBody.required(null);
                    continue;
                }
                reqContents.put(mediaType, (TypeSymbol)typeSymbols.get(0));
                continue;
            }
            if (typeSymbols.removeIf(typeSymbol1 -> RequestBodyMapper.isSubTypeOfNil(typeSymbol1, this.semanticModel))) {
                this.requestBody.required(null);
            }
            TypeSymbol[] typeSymbolArray = (TypeSymbol[])typeSymbols.toArray(TypeSymbol[]::new);
            UnionTypeSymbol unionTypeSymbol = this.semanticModel.types().builder().UNION_TYPE.withMemberTypes(typeSymbolArray).build();
            reqContents.put(mediaType, (TypeSymbol)unionTypeSymbol);
        }
        return reqContents;
    }

    private void updateReqContentMap(Map<String, List<TypeSymbol>> reqContents, TypeSymbol typesymbol, String mediaType) {
        if (reqContents.containsKey(mediaType)) {
            reqContents.get(mediaType).add(typesymbol);
        } else {
            ArrayList<TypeSymbol> typeSymbols = new ArrayList<TypeSymbol>();
            typeSymbols.add(typesymbol);
            reqContents.put(mediaType, typeSymbols);
        }
    }

    private void extractBasicMembers(UnionTypeSymbol unionTypeSymbol, Map<String, List<TypeSymbol>> reqContents) {
        MediaTypeUtils mediaTypeUtils = MediaTypeUtils.getInstance(this.semanticModel);
        if (mediaTypeUtils.isSameMediaType((TypeSymbol)unionTypeSymbol)) {
            String mediaType = mediaTypeUtils.getMediaTypeFromType((TypeSymbol)unionTypeSymbol, this.mediaTypeSubTypePrefix, this.allowedMediaTypes);
            this.updateReqContentMap(reqContents, (TypeSymbol)unionTypeSymbol, mediaType);
            return;
        }
        List directMemberTypes = unionTypeSymbol.userSpecifiedMemberTypes();
        for (TypeSymbol directMemberType : directMemberTypes) {
            if (mediaTypeUtils.isSameMediaType(directMemberType)) {
                String mediaType = mediaTypeUtils.getMediaTypeFromType(directMemberType, this.mediaTypeSubTypePrefix, this.allowedMediaTypes);
                this.updateReqContentMap(reqContents, directMemberType, mediaType);
                continue;
            }
            UnionTypeSymbol unionType = RequestBodyMapper.getUnionType(directMemberType, this.semanticModel);
            if (Objects.isNull(unionType)) {
                String mediaType = mediaTypeUtils.getMediaTypeFromType(directMemberType, this.mediaTypeSubTypePrefix, this.allowedMediaTypes);
                this.updateReqContentMap(reqContents, directMemberType, mediaType);
                continue;
            }
            this.extractBasicMembers(unionType, reqContents);
        }
    }

    private static boolean isSubTypeOfNil(TypeSymbol typeSymbol, SemanticModel semanticModel) {
        return typeSymbol.subtypeOf(semanticModel.types().NIL);
    }
}

