/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.openapi.service.mapper.type;

import io.ballerina.compiler.api.symbols.MapTypeSymbol;
import io.ballerina.compiler.api.symbols.TypeReferenceTypeSymbol;
import io.ballerina.compiler.api.symbols.TypeSymbol;
import io.ballerina.openapi.service.mapper.model.AdditionalData;
import io.ballerina.openapi.service.mapper.type.AbstractTypeMapper;
import io.ballerina.openapi.service.mapper.type.TypeMapperImpl;
import io.swagger.v3.oas.models.Components;
import io.swagger.v3.oas.models.media.ObjectSchema;
import io.swagger.v3.oas.models.media.Schema;

public class MapTypeMapper
extends AbstractTypeMapper {
    public MapTypeMapper(TypeReferenceTypeSymbol typeSymbol, AdditionalData additionalData) {
        super(typeSymbol, additionalData);
    }

    @Override
    public Schema getReferenceSchema(Components components) {
        MapTypeSymbol referredType = (MapTypeSymbol)this.typeSymbol.typeDescriptor();
        return MapTypeMapper.getSchema(referredType, components, this.additionalData).description(this.description);
    }

    public static Schema getSchema(MapTypeSymbol typeSymbol, Components components, AdditionalData additionalData) {
        TypeSymbol memberType = typeSymbol.typeParam();
        if (additionalData.semanticModel().types().JSON.subtypeOf(memberType)) {
            return new ObjectSchema();
        }
        return new ObjectSchema().additionalProperties((Object)TypeMapperImpl.getTypeSchema(memberType, components, additionalData));
    }
}

