/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.compiler.internal.parser;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.nio.charset.StandardCharsets;

public class InputReader {
    private static final int BUFFER_SIZE = 10;
    private final CharacterBuffer charsAhead = new CharacterBuffer(10);
    private final Reader reader;
    private int currentChar;

    InputReader(InputStream inputStream) {
        this.reader = new BufferedReader(new InputStreamReader(inputStream, StandardCharsets.UTF_8));
    }

    InputReader(String source) {
        this.reader = new StringReader(source);
    }

    InputReader(Reader reader) {
        this.reader = reader;
    }

    public int read() throws IOException {
        if (this.charsAhead.size > 0) {
            this.currentChar = this.charsAhead.consume();
            return this.currentChar;
        }
        this.currentChar = this.reader.read();
        return this.currentChar;
    }

    public int peek() throws IOException {
        if (this.charsAhead.size == 0) {
            this.charsAhead.add(this.reader.read());
        }
        return this.charsAhead.peek();
    }

    public int peek(int k) throws IOException {
        while (this.charsAhead.size < k) {
            this.charsAhead.add(this.reader.read());
        }
        return this.charsAhead.peek(k);
    }

    private static class CharacterBuffer {
        private final int capacity;
        private final int[] chars;
        private int endIndex = -1;
        private int startIndex = -1;
        private int size = 0;

        CharacterBuffer(int size) {
            this.capacity = size;
            this.chars = new int[size];
        }

        public void add(int c) {
            if (this.size == this.capacity) {
                throw new IndexOutOfBoundsException("buffer overflow");
            }
            this.endIndex = this.endIndex == this.capacity - 1 ? 0 : ++this.endIndex;
            if (this.size == 0) {
                this.startIndex = this.endIndex;
            }
            this.chars[this.endIndex] = c;
            ++this.size;
        }

        public int consume() {
            int token = this.chars[this.startIndex];
            --this.size;
            this.startIndex = this.startIndex == this.capacity - 1 ? 0 : ++this.startIndex;
            return token;
        }

        public int peek() {
            return this.chars[this.startIndex];
        }

        public int peek(int k) {
            if (k > this.size) {
                throw new IndexOutOfBoundsException("size: " + this.size + ", index: " + k);
            }
            int index = this.startIndex + k - 1;
            if (index >= this.capacity) {
                index -= this.capacity;
            }
            return this.chars[index];
        }
    }
}

