/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.compiler.internal.parser.tree;

import io.ballerina.compiler.internal.parser.tree.STExpressionNode;
import io.ballerina.compiler.internal.parser.tree.STNode;
import io.ballerina.compiler.internal.parser.tree.STNodeDiagnostic;
import io.ballerina.compiler.internal.parser.tree.STNodeTransformer;
import io.ballerina.compiler.internal.parser.tree.STNodeVisitor;
import io.ballerina.compiler.syntax.tree.AnnotAccessExpressionNode;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NonTerminalNode;
import io.ballerina.compiler.syntax.tree.SyntaxKind;
import java.util.Collection;
import java.util.Collections;

public class STAnnotAccessExpressionNode
extends STExpressionNode {
    public final STNode expression;
    public final STNode annotChainingToken;
    public final STNode annotTagReference;

    STAnnotAccessExpressionNode(STNode expression, STNode annotChainingToken, STNode annotTagReference) {
        this(expression, annotChainingToken, annotTagReference, Collections.emptyList());
    }

    STAnnotAccessExpressionNode(STNode expression, STNode annotChainingToken, STNode annotTagReference, Collection<STNodeDiagnostic> diagnostics) {
        super(SyntaxKind.ANNOT_ACCESS, diagnostics);
        this.expression = expression;
        this.annotChainingToken = annotChainingToken;
        this.annotTagReference = annotTagReference;
        this.addChildren(expression, annotChainingToken, annotTagReference);
    }

    @Override
    public STNode modifyWith(Collection<STNodeDiagnostic> diagnostics) {
        return new STAnnotAccessExpressionNode(this.expression, this.annotChainingToken, this.annotTagReference, diagnostics);
    }

    public STAnnotAccessExpressionNode modify(STNode expression, STNode annotChainingToken, STNode annotTagReference) {
        if (this.checkForReferenceEquality(expression, annotChainingToken, annotTagReference)) {
            return this;
        }
        return new STAnnotAccessExpressionNode(expression, annotChainingToken, annotTagReference, this.diagnostics);
    }

    @Override
    public Node createFacade(int position, NonTerminalNode parent) {
        return new AnnotAccessExpressionNode(this, position, parent);
    }

    @Override
    public void accept(STNodeVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public <T> T apply(STNodeTransformer<T> transformer) {
        return transformer.transform(this);
    }
}

