/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.compiler.internal.parser.tree;

import io.ballerina.compiler.internal.parser.tree.STActionNode;
import io.ballerina.compiler.internal.parser.tree.STNode;
import io.ballerina.compiler.internal.parser.tree.STNodeDiagnostic;
import io.ballerina.compiler.internal.parser.tree.STNodeTransformer;
import io.ballerina.compiler.internal.parser.tree.STNodeVisitor;
import io.ballerina.compiler.syntax.tree.AsyncSendActionNode;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NonTerminalNode;
import io.ballerina.compiler.syntax.tree.SyntaxKind;
import java.util.Collection;
import java.util.Collections;

public class STAsyncSendActionNode
extends STActionNode {
    public final STNode expression;
    public final STNode rightArrowToken;
    public final STNode peerWorker;

    STAsyncSendActionNode(STNode expression, STNode rightArrowToken, STNode peerWorker) {
        this(expression, rightArrowToken, peerWorker, Collections.emptyList());
    }

    STAsyncSendActionNode(STNode expression, STNode rightArrowToken, STNode peerWorker, Collection<STNodeDiagnostic> diagnostics) {
        super(SyntaxKind.ASYNC_SEND_ACTION, diagnostics);
        this.expression = expression;
        this.rightArrowToken = rightArrowToken;
        this.peerWorker = peerWorker;
        this.addChildren(expression, rightArrowToken, peerWorker);
    }

    @Override
    public STNode modifyWith(Collection<STNodeDiagnostic> diagnostics) {
        return new STAsyncSendActionNode(this.expression, this.rightArrowToken, this.peerWorker, diagnostics);
    }

    public STAsyncSendActionNode modify(STNode expression, STNode rightArrowToken, STNode peerWorker) {
        if (this.checkForReferenceEquality(expression, rightArrowToken, peerWorker)) {
            return this;
        }
        return new STAsyncSendActionNode(expression, rightArrowToken, peerWorker, this.diagnostics);
    }

    @Override
    public Node createFacade(int position, NonTerminalNode parent) {
        return new AsyncSendActionNode(this, position, parent);
    }

    @Override
    public void accept(STNodeVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public <T> T apply(STNodeTransformer<T> transformer) {
        return transformer.transform(this);
    }
}

